/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessIntegrationTest;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureChainingTest;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.CatalogUtilities;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.Types;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.expression.FeaturePropertyAccessorFactory;
import org.geotools.gml3.GMLSchema;
import org.geotools.xml.SchemaIndex;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSchemaDataAccessIntegrationTest
extends DataAccessIntegrationTest {
    private static final String MO_URI = "urn:cgi:xmlns:GGIC:MineralOccurrence:1.0";
    private static final Name EARTH_RESOURCE = Types.typeName((String)"urn:cgi:xmlns:GGIC:MineralOccurrence:1.0", (String)"EarthResource");
    private static final Name EARTH_RESOURCE_TYPE = Types.typeName((String)"urn:cgi:xmlns:GGIC:MineralOccurrence:1.0", (String)"EarthResourceType");
    private static final Name MINERAL_DEPOSIT_TYPE = Types.typeName((String)"urn:cgi:xmlns:GGIC:MineralOccurrence:1.0", (String)"MineralDepositModelType");
    private static final Name MINERAL_DEPOSIT_PROPERTY_TYPE = Types.typeName((String)"urn:cgi:xmlns:GGIC:MineralOccurrence:1.0", (String)"MineralDepositModelPropertyType");
    private static DataAccess<FeatureType, Feature> newGuDataAccess;

    @BeforeClass
    public static void setUp() throws Exception {
        HashMap<String, Object> moParams = new HashMap<String, Object>();
        moParams.put("dbtype", "mo-data-access");
        moParams.put("directory", AppSchemaDataAccessIntegrationTest.class.getResource("/test-data/"));
        DataAccessFinder.getDataStore(moParams);
        DataAccessIntegrationTest.setFilterFactory();
        AppSchemaDataAccessIntegrationTest.loadGeologicUnitDataAccess();
        AppSchemaDataAccessIntegrationTest.loadDataAccesses("MappedFeatureAsOccurrence.xml");
    }

    @AfterClass
    public static void tearDown() {
        DataAccessRegistry.unregisterAll();
    }

    private static void loadGeologicUnitDataAccess() throws IOException {
        URL url = AppSchemaDataAccessIntegrationTest.class.getResource("/test-data/EarthResourceToGeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        newGuDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull(newGuDataAccess);
        guFeatureSource = newGuDataAccess.getFeatureSource(GEOLOGIC_UNIT);
        Assert.assertNotNull((Object)guFeatureSource);
    }

    private static ArrayList<Feature> getInputFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> fCollection, ComplexType complexType) throws IOException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        FeatureTypeImpl earthResourceType = new FeatureTypeImpl(complexType.getName(), complexType.getDescriptors(), null, true, complexType.getRestrictions(), (AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);
        AttributeDescriptorImpl featureDesc = new AttributeDescriptorImpl((AttributeType)earthResourceType, EARTH_RESOURCE, 0, -1, false, null);
        ComplexType mineralDepositType = (ComplexType)typeRegistry.getAttributeType(MINERAL_DEPOSIT_TYPE);
        ComplexType mineralDepositPropertyType = (ComplexType)typeRegistry.getAttributeType(MINERAL_DEPOSIT_PROPERTY_TYPE);
        NameImpl name = new NameImpl(null, "simpleContent");
        AttributeType simpleContentType = typeRegistry.getAttributeType(Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)"string"));
        AttributeDescriptorImpl stringDescriptor = new AttributeDescriptorImpl(simpleContentType, (Name)name, 1, 1, true, (Object)null);
        Iterator simpleFeatures = fCollection.iterator();
        AttributeDescriptor nameDescriptor = (AttributeDescriptor)GMLSchema.ABSTRACTGMLTYPE_TYPE.getDescriptor(Types.typeName((String)"http://www.opengis.net/gml", (String)"name"));
        while (simpleFeatures.hasNext()) {
            String[] mfIds;
            String[] cpIds;
            SimpleFeature next = (SimpleFeature)simpleFeatures.next();
            ArrayList<Object> properties = new ArrayList<Object>();
            ArrayList<Object> value = new ArrayList<Object>();
            String propertyName = "FORM";
            value.add(new AttributeImpl(next.getProperty(propertyName).getValue(), (AttributeDescriptor)stringDescriptor, null));
            properties.add(new ComplexAttributeImpl(value, (AttributeDescriptor)earthResourceType.getDescriptor(Types.typeName((String)MO_URI, (String)"form")), null));
            value = new ArrayList();
            value.add(new AttributeImpl((Object)("gu." + next.getID()), (AttributeDescriptor)stringDescriptor, null));
            ComplexAttributeImpl name1 = new ComplexAttributeImpl(value, nameDescriptor, null);
            properties.add(name1);
            value = new ArrayList();
            value.add(new AttributeImpl((Object)("er." + next.getID()), (AttributeDescriptor)stringDescriptor, null));
            ComplexAttributeImpl name2 = new ComplexAttributeImpl(value, nameDescriptor, null);
            properties.add(name2);
            propertyName = "CLASSIFICATION";
            ComplexAttributeImpl classification = new ComplexAttributeImpl(new ArrayList(), (AttributeDescriptor)earthResourceType.getDescriptor(Types.typeName((String)MO_URI, (String)"classification")), null);
            value = new ArrayList();
            value.add(new AttributeImpl(next.getProperty(propertyName).getValue(), (AttributeDescriptor)stringDescriptor, null));
            Name leafAttribute = Types.typeName((String)MO_URI, (String)"mineralDepositGroup");
            AttributeImpl mineralDepositGroup = new AttributeImpl(value, (AttributeDescriptor)mineralDepositType.getDescriptor(leafAttribute), null);
            value = new ArrayList();
            value.add(mineralDepositGroup);
            ComplexAttributeImpl mineralDepositModel = new ComplexAttributeImpl(value, (AttributeDescriptor)mineralDepositPropertyType.getDescriptor(Types.typeName((String)MO_URI, (String)"MineralDepositModel")), null);
            value = new ArrayList();
            value.add(mineralDepositModel);
            classification.setValue(value);
            properties.add(classification);
            propertyName = "COMPOSITION";
            for (String cpId : cpIds = next.getProperty(propertyName).getValue().toString().split(",")) {
                ArrayList<AttributeImpl> cpProperties = new ArrayList<AttributeImpl>(cpIds.length);
                cpProperties.add(new AttributeImpl((Object)cpId, (AttributeDescriptor)stringDescriptor, null));
                properties.add(new AttributeImpl(cpProperties, (AttributeDescriptor)earthResourceType.getDescriptor(Types.typeName((String)MO_URI, (String)"composition")), null));
            }
            propertyName = "COMMODITYDESCRIPTION";
            for (String mfId : mfIds = next.getProperty(propertyName).getValue().toString().split(",")) {
                ArrayList<AttributeImpl> mfProperties = new ArrayList<AttributeImpl>();
                mfProperties.add(new AttributeImpl((Object)mfId, (AttributeDescriptor)stringDescriptor, null));
                properties.add(new AttributeImpl(mfProperties, (AttributeDescriptor)earthResourceType.getDescriptor(Types.typeName((String)MO_URI, (String)"commodityDescription")), null));
            }
            features.add((Feature)new FeatureImpl(properties, (AttributeDescriptor)featureDesc, next.getIdentifier()));
        }
        fCollection.close(simpleFeatures);
        return features;
    }

    @Test
    public void testLoadDataAccess() throws IOException, URISyntaxException {
        FeatureCollection guFeatures = guFeatureSource.getFeatures();
        Iterator guIterator = guFeatures.iterator();
        ArrayList<String> guIds = new ArrayList<String>();
        while (guIterator.hasNext()) {
            guIds.add(((Feature)guIterator.next()).getIdentifier().toString());
        }
        guFeatures.close(guIterator);
        File dir = new File(this.getClass().getResource("/test-data/").toURI());
        PropertyDataStore dataStore = new PropertyDataStore(dir);
        FeatureSource simpleFeatureSource = dataStore.getFeatureSource(EARTH_RESOURCE);
        FeatureCollection moFeatures = simpleFeatureSource.getFeatures();
        Iterator moIterator = moFeatures.iterator();
        ArrayList<String> moIds = new ArrayList<String>();
        while (moIterator.hasNext()) {
            moIds.add(((SimpleFeature)moIterator.next()).getIdentifier().toString());
        }
        moFeatures.close(moIterator);
        Assert.assertEquals((long)guIds.size(), (long)moIds.size());
        Assert.assertEquals((Object)guIds.containsAll(moIds), (Object)true);
    }

    @Override
    @Test
    public void testMappings() throws IOException {
        FeatureCollection guCollection = guFeatureSource.getFeatures();
        AbstractMappingFeatureIterator iterator = (AbstractMappingFeatureIterator)guCollection.iterator();
        FeatureTypeMapping guSchema = AppSchemaDataAccessRegistry.getMapping((Name)GEOLOGIC_UNIT);
        Hints hints = new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)guSchema.getNamespaces());
        String composition = "composition";
        String occurrence = "occurence";
        String commodity = "commodityDescription";
        ArrayList<AttributeMapping> otherMappings = new ArrayList<AttributeMapping>();
        AttributeMapping compositionMapping = null;
        AttributeMapping occurrenceMapping = null;
        for (AttributeMapping attMapping : guSchema.getAttributeMappings()) {
            String attName = attMapping.getTargetXPath().toString();
            if (attName.equals("gsml:composition")) {
                compositionMapping = attMapping;
                continue;
            }
            if (attName.equals("gsml:occurence")) {
                occurrenceMapping = attMapping;
                continue;
            }
            otherMappings.add(attMapping);
        }
        Assert.assertNotNull(occurrenceMapping);
        Assert.assertNotNull(compositionMapping);
        Assert.assertEquals((long)otherMappings.size(), (long)(guSchema.getAttributeMappings().size() - 2));
        int guCount = 0;
        ArrayList<Feature> guFeatures = new ArrayList<Feature>();
        while (iterator.hasNext()) {
            Feature next = iterator.next();
            FeatureId fId = next.getIdentifier();
            Feature moFeature = null;
            for (Feature inputFeature : inputFeatures) {
                if (!iterator.featureFidMapping.evaluate((Object)inputFeature).equals(fId)) continue;
                moFeature = inputFeature;
            }
            Assert.assertNotNull(moFeature);
            Collection gsmlCompositions = next.getProperties("composition");
            Collection moCompositions = moFeature.getProperties("composition");
            ArrayList<String> cpIds = new ArrayList<String>();
            for (Property inputProperty : moCompositions) {
                Collection values = (Collection)inputProperty.getValue();
                for (Attribute attrib : values) {
                    cpIds.add(attrib.getValue().toString());
                }
            }
            Assert.assertEquals((Object)(cpIds.size() > 0 ? 1 : 0), (Object)true);
            Assert.assertEquals((long)gsmlCompositions.size(), (long)cpIds.size());
            ArrayList<String> nestedCpIds = new ArrayList<String>(cpIds.size());
            for (Property outputProperty : gsmlCompositions) {
                Collection values = (Collection)outputProperty.getValue();
                Feature compositionPart = (Feature)values.iterator().next();
                Assert.assertEquals((Object)cpFeatures.contains(compositionPart), (Object)true);
                nestedCpIds.add(compositionPart.getIdentifier().toString());
            }
            Assert.assertEquals((Object)cpIds.containsAll(nestedCpIds), (Object)true);
            Collection occurrences = next.getProperties("occurence");
            Collection commodities = moFeature.getProperties("commodityDescription");
            ArrayList<String> mfIds = new ArrayList<String>();
            for (Property property : commodities) {
                Collection values = (Collection)property.getValue();
                for (Attribute attrib : values) {
                    mfIds.add(attrib.getValue().toString());
                }
            }
            Assert.assertEquals((Object)(mfIds.size() > 0 ? 1 : 0), (Object)true);
            Assert.assertEquals((long)occurrences.size(), (long)mfIds.size());
            ArrayList<String> nestedMfIds = new ArrayList<String>(mfIds.size());
            for (Property mf : occurrences) {
                Collection values = (Collection)mf.getValue();
                Feature mfFeature = (Feature)values.iterator().next();
                Assert.assertEquals((Object)mfFeatures.contains(mfFeature), (Object)true);
                nestedMfIds.add(mfFeature.getIdentifier().toString());
            }
            Assert.assertEquals((Object)mfIds.containsAll(nestedMfIds), (Object)true);
            Assert.assertEquals((long)next.getProperties("name").size(), (long)2L);
            for (AttributeMapping attMapping : otherMappings) {
                Expression sourceExpr = attMapping.getSourceExpression();
                if (!(sourceExpr instanceof AttributeExpressionImpl)) continue;
                AttributeExpressionImpl outputExpr = new AttributeExpressionImpl(attMapping.getTargetXPath().toString(), hints);
                Object inputValue = sourceExpr.evaluate((Object)moFeature);
                while (inputValue instanceof Attribute) {
                    inputValue = ((Attribute)inputValue).getValue();
                }
                Object outputValue = outputExpr.evaluate((Object)next);
                while (outputValue instanceof Attribute) {
                    outputValue = ((Attribute)outputValue).getValue();
                }
                Assert.assertEquals((Object)inputValue, (Object)outputValue);
            }
            guFeatures.add(next);
            ++guCount;
        }
        Assert.assertEquals((long)guCount, (long)inputFeatures.size());
        mfDataAccess.dispose();
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = this.getClass().getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        FeatureType mappedFeatureType = mfDataAccess.getSchema(MAPPED_FEATURE);
        Assert.assertNotNull((Object)mappedFeatureType);
        FeatureSource mfSource = mfDataAccess.getFeatureSource(MAPPED_FEATURE);
        FeatureCollection mfCollection = mfSource.getFeatures();
        Iterator mfIterator = mfCollection.iterator();
        while (mfIterator.hasNext()) {
            Feature mf = (Feature)mfIterator.next();
            Property spec = mf.getProperty("specification");
            Assert.assertNotNull((Object)spec);
            Object guObject = spec.getValue();
            Assert.assertNotNull((Object)guObject);
            Assert.assertEquals((Object)(guObject instanceof Collection), (Object)true);
            Assert.assertEquals((long)((Collection)guObject).size(), (long)1L);
            guObject = ((Collection)guObject).iterator().next();
            Assert.assertEquals((Object)(guObject instanceof Feature), (Object)true);
            Feature guFeature = (Feature)guObject;
            Assert.assertEquals((Object)guFeatures.contains(guFeature), (Object)true);
            String propertyGuId = FeatureChainingTest.mfToGuMap.get(mf.getIdentifier().toString()).split("gu.")[1];
            Assert.assertEquals((Object)((Feature)guObject).getIdentifier().toString(), (Object)propertyGuId);
        }
        mfCollection.close(mfIterator);
        mfDataAccess.dispose();
    }

    @Override
    public void testFilters() throws IOException {
        PropertyName property = ff.property("gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value");
        Literal string = ff.literal((Object)"significant");
        Function function = ff.function("contains_text", new Expression[]{property, string});
        PropertyIsEqualTo filter = ff.equals((Expression)function, (Expression)ff.literal(1));
        FeatureCollection filteredResults = guFeatureSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)filteredResults), (long)2L);
        mfDataAccess.dispose();
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = this.getClass().getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        FeatureSource mfSource = mfDataAccess.getFeatureSource(MAPPED_FEATURE);
        property = ff.property("gsml:specification/gsml:GeologicUnit/gsml:bodyMorphology/gsml:CGI_TermValue/gsml:value");
        string = ff.literal((Object)"vein");
        function = ff.function("contains_text", new Expression[]{property, string});
        filter = ff.equals((Expression)function, (Expression)ff.literal(1));
        filteredResults = mfSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)filteredResults), (long)2L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MinOccDataAccessFactory
    extends DataAccessIntegrationTest.InputDataAccessFactory {
        @Override
        public DataAccess<? extends FeatureType, ? extends Feature> createDataStore(Map<String, Serializable> params) throws IOException {
            File fileDir;
            String schemaLocation = "/commonSchemas_new/mineralOccurrence/mineralOccurrence.xsd";
            String typeName = EARTH_RESOURCE.getLocalPart();
            URL schemaDir = (URL)params.get("directory");
            try {
                fileDir = new File(schemaDir.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            PropertyDataStore dataStore = new PropertyDataStore(fileDir);
            FeatureSource simpleFeatureSource = dataStore.getFeatureSource(typeName);
            FeatureCollection fCollection = simpleFeatureSource.getFeatures();
            DataAccessIntegrationTest.reader = EmfAppSchemaReader.newInstance();
            DataAccessIntegrationTest.typeRegistry = new FeatureTypeRegistry();
            URL catalogLocation = this.getClass().getResource("/test-data/mappedPolygons.oasis.xml");
            DataAccessIntegrationTest.reader.setCatalog(CatalogUtilities.buildPrivateCatalog((URL)catalogLocation));
            SchemaIndex schemaIndex = DataAccessIntegrationTest.reader.parse(new URL(schemaDir.toString() + schemaLocation), null);
            DataAccessIntegrationTest.typeRegistry.addSchemas(schemaIndex);
            ComplexType complexType = (ComplexType)DataAccessIntegrationTest.typeRegistry.getAttributeType(EARTH_RESOURCE_TYPE);
            DataAccessIntegrationTest.inputFeatures = AppSchemaDataAccessIntegrationTest.getInputFeatures((FeatureCollection<SimpleFeatureType, SimpleFeature>)fCollection, complexType);
            return new DataAccessIntegrationTest.InputDataAccessFactory.InputDataAccess(this, DataAccessIntegrationTest.inputFeatures, simpleFeatureSource.getSchema());
        }

        @Override
        public boolean canProcess(Map<String, Serializable> params) {
            Serializable dbType = params.get("dbtype");
            return dbType == null ? false : dbType.equals("mo-data-access");
        }
    }
}

