/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AppSchemaFeatureFactoryImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.Types;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.util.logging.Logging;
import org.geotools.xlink.XLINK;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingFeatureIterator
implements IMappingFeatureIterator {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.complex");
    public static final Name XLINK_HREF_NAME = Types.toTypeName(XLINK.HREF);
    protected FeatureTypeMapping mapping;
    protected Expression featureFidMapping;
    protected FeatureFactory attf;
    protected AppSchemaDataAccess store;
    protected final XPath xpathAttributeBuilder;
    protected FilterFactory namespaceAwareFilterFactory;
    protected final int maxFeatures;
    protected int featureCounter;
    protected NamespaceSupport namespaces;
    private boolean hasNextCalled = false;

    public AbstractMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) throws IOException {
        this.store = store;
        this.attf = new AppSchemaFeatureFactoryImpl();
        Name name = mapping.getTargetFeature().getName();
        List<AttributeMapping> attributeMappings = mapping.getAttributeMappings();
        for (AttributeMapping attMapping : attributeMappings) {
            XPath.Step step;
            QName stepName;
            XPath.StepList targetXPath = attMapping.getTargetXPath();
            if (targetXPath.size() > 1 || !Types.equals(name, stepName = (step = (XPath.Step)targetXPath.get(0)).getName())) continue;
            this.featureFidMapping = attMapping.getIdentifierExpression();
            break;
        }
        this.mapping = mapping;
        if (this.featureFidMapping == null || Expression.NIL.equals(this.featureFidMapping)) {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            this.featureFidMapping = ff.property("@id");
        }
        Query unrolledQuery = this.getUnrolledQuery(query);
        this.initialiseSourceFeatures(mapping, unrolledQuery);
        this.xpathAttributeBuilder = new XPath();
        this.xpathAttributeBuilder.setFeatureFactory(this.attf);
        this.namespaces = mapping.getNamespaces();
        this.namespaceAwareFilterFactory = new FilterFactoryImplNamespaceAware(this.namespaces);
        this.xpathAttributeBuilder.setFilterFactory(this.namespaceAwareFilterFactory);
        this.maxFeatures = query.getMaxFeatures();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.closeSourceFeatures();
    }

    protected abstract String extractIdForAttribute(Expression var1, Object var2);

    @Override
    public Feature next() {
        Feature next;
        if (!this.hasNext()) {
            throw new IllegalStateException("there are no more features in this iterator");
        }
        this.hasNextCalled = false;
        try {
            next = this.computeNext();
        }
        catch (IOException e) {
            this.close();
            throw new RuntimeException(e);
        }
        ++this.featureCounter;
        return next;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextCalled) {
            return !this.isNextSourceFeatureNull();
        }
        boolean exists = false;
        if (this.featureCounter >= this.maxFeatures) {
            return false;
        }
        if (this.isSourceFeatureIteratorNull()) {
            return false;
        }
        exists = this.unprocessedFeatureExists();
        if (!exists) {
            LOGGER.finest("no more features, produced " + this.featureCounter);
            this.close();
            this.hasNextCalled = true;
        }
        return exists;
    }

    protected Query getUnrolledQuery(Query query) {
        return this.store.unrollQuery(query, this.mapping);
    }

    protected Feature computeNext() throws IOException {
        if (!this.hasNextCalled && !this.hasNext()) {
            return null;
        }
        this.hasNextCalled = false;
        if (this.isNextSourceFeatureNull()) {
            throw new UnsupportedOperationException("No more features produced!");
        }
        String id = this.extractIdForFeature();
        Feature target = this.populateFeatureData(id);
        if (target.getDefaultGeometryProperty() == null) {
            this.setGeometry(target);
        }
        return target;
    }

    protected void setGeometry(Feature feature) {
        for (Property property : feature.getProperties()) {
            if (!Geometry.class.isAssignableFrom(property.getType().getBinding())) continue;
            AttributeType type = (AttributeType)property.getType();
            GeometryTypeImpl geometryType = new GeometryTypeImpl(type.getName(), type.getBinding(), null, type.isIdentified(), type.isAbstract(), type.getRestrictions(), type.getSuper(), type.getDescription());
            AttributeDescriptor descriptor = (AttributeDescriptor)property.getDescriptor();
            GeometryDescriptorImpl geometryDescriptor = new GeometryDescriptorImpl((GeometryType)geometryType, descriptor.getName(), descriptor.getMinOccurs(), descriptor.getMaxOccurs(), property.isNillable(), null);
            GeometryAttributeImpl geometryAttribute = new GeometryAttributeImpl(property.getValue(), (GeometryDescriptor)geometryDescriptor, null);
            ArrayList<GeometryAttributeImpl> properties = new ArrayList<GeometryAttributeImpl>(feature.getProperties());
            properties.remove(property);
            properties.add(geometryAttribute);
            feature.setValue(properties);
            feature.setDefaultGeometryProperty((GeometryAttribute)geometryAttribute);
            break;
        }
    }

    protected boolean isHasNextCalled() {
        return this.hasNextCalled;
    }

    protected void setHasNextCalled(boolean hasNextCalled) {
        this.hasNextCalled = hasNextCalled;
    }

    protected abstract void closeSourceFeatures();

    protected abstract Iterator<?> getSourceFeatureIterator();

    protected abstract void initialiseSourceFeatures(FeatureTypeMapping var1, Query var2) throws IOException;

    protected abstract boolean unprocessedFeatureExists();

    protected abstract boolean sourceFeatureIteratorHasNext();

    protected abstract String extractIdForFeature();

    protected abstract boolean isNextSourceFeatureNull();

    protected abstract Feature populateFeatureData(String var1) throws IOException;

    protected abstract Object getValue(Expression var1, Object var2);

    protected abstract boolean isSourceFeatureIteratorNull();

    protected abstract void setClientProperties(Attribute var1, Object var2, Map<Name, Expression> var3);
}

