/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.jndi;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.geotools.arcsde.jndi.SharedSessionPool;
import org.geotools.arcsde.logging.Loggers;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.ISessionPoolFactory;
import org.geotools.arcsde.session.SessionPoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcSDEConnectionFactory
implements ObjectFactory {
    private static final Logger LOGGER = Loggers.getLogger("org.geotools.arcsde.jndi");
    private ISessionPoolFactory closablePoolFactory = SessionPoolFactory.getInstance();

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        LOGGER.info("ArcSDEConnectionFactory: ref is " + ref);
        String className = ref.getClassName();
        LOGGER.info("ArcSDEConnectionFactory: className is " + className);
        this.checkAlternateSessionPoolFactory(ref);
        ISessionPool dereferencedObject = null;
        if (ISessionPool.class.getName().equals(className)) {
            ArcSDEConnectionConfig config = this.createConfig(ref);
            LOGGER.info("ArcSDEConnectionFactory: config is " + config);
            ISessionPool sharedPool = this.getSharedPool(config);
            LOGGER.info("ArcSDEConnectionFactory: shared pool is " + sharedPool);
            dereferencedObject = sharedPool;
        } else {
            LOGGER.info("ArcSDEConnectionFactory: not a config");
        }
        return dereferencedObject;
    }

    public ISessionPool getInstance(Map<String, Serializable> properties) throws IOException {
        ArcSDEConnectionConfig config = ArcSDEConnectionConfig.fromMap(properties);
        return this.getInstance(config);
    }

    public ISessionPool getInstance(ArcSDEConnectionConfig config) throws IOException {
        this.validate(config);
        ISessionPool sharedPool = this.getSharedPool(config);
        return sharedPool;
    }

    private void checkAlternateSessionPoolFactory(Reference ref) {
        ISessionPoolFactory newFactory;
        String poolFactoryClassName = this.getProperty(ref, "sessionPoolFactory", null);
        if (poolFactoryClassName == null) {
            return;
        }
        LOGGER.info("Using alternate session pool factory " + poolFactoryClassName);
        try {
            Class<?> factoryClass = Class.forName(poolFactoryClassName);
            newFactory = (ISessionPoolFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Alternate SessionPoolFactory class not found: " + poolFactoryClassName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        this.setClosableSessionPoolFactory(newFactory);
    }

    public void setClosableSessionPoolFactory(ISessionPoolFactory newFactory) {
        this.closablePoolFactory = newFactory;
    }

    private ISessionPool getSharedPool(ArcSDEConnectionConfig config) throws IOException {
        ISessionPool sharedPool = SharedSessionPool.getInstance(config, this.closablePoolFactory);
        return sharedPool;
    }

    private ArcSDEConnectionConfig createConfig(Reference ref) {
        LOGGER.info("ArcSDEConnectionFactory: creating config");
        String server = this.getProperty(ref, "server", null);
        String port = this.getProperty(ref, "port", null);
        String user = this.getProperty(ref, "user", null);
        String password = this.getProperty(ref, "password", null);
        String instance = this.getProperty(ref, "instance", null);
        String minConnections = this.getProperty(ref, "pool.minConnections", "1");
        String maxConnections = this.getProperty(ref, "pool.maxConnections", "6");
        String connTimeout = this.getProperty(ref, "pool.timeOut", "500");
        ArcSDEConnectionConfig config = new ArcSDEConnectionConfig();
        config.setServerName(server);
        config.setPortNumber(port);
        config.setDatabaseName(instance);
        config.setUserName(user);
        config.setPassword(password);
        config.setMinConnections(Integer.parseInt(minConnections));
        config.setMaxConnections(Integer.parseInt(maxConnections));
        config.setConnTimeOut(Integer.parseInt(connTimeout));
        this.validate(config);
        return config;
    }

    private void validate(ArcSDEConnectionConfig config) {
        if (config.getServerName() == null) {
            throw new IllegalArgumentException("Missing param: server");
        }
        if (config.getPortNumber() == null) {
            throw new IllegalArgumentException("Missing param: port");
        }
        if (config.getUserName() == null) {
            throw new IllegalArgumentException("Missing param: user");
        }
        if (config.getPassword() == null) {
            throw new IllegalArgumentException("Missing param: password");
        }
    }

    protected String getProperty(Reference ref, String propName, String defValue) {
        RefAddr addr = ref.get(propName);
        if (addr == null) {
            return defValue;
        }
        return (String)addr.getContent();
    }
}

