/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.versioning;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeStreamOp;
import com.esri.sde.sdk.client.SeVersion;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.logging.Loggers;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.Commands;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;

public class TransactionVersionHandler
implements ArcSdeVersionHandler {
    private static final Logger LOGGER = Loggers.getLogger(TransactionVersionHandler.class.getName());
    private final ISession session;
    private final SeVersion version;
    private SeState transactionState;

    public TransactionVersionHandler(ISession session, String versionName) throws IOException {
        this.session = session;
        LOGGER.finest("Fetching information for version " + versionName);
        this.version = session.issue(new Commands.GetVersionCommand(versionName));
    }

    public void setUpStream(ISession session, final SeStreamOp streamOperation) throws IOException {
        session.issue(new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                LOGGER.finest("setting up stream for transaction on a versioned table");
                if (TransactionVersionHandler.this.transactionState == null) {
                    LOGGER.finer("no transaction state created yet, about to create a new state for the transaction");
                    try {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Refreshing '" + TransactionVersionHandler.this.version.getName() + "' version info");
                        }
                        TransactionVersionHandler.this.version.getInfo();
                        LOGGER.finest("Getting version state");
                        SeState currentState = new SeState(connection, TransactionVersionHandler.this.version.getStateId());
                        long currentStateId = currentState.getId().longValue();
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer(TransactionVersionHandler.this.version.getName() + "version state: " + currentStateId + ", open: " + currentState.isOpen() + ", owner: " + currentState.getOwner() + ", current user: " + connection.getUser());
                        }
                        LOGGER.finer("Creating new state for the transaction...");
                        TransactionVersionHandler.this.transactionState = session.createChildState(currentStateId);
                        LOGGER.finer("New transaction state: " + TransactionVersionHandler.this.transactionState.getId() + ", parent: " + TransactionVersionHandler.this.transactionState.getParentId().longValue());
                        LOGGER.finer("Locking the transaction state");
                        TransactionVersionHandler.this.transactionState.lock();
                        LOGGER.finer("Transaction state locked");
                    }
                    catch (SeException e) {
                        throw new ArcSdeException(e);
                    }
                }
                SeObjectId differencesId = new SeObjectId((long)SeState.SE_NULL_STATE_ID);
                SeObjectId currentStateId = TransactionVersionHandler.this.transactionState.getId();
                streamOperation.setState(currentStateId, differencesId, SeState.SE_STATE_DIFF_NOCHECK);
                return null;
            }
        });
    }

    public void editOperationWritten(SeStreamOp editOperation) throws IOException {
    }

    public void editOperationFailed(SeStreamOp editOperation) throws IOException {
    }

    public void commitEditState() throws IOException {
        LOGGER.fine("Commiting versioned state");
        if (this.transactionState == null) {
            LOGGER.fine("Already commited, ignoring operation");
            return;
        }
        this.session.issue(new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                SeObjectId transactionStateId = TransactionVersionHandler.this.transactionState.getId();
                LOGGER.finer("Refreshing version info");
                TransactionVersionHandler.this.version.getInfo();
                LOGGER.finer("Chaning version '" + TransactionVersionHandler.this.version.getName() + "' state to point to transaction state " + transactionStateId);
                TransactionVersionHandler.this.version.changeState(transactionStateId);
                LOGGER.finer("Freeing transaction state lock");
                TransactionVersionHandler.this.transactionState.freeLock();
                TransactionVersionHandler.this.transactionState = null;
                return null;
            }
        });
    }

    public void rollbackEditState() throws IOException {
        LOGGER.finer("Rolling back versioned transaction state");
        if (this.transactionState == null) {
            LOGGER.finer("Already rolled back, ignoring operation");
            return;
        }
        this.session.issue(new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                try {
                    LOGGER.finer("Releasing lock on transaction state " + TransactionVersionHandler.this.transactionState.getId().longValue());
                    TransactionVersionHandler.this.transactionState.freeLock();
                }
                catch (SeException seException) {
                    // empty catch block
                }
                LOGGER.finer("Deleting transaction state " + TransactionVersionHandler.this.transactionState.getId().longValue());
                TransactionVersionHandler.this.transactionState.delete();
                TransactionVersionHandler.this.transactionState = null;
                return null;
            }
        });
    }
}

