/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSdeFeatureSource;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcSdeFeatureCollection
extends DataFeatureCollection {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.data");
    private final ArcSdeFeatureSource featureSource;
    private final Query query;
    private final SimpleFeatureType childrenSchema;

    public ArcSdeFeatureCollection(ArcSdeFeatureSource featureSource, SimpleFeatureType queryType, Query namedQuery) throws IOException {
        this.featureSource = featureSource;
        this.query = namedQuery;
        this.childrenSchema = queryType;
    }

    public final synchronized SimpleFeatureType getSchema() {
        return this.childrenSchema;
    }

    public final ReferencedEnvelope getBounds() {
        ReferencedEnvelope bounds;
        LOGGER.info("Getting collection bounds");
        try {
            bounds = this.featureSource.getBounds(this.query);
            if (bounds == null) {
                LOGGER.info("FeatureSource returned null bounds, going to return an empty one");
                bounds = new ReferencedEnvelope(this.getCRS());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Error getting collection bounts", e);
            bounds = new ReferencedEnvelope(this.getCRS());
        }
        return bounds;
    }

    private CoordinateReferenceSystem getCRS() {
        GeometryDescriptor defaultGeometry = this.featureSource.getSchema().getGeometryDescriptor();
        return defaultGeometry == null ? null : defaultGeometry.getCoordinateReferenceSystem();
    }

    public final int getCount() throws IOException {
        return this.featureSource.getCount(this.query);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.featureSource.getfeatureReader(this.childrenSchema, this.query);
        return reader;
    }
}

