/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import com.sun.imageio.plugins.common.BogusColorSpace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageTypeSpecifier;
import org.geotools.arcsde.raster.info.RasterCellType;
import org.geotools.arcsde.raster.info.RasterDatasetInfo;
import org.geotools.arcsde.raster.info.RasterQueryInfo;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ComponentColorModelJAI;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RasterUtils {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");

    private RasterUtils() {
    }

    public static MathTransform createRasterToModel(Rectangle levelGridRange, GeneralEnvelope levelEnvelope) {
        GeneralGridEnvelope gridRange = new GeneralGridEnvelope(levelGridRange, 2);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)gridRange, (Envelope)levelEnvelope);
        geMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        MathTransform rasterToModel = geMapper.createTransform();
        return rasterToModel;
    }

    private static Rectangle getResultDimensionForTileRange(Rectangle tiledImageGridRange, Rectangle matchingLevelRange) {
        int minx = Math.max(tiledImageGridRange.x, matchingLevelRange.x);
        int miny = Math.max(tiledImageGridRange.y, matchingLevelRange.y);
        int maxx = (int)Math.min(tiledImageGridRange.getMaxX(), matchingLevelRange.getMaxX());
        int maxy = (int)Math.min(tiledImageGridRange.getMaxY(), matchingLevelRange.getMaxY());
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    private static Rectangle findMatchingTiles(Dimension tileSize, int numTilesWide, int numTilesHigh, Rectangle pixelRange) {
        int minPixelX = pixelRange.x;
        int minPixelY = pixelRange.y;
        int minTileX = (int)Math.floor((double)minPixelX / tileSize.getWidth());
        int minTileY = (int)Math.floor((double)minPixelY / tileSize.getHeight());
        int numTilesX = (int)Math.ceil(pixelRange.getWidth() / tileSize.getWidth());
        int numTilesY = (int)Math.ceil(pixelRange.getHeight() / tileSize.getHeight());
        int maxTiledX = (minTileX + numTilesX) * tileSize.width;
        int maxTiledY = (minTileY + numTilesY) * tileSize.height;
        if ((double)maxTiledX < pixelRange.getMaxX() && minTileX + numTilesX < numTilesWide) {
            ++numTilesX;
        }
        if ((double)maxTiledY < pixelRange.getMaxY() && minTileY + numTilesY < numTilesHigh) {
            ++numTilesY;
        }
        Rectangle matchingTiles = new Rectangle(minTileX, minTileY, numTilesX, numTilesY);
        return matchingTiles;
    }

    private static Rectangle getTargetGridRange(MathTransform modelToRaster, Envelope requestedEnvelope) {
        GeneralEnvelope requestedPixels;
        try {
            requestedPixels = CRS.transform((MathTransform)modelToRaster, (Envelope)requestedEnvelope);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
        catch (TransformException e) {
            throw new IllegalArgumentException(e);
        }
        int levelMinPixelX = (int)Math.floor(requestedPixels.getMinimum(0));
        int levelMaxPixelX = (int)Math.floor(requestedPixels.getMaximum(0));
        int levelMinPixelY = (int)Math.ceil(requestedPixels.getMinimum(1));
        int levelMaxPixelY = (int)Math.ceil(requestedPixels.getMaximum(1));
        int width = levelMaxPixelX - levelMinPixelX;
        int height = levelMaxPixelY - levelMinPixelY;
        Rectangle levelOverlappingPixels = new Rectangle(levelMinPixelX, levelMinPixelY, width, height);
        return levelOverlappingPixels;
    }

    public static IndexColorModel sdeColorMapToJavaColorModel(DataBuffer colorMapData, int bitsPerSample) {
        if (colorMapData == null) {
            throw new NullPointerException("colorMapData");
        }
        if (colorMapData.getNumBanks() < 3 || colorMapData.getNumBanks() > 4) {
            throw new IllegalArgumentException("colorMapData shall have 3 or 4 banks: " + colorMapData.getNumBanks());
        }
        if (bitsPerSample != 8 && bitsPerSample != 16) {
            throw new IllegalAccessError("bits per sample shall be either 8 or 16. Got " + bitsPerSample);
        }
        int numBanks = colorMapData.getNumBanks();
        int mapSize = colorMapData.getSize();
        byte[] r = new byte[mapSize];
        byte[] g = new byte[mapSize];
        byte[] b = new byte[mapSize];
        byte[] a = new byte[mapSize];
        for (int i = 0; i < mapSize; ++i) {
            r[i] = (byte)(colorMapData.getElem(0, i) & 0xFF);
            g[i] = (byte)(colorMapData.getElem(1, i) & 0xFF);
            b[i] = (byte)(colorMapData.getElem(2, i) & 0xFF);
            a[i] = (byte)((numBanks == 3 ? 255 : colorMapData.getElem(3, i)) & 0xFF);
        }
        IndexColorModel colorModel = new IndexColorModel(bitsPerSample, mapSize, r, g, b, a);
        return colorModel;
    }

    public static ImageTypeSpecifier createFullImageTypeSpecifier(RasterDatasetInfo rasterInfo, int rasterIndex) {
        ImageTypeSpecifier its;
        int numberOfBands = rasterInfo.getNumBands();
        RasterCellType nativePixelType = rasterInfo.getNativeCellType();
        RasterCellType pixelType = rasterInfo.getTargetCellType(rasterIndex);
        int sampleImageWidth = 1;
        int sampleImageHeight = 1;
        int bitsPerSample = pixelType.getBitsPerSample();
        int dataType = pixelType.getDataBufferType();
        boolean hasColorMap = rasterInfo.isColorMapped();
        if (hasColorMap) {
            IndexColorModel colorMap = rasterInfo.getColorMap(rasterIndex);
            its = RasterUtils.createColorMappedImageSpec(colorMap, sampleImageWidth, sampleImageHeight);
        } else if (nativePixelType == RasterCellType.TYPE_1BIT && numberOfBands == 1) {
            byte noDataValue = rasterInfo.getNoDataValue(rasterIndex, 0).byteValue();
            its = RasterUtils.createOneBitColorMappedImageSpec(sampleImageWidth, sampleImageHeight, noDataValue);
        } else if (nativePixelType == RasterCellType.TYPE_4BIT && numberOfBands == 1) {
            byte noDataValue = rasterInfo.getNoDataValue(rasterIndex, 0).byteValue();
            its = RasterUtils.createFourBitColorMappedImageSpec(sampleImageWidth, sampleImageHeight, noDataValue);
        } else if (numberOfBands == 1) {
            its = RasterUtils.createGrayscaleImageSpec(sampleImageWidth, sampleImageHeight, dataType, bitsPerSample);
        } else if (numberOfBands == 3 && pixelType == RasterCellType.TYPE_8BIT_U) {
            its = RasterUtils.createRGBImageSpec(sampleImageWidth, sampleImageHeight, dataType);
        } else if (numberOfBands == 4 && pixelType == RasterCellType.TYPE_8BIT_U) {
            its = RasterUtils.createRGBAImageSpec(sampleImageWidth, sampleImageHeight, dataType);
        } else {
            int i;
            BogusColorSpace colorSpace = new BogusColorSpace(numberOfBands);
            int[] numBits = new int[numberOfBands];
            for (i = 0; i < numberOfBands; ++i) {
                numBits[i] = bitsPerSample;
            }
            ComponentColorModelJAI colorModel = new ComponentColorModelJAI((ColorSpace)colorSpace, numBits, false, false, 1, dataType);
            int[] bankIndices = new int[numberOfBands];
            int[] bandOffsets = new int[numberOfBands];
            for (i = 0; i < numberOfBands; ++i) {
                bankIndices[i] = i;
                bandOffsets[i] = 0;
            }
            BandedSampleModel sampleModel = new BandedSampleModel(dataType, sampleImageWidth, sampleImageHeight, sampleImageWidth, bankIndices, bandOffsets);
            its = new ImageTypeSpecifier((ColorModel)colorModel, sampleModel);
        }
        return its;
    }

    private static ImageTypeSpecifier createFourBitColorMappedImageSpec(int sampleImageWidth, int sampleImageHeight, byte noDataValue) {
        int maxValue = (int)RasterCellType.TYPE_4BIT.getSampleValueRange().getMaximum();
        int mapSize = noDataValue > maxValue ? noDataValue : maxValue + 1;
        int[] cmap = new int[mapSize];
        ColorUtilities.expand((Color[])new Color[]{Color.BLACK, Color.WHITE}, (int[])cmap, (int)0, (int)maxValue);
        for (int i = maxValue; i < mapSize; ++i) {
            cmap[i] = ColorUtilities.getIntFromColor((int)0, (int)0, (int)0, (int)0);
        }
        int transparentPixel = noDataValue;
        IndexColorModel colorModel = new IndexColorModel(8, mapSize, cmap, 0, true, transparentPixel, 0);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(sampleImageWidth, sampleImageHeight);
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createOneBitColorMappedImageSpec(int sampleImageWidth, int sampleImageHeight, byte noDataValue) {
        assert (noDataValue == 2);
        int FALSE = ColorUtilities.getIntFromColor((int)255, (int)255, (int)255, (int)255);
        int TRUE = ColorUtilities.getIntFromColor((int)0, (int)0, (int)0, (int)255);
        int NODATA = ColorUtilities.getIntFromColor((int)255, (int)255, (int)255, (int)0);
        int mapSize = 3;
        int[] cmap = new int[]{FALSE, TRUE, NODATA};
        byte transparentPixel = noDataValue;
        IndexColorModel colorModel = new IndexColorModel(8, 3, cmap, 0, false, (int)transparentPixel, 0);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(sampleImageWidth, sampleImageHeight);
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createRGBAImageSpec(int sampleImageWidth, int sampleImageHeight, int dataType) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean hasAlpha = true;
        boolean isAlphaPremultiplied = false;
        int transparency = 3;
        int transferType = dataType;
        int[] nBits = new int[]{8, 8, 8, 8};
        ComponentColorModelJAI colorModel = new ComponentColorModelJAI(colorSpace, nBits, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        BandedSampleModel sampleModel = new BandedSampleModel(dataType, sampleImageWidth, sampleImageHeight, 4);
        ImageTypeSpecifier its = new ImageTypeSpecifier((ColorModel)colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createRGBImageSpec(int sampleImageWidth, int sampleImageHeight, int dataType) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean hasAlpha = false;
        boolean isAlphaPremultiplied = false;
        int transparency = 1;
        int transferType = dataType;
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8}, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        BandedSampleModel sampleModel = new BandedSampleModel(dataType, sampleImageWidth, sampleImageHeight, 3);
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createGrayscaleImageSpec(int sampleImageWidth, int sampleImageHeight, int dataType, int bitsPerPixel) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        boolean hasAlpha = false;
        boolean isAlphaPremultiplied = false;
        int transparency = 1;
        int transferType = dataType;
        int[] nbits = new int[]{bitsPerPixel};
        ComponentColorModelJAI colorModel = new ComponentColorModelJAI(colorSpace, nbits, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(sampleImageWidth, sampleImageHeight);
        ImageTypeSpecifier its = new ImageTypeSpecifier((ColorModel)colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createColorMappedImageSpec(IndexColorModel colorModel, int sampleImageWidth, int sampleImageHeight) {
        LOGGER.fine("Found single-band colormapped raster, using its index color model");
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(sampleImageWidth, sampleImageHeight);
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        return its;
    }

    public static Rectangle setMosaicLocations(RasterDatasetInfo rasterInfo, GeneralEnvelope resultEnvelope, List<RasterQueryInfo> results) {
        MathTransform modelToRaster;
        RasterQueryInfo dimensionChoice = RasterUtils.findLowestResolution(results);
        Long rasterId = dimensionChoice.getRasterId();
        int pyramidLevel = dimensionChoice.getPyramidLevel();
        int rasterIndex = rasterInfo.getRasterIndex(rasterId);
        Rectangle levelRange = rasterInfo.getGridRange(rasterIndex, pyramidLevel);
        GeneralEnvelope levelEnvelope = rasterInfo.getGridEnvelope(rasterIndex, pyramidLevel);
        MathTransform rasterToModel = RasterUtils.createRasterToModel(levelRange, levelEnvelope);
        try {
            modelToRaster = rasterToModel.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        Rectangle mosaicDimension = RasterUtils.getTargetGridRange(modelToRaster, (Envelope)resultEnvelope);
        for (RasterQueryInfo rasterResultInfo : results) {
            GeneralEnvelope rasterResultEnvelope = rasterResultInfo.getResultEnvelope();
            Rectangle targetRasterGridRange = RasterUtils.getTargetGridRange(modelToRaster, (Envelope)rasterResultEnvelope);
            rasterResultInfo.setMosaicLocation(targetRasterGridRange);
        }
        return mosaicDimension;
    }

    private static RasterQueryInfo findLowestResolution(List<RasterQueryInfo> results) {
        double[] prev = new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
        RasterQueryInfo lowestResQuery = null;
        for (RasterQueryInfo query : results) {
            double[] curr = query.getResolution();
            if (!(curr[0] > prev[0])) continue;
            prev = curr;
            lowestResQuery = query;
        }
        return lowestResQuery;
    }

    public static List<RasterQueryInfo> findMatchingRasters(RasterDatasetInfo rasterInfo, GeneralEnvelope requestedEnvelope, Rectangle requestedDim, OverviewPolicy overviewPolicy) {
        int numRasters = rasterInfo.getNumRasters();
        ArrayList<RasterQueryInfo> matchingRasters = new ArrayList<RasterQueryInfo>(numRasters);
        for (int rasterN = 0; rasterN < numRasters; ++rasterN) {
            int optimalPyramidLevel = rasterInfo.getOptimalPyramidLevel(rasterN, overviewPolicy, requestedEnvelope, requestedDim);
            GeneralEnvelope gridEnvelope = rasterInfo.getGridEnvelope(rasterN, optimalPyramidLevel);
            boolean edgesInclusive = true;
            if (!requestedEnvelope.intersects((Envelope)gridEnvelope, true)) continue;
            RasterQueryInfo match = new RasterQueryInfo();
            match.setRequestedEnvelope(requestedEnvelope);
            match.setRequestedDim(requestedDim);
            match.setRasterId(rasterInfo.getRasterId(rasterN));
            match.setRasterIndex(rasterN);
            match.setPyramidLevel(optimalPyramidLevel);
            match.setResolution(rasterInfo.getResolution(rasterN, optimalPyramidLevel));
            matchingRasters.add(match);
        }
        return matchingRasters;
    }

    public static void fitRequestToRaster(GeneralEnvelope requestedEnvelope, RasterDatasetInfo rasterInfo, RasterQueryInfo query) {
        int rasterIndex = query.getRasterIndex();
        int pyramidLevel = query.getPyramidLevel();
        Rectangle rasterGridRange = rasterInfo.getGridRange(rasterIndex, pyramidLevel);
        GeneralEnvelope rasterEnvelope = rasterInfo.getGridEnvelope(rasterIndex, pyramidLevel);
        double delta = requestedEnvelope.getMinimum(0) - rasterEnvelope.getMinimum(0);
        double resX = rasterInfo.getResolution(rasterIndex, pyramidLevel)[0];
        int xMinPixel = (int)Math.floor(delta / resX);
        delta = requestedEnvelope.getMaximum(0) - rasterEnvelope.getMinimum(0);
        int xMaxPixel = (int)Math.ceil(delta / resX);
        delta = rasterEnvelope.getMaximum(1) - requestedEnvelope.getMaximum(1);
        double resY = rasterInfo.getResolution(rasterIndex, pyramidLevel)[1];
        int yMinPixel = (int)Math.floor(delta / resY);
        delta = rasterEnvelope.getMaximum(1) - requestedEnvelope.getMinimum(1);
        int yMaxPixel = (int)Math.ceil(delta / resY);
        xMinPixel = Math.max(xMinPixel, rasterGridRange.x);
        yMinPixel = Math.max(yMinPixel, rasterGridRange.y);
        xMaxPixel = Math.min(xMaxPixel, rasterGridRange.x + rasterGridRange.width);
        yMaxPixel = Math.min(yMaxPixel, rasterGridRange.y + rasterGridRange.height);
        int widthPixel = xMaxPixel - xMinPixel;
        int heightPixel = yMaxPixel - yMinPixel;
        double xMinGeo = rasterEnvelope.getMinimum(0) + resX * (double)xMinPixel;
        double yMinGeo = rasterEnvelope.getMaximum(1) - resY * (double)(yMinPixel + heightPixel);
        double widthGeo = resX * (double)widthPixel;
        double heightGeo = resY * (double)heightPixel;
        GeneralEnvelope resultEnvelope = new GeneralEnvelope(new double[]{xMinGeo, yMinGeo}, new double[]{xMinGeo + widthGeo, yMinGeo + heightGeo});
        resultEnvelope.setCoordinateReferenceSystem(rasterEnvelope.getCoordinateReferenceSystem());
        Rectangle resultGridRange = new Rectangle(xMinPixel, yMinPixel, widthPixel, heightPixel);
        Dimension tileSize = rasterInfo.getTileDimension(rasterIndex);
        int numTilesWide = rasterInfo.getNumTilesWide(rasterIndex, pyramidLevel);
        int numTilesHigh = rasterInfo.getNumTilesHigh(rasterIndex, pyramidLevel);
        Rectangle levelTileRange = new Rectangle(0, 0, numTilesWide, numTilesHigh);
        Rectangle matchingTiles = RasterUtils.findMatchingTiles(tileSize, numTilesWide, numTilesHigh, resultGridRange);
        int tiledImageMinX = matchingTiles.x * tileSize.width;
        int tiledImageMinY = matchingTiles.y * tileSize.height;
        int tiledWidth = matchingTiles.width * tileSize.width;
        int tiledHeight = matchingTiles.height * tileSize.height;
        Rectangle tiledImageGridRange = new Rectangle(tiledImageMinX, tiledImageMinY, tiledWidth, tiledHeight);
        Rectangle resultDimensionInsideTiledImage = RasterUtils.getResultDimensionForTileRange(tiledImageGridRange, resultGridRange);
        query.setResultEnvelope(resultEnvelope);
        query.setResultDimensionInsideTiledImage(resultDimensionInsideTiledImage);
        query.setTiledImageSize(tiledImageGridRange);
        query.setLevelTileRange(levelTileRange);
        query.setMatchingTiles(matchingTiles);
    }

    public static IndexColorModel ensureNoDataPixelIsAvailable(IndexColorModel colorMap) {
        int newTransferType;
        int significantBits;
        int transparentPixel = colorMap.getTransparentPixel();
        if (transparentPixel > -1) {
            return colorMap;
        }
        int transferType = colorMap.getTransferType();
        int mapSize = colorMap.getMapSize();
        int maxSize = 65536;
        if (mapSize == 65536) {
            LOGGER.fine("There's no room for a new transparent pixel, returning the original colorMap as is");
            return colorMap;
        }
        int newMapSize = mapSize + 1;
        int[] argb = new int[newMapSize];
        colorMap.getRGBs(argb);
        argb[newMapSize - 1] = ColorUtilities.getIntFromColor((int)0, (int)0, (int)0, (int)0);
        if (0 == transferType && newMapSize <= 256) {
            significantBits = colorMap.getPixelSize();
            newTransferType = 0;
        } else if (0 == transferType && newMapSize == 257) {
            significantBits = 9;
            newTransferType = 1;
        } else {
            significantBits = 16;
            newTransferType = 1;
        }
        int transparentPixelIndex = newMapSize - 1;
        boolean hasalpha = true;
        boolean startIndex = false;
        IndexColorModel targetColorModel = new IndexColorModel(significantBits, newMapSize, argb, 0, true, transparentPixelIndex, newTransferType);
        return targetColorModel;
    }

    public static Number determineNoDataValue(IndexColorModel colorMap) {
        int noDataPixel = colorMap.getTransparentPixel();
        if (-1 == noDataPixel) {
            noDataPixel = ColorUtilities.getTransparentPixel((IndexColorModel)colorMap);
        }
        return noDataPixel;
    }

    public static Number determineNoDataValue(int numBands, double statsMin, double statsMax, RasterCellType nativeCellType) {
        boolean isUnsigned;
        double greater;
        double lower;
        if (nativeCellType == RasterCellType.TYPE_32BIT_REAL) {
            LOGGER.fine("no data value is Float.NaN");
            return Float.valueOf(Float.NaN);
        }
        if (nativeCellType == RasterCellType.TYPE_64BIT_REAL) {
            LOGGER.fine("no data value is Double.NaN");
            return Double.NaN;
        }
        if (nativeCellType == RasterCellType.TYPE_1BIT) {
            LOGGER.fine("1BIT images no-data value is set to 2, regardless of the raster statistics");
            return 2.0;
        }
        if (nativeCellType == RasterCellType.TYPE_4BIT) {
            LOGGER.fine("4BIT images no-data value is set to 16, regardless of the raster statistics");
            return 16.0;
        }
        if (!RasterUtils.isGeoPhysics(numBands, nativeCellType)) {
            LOGGER.fine("3 or 4 band, 8 bit unsigned image, assumed to be RGB or RGBA respectively and nodata value hardcoded to 255");
            return (Number)((Object)nativeCellType.getSampleValueRange().getMaxValue());
        }
        NumberRange<?> sampleValueRange = nativeCellType.getSampleValueRange();
        double minimumSample = sampleValueRange.getMinimum(true);
        double maximumSample = sampleValueRange.getMaximum(true);
        if (Double.isNaN(statsMin) || Double.isNaN(statsMax)) {
            lower = Math.ceil(minimumSample - 1.0);
            greater = Math.floor(maximumSample + 1.0);
        } else {
            lower = Math.ceil(statsMin - 1.0);
            greater = Math.floor(statsMax + 1.0);
        }
        boolean bl = isUnsigned = minimumSample == 0.0;
        Double nodata = sampleValueRange.contains((Number)lower) ? Double.valueOf(lower) : (sampleValueRange.contains((Number)greater) ? Double.valueOf(greater) : (isUnsigned ? Double.valueOf(greater) : Double.valueOf(lower)));
        return nodata;
    }

    public static boolean isGeoPhysics(int numBands, RasterCellType nativeCellType) {
        boolean geophysics = true;
        if (nativeCellType == RasterCellType.TYPE_8BIT_U && (numBands == 3 || numBands == 4)) {
            geophysics = false;
        }
        return geophysics;
    }

    public static RasterCellType determineTargetCellType(RasterCellType nativeCellType, List<Number> noDataValues) {
        if (RasterCellType.TYPE_32BIT_REAL == nativeCellType || RasterCellType.TYPE_64BIT_REAL == nativeCellType) {
            for (Number nodata : noDataValues) {
                if (Double.isNaN(nodata.doubleValue())) continue;
                throw new IllegalArgumentException("no data values for float and double cell types shall be NaN: " + nodata);
            }
            return nativeCellType;
        }
        double noDataMin = Double.POSITIVE_INFINITY;
        double noDataMax = Double.NEGATIVE_INFINITY;
        for (Number noData : noDataValues) {
            noDataMin = Math.min(noDataMin, noData.doubleValue());
            noDataMax = Math.max(noDataMax, noData.doubleValue());
        }
        NumberRange sampleValueRange = nativeCellType.getSampleValueRange().castTo(Double.class);
        RasterCellType targetCellType = sampleValueRange.contains((Number)noDataMin) && sampleValueRange.contains((Number)noDataMax) ? nativeCellType : RasterUtils.promote(nativeCellType);
        return targetCellType;
    }

    private static RasterCellType promote(RasterCellType nativeCellType) {
        switch (nativeCellType) {
            case TYPE_1BIT: 
            case TYPE_4BIT: {
                return RasterCellType.TYPE_8BIT_U;
            }
            case TYPE_8BIT_U: {
                return RasterCellType.TYPE_16BIT_U;
            }
            case TYPE_8BIT_S: {
                return RasterCellType.TYPE_16BIT_S;
            }
            case TYPE_16BIT_U: {
                return RasterCellType.TYPE_32BIT_U;
            }
            case TYPE_16BIT_S: {
                return RasterCellType.TYPE_32BIT_S;
            }
            case TYPE_32BIT_S: 
            case TYPE_32BIT_REAL: 
            case TYPE_32BIT_U: {
                return RasterCellType.TYPE_64BIT_REAL;
            }
        }
        throw new IllegalArgumentException("Can't promote a raster of type 64-bit-real, there's no higher pixel depth than that!");
    }
}

