/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeTable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.data.ArcSdeFeatureSource;
import org.geotools.arcsde.data.ArcSdeFeatureWriter;
import org.geotools.arcsde.data.FeatureTypeInfo;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcSdeFeatureStore
extends ArcSdeFeatureSource
implements FeatureStore<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger((String)ArcSdeFeatureStore.class.getName());

    public ArcSdeFeatureStore(FeatureTypeInfo typeInfo, ArcSDEDataStore arcSDEDataStore) {
        super(typeInfo, arcSDEDataStore);
    }

    public synchronized Transaction getTransaction() {
        return this.transaction;
    }

    public synchronized void setTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("mean Transaction.AUTO_COMMIT?");
        }
        boolean isAutoCommit = Transaction.AUTO_COMMIT.equals(transaction);
        if (!isAutoCommit) {
            try {
                transaction.getState(new Object());
            }
            catch (UnsupportedOperationException e) {
                isAutoCommit = true;
            }
        }
        this.transaction = transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        String typeName = this.typeInfo.getFeatureTypeName();
        ArcSdeFeatureWriter writer = this.dataStore.getFeatureWriterAppend(typeName, this.transaction);
        FeatureIterator iterator = collection.features();
        LinkedList<FeatureId> featureIds = new LinkedList<FeatureId>();
        try {
            while (iterator.hasNext()) {
                SimpleFeature toAdd = (SimpleFeature)iterator.next();
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                newFeature.setAttributes(toAdd.getAttributes());
                writer.write();
                featureIds.add(newFeature.getIdentifier());
            }
        }
        finally {
            iterator.close();
            writer.close();
        }
        return featureIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyFeatures(AttributeDescriptor[] attributes, Object[] values, Filter filter) throws IOException {
        ISession session = this.getSession();
        try {
            String typeName = this.typeInfo.getFeatureTypeName();
            Transaction currTransaction = this.getTransaction();
            ArcSdeFeatureWriter writer = this.dataStore.getFeatureWriter(typeName, filter, currTransaction);
            try {
                while (writer.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)writer.next();
                    for (int i = 0; i < values.length; ++i) {
                        feature.setAttribute(attributes[i].getLocalName(), values[i]);
                    }
                    writer.write();
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            session.dispose();
        }
    }

    public final void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeDescriptor[]{type}, new Object[]{value}, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatures(Filter filter) throws IOException {
        Transaction currTransaction = this.getTransaction();
        String typeName = this.typeInfo.getFeatureTypeName();
        ArcSdeFeatureWriter writer = this.dataStore.getFeatureWriter(typeName, filter, currTransaction);
        try {
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        SimpleFeatureType readerType = (SimpleFeatureType)reader.getFeatureType();
        if (!this.getSchema().equals(readerType)) {
            throw new IllegalArgumentException("Type mismatch: " + readerType);
        }
        String typeName = this.typeInfo.getFeatureTypeName();
        ISession session = this.getSession();
        try {
            this.truncate(typeName, session);
        }
        finally {
            session.dispose();
        }
        ArcSdeFeatureWriter writer = this.dataStore.getFeatureWriterAppend(typeName, this.transaction);
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                newFeature.setAttributes(feature.getAttributes());
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    private void truncate(String typeName, ISession session) throws IOException {
        boolean transactionInProgress = session.isTransactionActive();
        final SeTable table = session.getTable(typeName);
        if (transactionInProgress) {
            LOGGER.fine("deleting all table records for " + typeName);
            ArcSdeFeatureWriter writer = this.dataStore.getFeatureWriter(typeName, this.transaction);
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
            }
        } else {
            LOGGER.fine("truncating table " + typeName);
            session.issue((Command)new Command<Void>(){

                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    table.truncate();
                    return null;
                }
            });
        }
    }
}

