/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.FeatureTypeStyleBuilder;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleBuilder<P>
implements Builder<Style> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    List<FeatureTypeStyle> fts = new ArrayList<FeatureTypeStyle>();
    FeatureTypeStyleBuilder ftsBuilder;
    String name;
    String styleAbstract;
    String title;
    boolean isDefault;
    private boolean unset;

    public StyleBuilder() {
        this(null);
    }

    public StyleBuilder(P parent) {
        parent = null;
        this.reset();
    }

    public StyleBuilder<P> name(String name) {
        this.name = name;
        return this;
    }

    public StyleBuilder title(String title) {
        this.title = title;
        return this;
    }

    public StyleBuilder styleAbstract(String styleAbstract) {
        this.styleAbstract = styleAbstract;
        return this;
    }

    public FeatureTypeStyleBuilder newFeatureTypeStyle() {
        if (this.ftsBuilder == null) {
            this.ftsBuilder = new FeatureTypeStyleBuilder();
        } else {
            this.fts.add(this.ftsBuilder.build());
        }
        return this.ftsBuilder;
    }

    @Override
    public Style build() {
        if (this.unset) {
            return null;
        }
        if (this.ftsBuilder == null) {
            this.ftsBuilder = new FeatureTypeStyleBuilder();
        }
        this.fts.add(this.ftsBuilder.build());
        Style s = this.sf.createStyle();
        s.setName(this.name);
        if (this.styleAbstract != null) {
            s.getDescription().setAbstract((InternationalString)new SimpleInternationalString(this.styleAbstract));
        }
        if (this.title != null) {
            s.getDescription().setTitle((InternationalString)new SimpleInternationalString(this.title));
        }
        s.featureTypeStyles().addAll(this.fts);
        s.setDefault(this.isDefault);
        if (this.parent == null) {
            this.reset();
        }
        return s;
    }

    public StyleBuilder unset() {
        this.reset();
        this.unset = true;
        return this;
    }

    public StyleBuilder reset() {
        this.fts.clear();
        this.ftsBuilder = null;
        this.name = null;
        this.styleAbstract = null;
        this.title = null;
        this.isDefault = false;
        this.unset = false;
        return this;
    }

    public StyleBuilder reset(Style style) {
        if (style == null) {
            return this.unset();
        }
        this.fts.clear();
        this.fts.addAll(style.featureTypeStyles());
        this.ftsBuilder = null;
        this.name = style.getName();
        this.styleAbstract = style.getAbstract();
        this.title = style.getTitle();
        this.isDefault = style.isDefault();
        this.unset = false;
        return this;
    }
}

