/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.Color;
import java.util.Map;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.coverage.processing.ColorMap;
import org.geotools.coverage.processing.operation.IndexColorOperation;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;

public final class Recolor
extends IndexColorOperation {
    public static final ParameterDescriptor COLOR_MAPS = new DefaultParameterDescriptor(Citations.GEOTOOLS, "ColorMaps", Object[].class, null, (Object)new ColorMap[]{new ColorMap(new Color[]{new Color(16, 16, 16), new Color(240, 240, 240)})}, null, null, null, true);

    public Recolor() {
        super(new DefaultParameterDescriptorGroup(Citations.GEOTOOLS, "Recolor", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, COLOR_MAPS}));
    }

    protected GridSampleDimension transformColormap(int[] ARGB, int band, GridSampleDimension sampleDimension, ParameterValueGroup parameters) {
        Object[] colorMaps = (Object[])parameters.parameter("ColorMaps").getValue();
        if (colorMaps == null || colorMaps.length == 0) {
            return sampleDimension;
        }
        Object colorMap = colorMaps[Math.min(band, colorMaps.length - 1)];
        if (colorMap instanceof Map) {
            AbstractProcessor.LOGGER.warning("\"ColorMaps\" parameter of type java.util.Map[] is deprecated. Please use the org.geotools.coverage.processing.ColorMap type instead.");
            colorMap = new ColorMap((Map)colorMap);
        }
        return ((ColorMap)colorMap).recolor(sampleDimension, ARGB);
    }
}

