/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.netcdf;

import org.geotools.image.io.metadata.Band;
import org.geotools.resources.XArray;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.VariableEnhanced;

final class VariableMetadata {
    private final int imageType;
    public final double scale;
    public final double offset;
    public final double minimum;
    public final double maximum;
    public final double[] missingValues;
    private transient DataType widestType;

    public VariableMetadata(VariableEnhanced variable) {
        this.imageType = VariableMetadata.getRawDataType((VariableIF)variable);
        this.offset = variable.convertScaleOffsetMissing(0.0);
        this.scale = variable.convertScaleOffsetMissing(1.0) - this.offset;
        this.minimum = (variable.getValidMin() - this.offset) / this.scale;
        this.maximum = (variable.getValidMax() - this.offset) / this.scale;
        this.missingValues = null;
    }

    public VariableMetadata(Variable variable, boolean forceRangePacking) {
        this.imageType = VariableMetadata.getRawDataType((VariableIF)variable);
        DataType dataType = this.widestType = variable.getDataType();
        this.scale = this.attribute(variable, "scale_factor");
        this.offset = this.attribute(variable, "add_offset");
        DataType scaleType = this.widestType;
        this.widestType = dataType;
        double minimum = Double.NaN;
        double maximum = Double.NaN;
        Attribute attribute = variable.findAttribute("valid_range");
        if (attribute != null) {
            this.widestType = VariableMetadata.widest(attribute.getDataType(), this.widestType);
            Number value = attribute.getNumericValue(0);
            if (value != null) {
                minimum = value.doubleValue();
            }
            if ((value = attribute.getNumericValue(1)) != null) {
                maximum = value.doubleValue();
            }
        }
        if (Double.isNaN(minimum)) {
            minimum = this.attribute(variable, "valid_min");
        }
        if (Double.isNaN(maximum)) {
            maximum = this.attribute(variable, "valid_max");
        }
        DataType rangeType = this.widestType;
        this.widestType = dataType;
        if (!forceRangePacking) {
            boolean bl = forceRangePacking = rangeType.equals(scaleType) && rangeType.equals(VariableMetadata.widest(rangeType, dataType));
        }
        if (forceRangePacking) {
            double offset = Double.isNaN(this.offset) ? 0.0 : this.offset;
            double scale = Double.isNaN(this.scale) ? 1.0 : this.scale;
            minimum = (minimum - offset) / scale;
            maximum = (maximum - offset) / scale;
            if (!VariableMetadata.isFloatingPoint(rangeType)) {
                if (!Double.isNaN(minimum) && !Double.isInfinite(minimum)) {
                    minimum = Math.round(minimum);
                }
                if (!Double.isNaN(maximum) && !Double.isInfinite(maximum)) {
                    maximum = Math.round(maximum);
                }
            }
        }
        if (Double.isNaN(minimum)) {
            minimum = Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(maximum)) {
            maximum = Double.POSITIVE_INFINITY;
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.widestType = dataType;
        attribute = variable.findAttribute("missing_value");
        double fillValue = this.attribute(variable, "_FillValue");
        int fillCount = Double.isNaN(fillValue) ? 0 : 1;
        int missingCount = attribute != null ? attribute.getLength() : 0;
        double[] missings = new double[fillCount + missingCount];
        if (fillCount != 0) {
            missings[0] = fillValue;
        }
        int count = fillCount;
        int i = 0;
        while (i < missingCount) {
            block17: {
                double value;
                Number number = attribute.getNumericValue(i);
                if (number != null && !Double.isNaN(value = number.doubleValue())) {
                    int j = 0;
                    while (j < count) {
                        if (value != missings[j]) {
                            ++j;
                            continue;
                        }
                        break block17;
                    }
                    missings[count++] = value;
                }
            }
            ++i;
        }
        this.missingValues = count != 0 ? XArray.resize((double[])missings, (int)count) : null;
    }

    private double attribute(Variable variable, String name) {
        Attribute attribute = variable.findAttribute(name);
        if (attribute != null) {
            this.widestType = VariableMetadata.widest(attribute.getDataType(), this.widestType);
            Number value = attribute.getNumericValue();
            if (value != null) {
                return value.doubleValue();
            }
        }
        return Double.NaN;
    }

    private static DataType widest(DataType type1, DataType type2) {
        int size2;
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        int size1 = type1.getSize();
        if (size1 > (size2 = type2.getSize())) {
            return type1;
        }
        if (size1 < size2) {
            return type2;
        }
        return VariableMetadata.isFloatingPoint(type2) ? type2 : type1;
    }

    private static boolean isFloatingPoint(DataType type) {
        return DataType.FLOAT.equals(type) || DataType.DOUBLE.equals(type);
    }

    static int getRawDataType(VariableIF variable) {
        DataType type = variable.getDataType();
        if (DataType.BOOLEAN.equals(type) || DataType.BYTE.equals(type)) {
            return 0;
        }
        if (DataType.CHAR.equals(type)) {
            return 1;
        }
        if (DataType.SHORT.equals(type)) {
            return variable.isUnsigned() ? 1 : 2;
        }
        if (DataType.INT.equals(type)) {
            return 3;
        }
        if (DataType.FLOAT.equals(type)) {
            return 4;
        }
        if (DataType.LONG.equals(type) || DataType.DOUBLE.equals(type)) {
            return 5;
        }
        return 32;
    }

    public void copyTo(Band band) {
        band.setScale(this.scale);
        band.setOffset(this.offset);
        band.setPackedValues(this.minimum, this.maximum, this.missingValues, this.imageType);
    }
}

