/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.netcdf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageReader;
import org.geotools.image.io.GeographicImageReadParam;
import org.geotools.resources.i18n.Errors;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableEnhanced;

public class NetcdfReadParam
extends GeographicImageReadParam {
    static final int DEFAULT_INDICE = 0;
    private static final int[] DEFAULT_BANDS = new int[1];
    private Set<AxisType> bandDimensionTypes;
    private Map<AxisType, Integer> sliceIndices;

    public NetcdfReadParam(ImageReader reader) {
        super(reader);
        this.setSourceBands(DEFAULT_BANDS);
        this.setDestinationBands(DEFAULT_BANDS);
    }

    final boolean isBandDimensionSet() {
        return this.bandDimensionTypes != null && !this.bandDimensionTypes.isEmpty() && NetcdfReadParam.class.equals(((Object)((Object)this)).getClass());
    }

    protected int getBandDimension(VariableEnhanced variable) {
        List sys;
        if (this.bandDimensionTypes != null && (sys = variable.getCoordinateSystems()) != null) {
            int count = sys.size();
            int i = 0;
            while (i < count) {
                CoordinateSystem cs = (CoordinateSystem)sys.get(i);
                List axes = cs.getCoordinateAxes();
                if (axes != null) {
                    int j = axes.size();
                    while (--j >= 0) {
                        CoordinateAxis axis = (CoordinateAxis)axes.get(j);
                        if (axis == null || !this.bandDimensionTypes.contains(axis.getAxisType())) continue;
                        return j;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    public AxisType[] getBandDimensionTypes() {
        if (this.bandDimensionTypes == null) {
            return null;
        }
        return this.bandDimensionTypes.toArray(new AxisType[this.bandDimensionTypes.size()]);
    }

    public void setBandDimensionTypes(AxisType ... types) {
        if (types != null && types.length != 0) {
            if (this.bandDimensionTypes == null) {
                this.bandDimensionTypes = new HashSet<AxisType>();
            } else {
                this.bandDimensionTypes.clear();
            }
            int i = 0;
            while (i < types.length) {
                this.bandDimensionTypes.add(types[i]);
                ++i;
            }
        } else {
            this.bandDimensionTypes = null;
        }
    }

    public int getSliceIndice(AxisType axis) {
        Integer indice;
        if (this.sliceIndices != null && (indice = this.sliceIndices.get(axis)) != null) {
            return indice;
        }
        return 0;
    }

    public void setSliceIndice(AxisType dimension, int indice) {
        if (indice < 0) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"indice", (Object)indice));
        }
        if (indice != 0) {
            if (this.sliceIndices == null) {
                this.sliceIndices = new HashMap<AxisType, Integer>();
            }
            this.sliceIndices.put(dimension, indice);
        } else if (this.sliceIndices != null) {
            this.sliceIndices.remove(dimension);
            if (this.sliceIndices.isEmpty()) {
                this.sliceIndices = null;
            }
        }
    }

    final boolean hasNonDefaultIndices() {
        return this.sliceIndices != null;
    }
}

