/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.io.GridCoverageReader;
import org.geotools.factory.Hints;
import org.geotools.image.io.RawBinaryImageReadParam;
import org.geotools.io.LineWriter;
import org.geotools.io.TableWriter;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public abstract class AbstractGridCoverageReader
implements GridCoverageReader {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverage.io");
    private final String formatName;
    protected ImageReader reader;
    protected final GridToEnvelopeMapper gridToEnvelope = new GridToEnvelopeMapper();
    private final GridCoverageFactory factory;
    private Object input;
    private ImageInputStream stream;
    private Locale locale;

    public AbstractGridCoverageReader(Hints hints) {
        this(hints, null);
    }

    public AbstractGridCoverageReader(Hints hints, String formatName) {
        this.factory = CoverageFactoryFinder.getGridCoverageFactory((Hints)hints);
        this.formatName = formatName;
    }

    public synchronized void reset() throws IOException {
        this.clear();
        this.locale = null;
        if (this.reader != null) {
            this.reader.reset();
            this.reader.dispose();
            this.reader = null;
        }
    }

    private void clear() throws IOException {
        assert (Thread.holdsLock(this));
        this.input = null;
        if (this.reader != null) {
            this.reader.setInput(null);
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    final String getString(int key) {
        return Errors.getResources((Locale)this.locale).getString(key);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale = locale;
        this.setReaderLocale(locale);
    }

    private void setReaderLocale(Locale locale) {
        if (this.reader != null) {
            Locale[] list = this.reader.getAvailableLocales();
            int i = list.length;
            while (--i >= 0) {
                if (!locale.equals(list[i])) continue;
                this.reader.setLocale(locale);
                return;
            }
            String language = AbstractGridCoverageReader.getISO3Language(locale);
            if (language != null) {
                int i2 = list.length;
                while (--i2 >= 0) {
                    if (!language.equals(AbstractGridCoverageReader.getISO3Language(list[i2]))) continue;
                    this.reader.setLocale(list[i2]);
                    return;
                }
            }
            this.reader.setLocale(null);
        }
    }

    private static String getISO3Language(Locale locale) {
        try {
            return locale.getISO3Language();
        }
        catch (MissingResourceException exception) {
            return null;
        }
    }

    private static File asFile(Object input) {
        if (input instanceof File) {
            return (File)input;
        }
        if (input instanceof URL) {
            return new File(((URL)input).getPath());
        }
        return null;
    }

    protected Iterator getImageReaders(Object input) {
        String filename;
        int separator;
        if (this.formatName != null) {
            return ImageIO.getImageReadersByFormatName(this.formatName);
        }
        File file = AbstractGridCoverageReader.asFile(input);
        if (file != null && (separator = (filename = file.getName()).lastIndexOf(46)) >= 0) {
            String extension = filename.substring(separator + 1);
            return ImageIO.getImageReadersBySuffix(extension);
        }
        return ImageIO.getImageReaders(input);
    }

    public synchronized void setInput(Object input, boolean seekForwardOnly) throws IOException {
        this.clear();
        if (input != null) {
            ImageReader rdr = this.reader;
            boolean reuseLast = rdr != null;
            Iterator it = this.getImageReaders(input);
            while (it.hasNext()) {
                if (!reuseLast) {
                    rdr = (ImageReader)it.next();
                    this.setReaderLocale(this.locale);
                }
                reuseLast = false;
                Class[] types = rdr.getOriginatingProvider().getInputTypes();
                if (AbstractGridCoverageReader.contains(types, input.getClass())) {
                    rdr.setInput(input, seekForwardOnly);
                    this.input = input;
                    this.reader = rdr;
                    return;
                }
                if (!AbstractGridCoverageReader.contains(types, ImageInputStream.class)) continue;
                assert (this.stream == null);
                this.stream = ImageIO.createImageInputStream(input);
                if (this.stream == null) continue;
                rdr.setInput(this.stream, seekForwardOnly);
                this.input = input;
                this.reader = rdr;
                return;
            }
            throw new IllegalArgumentException(this.getString(134));
        }
    }

    private static boolean contains(Class[] types, Class type) {
        int i = 0;
        while (i < types.length) {
            if (types[i].isAssignableFrom(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized int getNumImages(boolean allowSearch) throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException(this.getString(132));
        }
        return this.reader.getNumImages(allowSearch);
    }

    final int checkImageIndex(int imageIndex) throws IOException, IndexOutOfBoundsException {
        assert (Thread.holdsLock(this));
        if (this.reader == null) {
            throw new IllegalStateException(this.getString(132));
        }
        int numImages = this.getNumImages(false);
        if (imageIndex < this.reader.getMinIndex() || imageIndex >= numImages && numImages >= 0) {
            throw new IndexOutOfBoundsException(Errors.getResources((Locale)this.locale).getString(58, (Object)"imageIndex", (Object)imageIndex));
        }
        return numImages;
    }

    public synchronized String getName(int index) throws IOException {
        int numImages = this.checkImageIndex(index);
        File file = AbstractGridCoverageReader.asFile(this.input);
        String name = file != null ? file.getName() : Vocabulary.getResources((Locale)this.locale).getString(232);
        if (numImages != 1) {
            name = String.valueOf(name) + " [" + index + ']';
        }
        return name;
    }

    public abstract CoordinateReferenceSystem getCoordinateReferenceSystem(int var1) throws IOException;

    public abstract Envelope getEnvelope(int var1) throws IOException;

    public synchronized GridEnvelope getGridRange(int index) throws IOException {
        this.checkImageIndex(index);
        int dimension = this.getCoordinateReferenceSystem(index).getCoordinateSystem().getDimension();
        int[] lower = new int[dimension];
        int[] upper = new int[dimension];
        Arrays.fill(upper, 1);
        upper[0] = this.reader.getWidth(index);
        upper[1] = this.reader.getHeight(index);
        return new GeneralGridEnvelope(lower, upper);
    }

    public synchronized MathTransform getMathTransform(int index) throws IOException {
        this.gridToEnvelope.setGridRange(this.getGridRange(index));
        this.gridToEnvelope.setEnvelope(this.getEnvelope(index));
        return this.gridToEnvelope.createTransform();
    }

    public synchronized GridSampleDimension[] getSampleDimensions(int index) throws IOException {
        this.checkImageIndex(index);
        return null;
    }

    public synchronized GridCoverage getGridCoverage(int index) throws IOException {
        this.checkImageIndex(index);
        ImageReadParam param = this.reader.getDefaultReadParam();
        if (param instanceof RawBinaryImageReadParam) {
            RawBinaryImageReadParam rawParam = (RawBinaryImageReadParam)param;
            GridEnvelope range = this.getGridRange(index);
            Dimension size = new Dimension(range.getSpan(0), range.getSpan(1));
            rawParam.setStreamImageSize(size);
        }
        String name = this.getName(index);
        MathTransform gridToCRS = this.getMathTransform(index);
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem(index);
        GridSampleDimension[] bands = this.getSampleDimensions(index);
        RenderedImage image = this.reader.readAsRenderedImage(index, param);
        if (LOGGER.isLoggable(Level.FINE)) {
            Envelope envelope = this.getEnvelope(index);
            StringWriter buffer = new StringWriter();
            LineWriter trimer = new LineWriter((Writer)buffer);
            TableWriter table = new TableWriter((Writer)trimer, 1);
            PrintWriter out = new PrintWriter((Writer)table);
            buffer.write("Creating GridCoverage[\"");
            buffer.write(name);
            buffer.write("\"] with:");
            buffer.write(trimer.getLineSeparator());
            table.setMultiLinesCells(true);
            int sdCount = bands != null ? bands.length : 0;
            int i = -3;
            while (i < sdCount) {
                RenderedImage value;
                String key = "";
                switch (i) {
                    case -3: {
                        key = "RenderedImage";
                        value = image;
                        break;
                    }
                    case -2: {
                        key = "CoordinateReferenceSystem";
                        value = crs;
                        break;
                    }
                    case -1: {
                        key = "Envelope";
                        value = envelope;
                        break;
                    }
                    case 0: {
                        key = "SampleDimensions";
                    }
                    default: {
                        value = bands[i];
                    }
                }
                out.print("    ");
                out.print(key);
                table.nextColumn();
                out.print('=');
                table.nextColumn();
                out.print(value);
                table.nextLine();
                ++i;
            }
            out.flush();
            LOGGER.fine(buffer.toString());
        }
        return this.factory.create((CharSequence)name, image, crs, gridToCRS, bands, null, null);
    }
}

