/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javax.swing.tree.TreeNode;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.io.MetadataException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.io.metadata.Axis;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.Identification;
import org.geotools.image.io.metadata.ImageGeometry;
import org.geotools.image.io.metadata.ImageReferencing;
import org.geotools.image.io.metadata.Parameter;
import org.geotools.io.TableWriter;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.resources.OptionalDependencies;
import org.geotools.util.NumberRange;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataReader {
    private static final String[] METRES = new String[]{"meter", "meters", "metre", "metres", "m"};
    private static final String[] DEGREES = new String[]{"degree", "degrees", "deg", "\u00c2\u00b0"};
    private static final DefaultEllipsoid[] ELLIPSOIDS = new DefaultEllipsoid[]{DefaultEllipsoid.CLARKE_1866, DefaultEllipsoid.GRS80, DefaultEllipsoid.INTERNATIONAL_1924, DefaultEllipsoid.SPHERE, DefaultEllipsoid.WGS84};
    private final ReferencingFactoryContainer factories;
    private GeographicMetadata metadata;
    private UnitFormat unitFormat;

    public MetadataReader() {
        this.factories = ReferencingFactoryContainer.instance(null);
    }

    public MetadataReader(ReferencingFactoryContainer factories) {
        this.factories = factories;
    }

    public synchronized CoordinateSystemAxis getAxis(int dimension) throws MetadataException {
        DefaultCoordinateSystemAxis axisFound;
        ImageReferencing referencing = this.metadata.getReferencing();
        if (this.metadata.getGeometry().getDimension() < dimension) {
            return null;
        }
        Axis axis = referencing.getAxis(dimension);
        String axisName = axis.getName();
        AxisDirection direction = AxisDirection.valueOf((String)axis.getDirection());
        if (axisName == null) {
            String projectionName = referencing.getProjectionName();
            switch (dimension) {
                case 0: {
                    axisName = projectionName == null ? "longitude" : "x";
                    direction = direction == null ? AxisDirection.EAST : direction;
                    break;
                }
                case 1: {
                    axisName = projectionName == null ? "latitude" : "y";
                    direction = direction == null ? AxisDirection.NORTH : direction;
                    break;
                }
                case 2: {
                    axisName = projectionName == null ? "depth" : "z";
                    direction = direction == null ? AxisDirection.UP : direction;
                    break;
                }
                case 3: {
                    axisName = projectionName == null ? "time" : "t";
                    AxisDirection axisDirection = direction = direction == null ? AxisDirection.FUTURE : direction;
                }
            }
        }
        if ((axisFound = DefaultCoordinateSystemAxis.getPredefined((String)axisName, (AxisDirection)direction)) != null) {
            return axisFound;
        }
        String unitName = axis.getUnits();
        Unit<?> unit = this.getUnit(unitName);
        Map<String, String> map = Collections.singletonMap("name", axisName);
        try {
            return this.factories.getCSFactory().createCoordinateSystemAxis(map, axisName, direction, unit);
        }
        catch (FactoryException e) {
            throw new MetadataException(e.getLocalizedMessage());
        }
    }

    private Unit<?> getUnit(String unitName) throws MetadataException {
        if (MetadataReader.contains(unitName, METRES)) {
            return SI.METER;
        }
        if (MetadataReader.contains(unitName, DEGREES)) {
            return NonSI.DEGREE_ANGLE;
        }
        if (this.unitFormat == null) {
            this.unitFormat = UnitFormat.getInstance();
        }
        try {
            return (Unit)this.unitFormat.parseObject(unitName);
        }
        catch (ParseException e) {
            throw new MetadataException("Unit not known : " + unitName, e);
        }
    }

    private static boolean contains(String toSearch, String[] list) {
        int i = list.length;
        while (--i >= 0) {
            if (!toSearch.equalsIgnoreCase(list[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized Datum getDatum() throws MetadataException {
        double greenwichLon;
        ImageReferencing referencing = this.metadata.getReferencing();
        Identification identDatum = referencing.getDatum();
        if (identDatum == null) {
            throw new MetadataException("The datum is not defined.");
        }
        String name = identDatum.name;
        if (name == null) {
            throw new MetadataException("Datum name not defined.");
        }
        if (name.toUpperCase().contains("WGS84")) {
            return DefaultGeodeticDatum.WGS84;
        }
        String primeMeridianName = referencing.getPrimeMeridianName();
        DefaultPrimeMeridian primeMeridian = primeMeridianName == null || primeMeridianName != null && primeMeridianName.toLowerCase().contains("greenwich") ? DefaultPrimeMeridian.GREENWICH : (Double.isNaN(greenwichLon = referencing.getPrimeMeridianGreenwichLongitude()) ? DefaultPrimeMeridian.GREENWICH : new DefaultPrimeMeridian(primeMeridianName, greenwichLon));
        return new DefaultGeodeticDatum(name, this.getEllipsoid(), (PrimeMeridian)primeMeridian);
    }

    public synchronized Ellipsoid getEllipsoid() throws MetadataException {
        ImageReferencing referencing = this.metadata.getReferencing();
        String name = referencing.getEllipsoidName();
        if (name != null) {
            DefaultEllipsoid[] defaultEllipsoidArray = ELLIPSOIDS;
            int n = ELLIPSOIDS.length;
            int n2 = 0;
            while (n2 < n) {
                DefaultEllipsoid ellipsoid = defaultEllipsoidArray[n2];
                if (ellipsoid.nameMatches(name)) {
                    return ellipsoid;
                }
                ++n2;
            }
        } else {
            throw new MetadataException("Ellipsoid name not defined.");
        }
        double semiMajorAxis = referencing.getSemiMajorAxis();
        if (Double.isNaN(semiMajorAxis)) {
            throw new MetadataException("Ellipsoid semi major axis not defined.");
        }
        double semiMinorAxis = referencing.getSemiMinorAxis();
        String ellipsoidUnit = referencing.getEllipsoidUnit();
        if (ellipsoidUnit == null) {
            throw new MetadataException("Ellipsoid unit not defined.");
        }
        Unit<?> unit = this.getUnit(ellipsoidUnit);
        Map<String, String> map = Collections.singletonMap("name", name);
        try {
            DatumFactory datumFactory = this.factories.getDatumFactory();
            return !Double.isNaN(semiMinorAxis) ? datumFactory.createEllipsoid(map, semiMajorAxis, semiMinorAxis, unit) : datumFactory.createFlattenedSphere(map, semiMajorAxis, referencing.getInverseFlattening(), unit);
        }
        catch (FactoryException e) {
            throw new MetadataException(e.getLocalizedMessage());
        }
    }

    public synchronized Conversion getProjection() throws MetadataException {
        ParameterValueGroup paramValueGroup;
        MathTransformFactory mathTransformFactory = this.factories.getMathTransformFactory();
        ImageReferencing referencing = this.metadata.getReferencing();
        String projectionName = referencing.getProjectionName();
        if (projectionName == null) {
            throw new MetadataException("Projection name is not defined.");
        }
        try {
            paramValueGroup = mathTransformFactory.getDefaultParameters(projectionName);
        }
        catch (NoSuchIdentifierException e) {
            throw new MetadataException(e.getLocalizedMessage());
        }
        Parameter[] parameterArray = referencing.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            double value;
            Parameter parameter = parameterArray[n2];
            String name = parameter.getName();
            if (name != null && !Double.isNaN(value = parameter.getValue())) {
                try {
                    paramValueGroup.parameter(name).setValue(value);
                }
                catch (ParameterNotFoundException parameterNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return new DefiningConversion(projectionName, paramValueGroup);
    }

    public synchronized CoordinateReferenceSystem getCoordinateReferenceSystem() throws MetadataException {
        ImageReferencing referencing = this.metadata.getReferencing();
        String name = referencing.getCoordinateReferenceSystem().name;
        if (name == null) {
            name = "Unknown";
        }
        if (name.contains("WGS84")) {
            return name.contains("3D") ? DefaultGeographicCRS.WGS84_3D : DefaultGeographicCRS.WGS84;
        }
        String type = referencing.getCoordinateReferenceSystem().type;
        if (type == null) {
            type = referencing.getProjectionName() == null ? "geographic" : "projected";
        }
        CRSFactory factory = this.factories.getCRSFactory();
        Map<String, String> map = Collections.singletonMap("name", name);
        try {
            if (type.equalsIgnoreCase("geographic")) {
                return factory.createGeographicCRS(map, (GeodeticDatum)this.getDatum(), (EllipsoidalCS)this.getCoordinateSystem());
            }
            GeographicCRS baseCRS = factory.createGeographicCRS(map, (GeodeticDatum)this.getDatum(), (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
            return factory.createProjectedCRS(map, baseCRS, this.getProjection(), (CartesianCS)this.getCoordinateSystem());
        }
        catch (FactoryException e) {
            throw new MetadataException(e.getLocalizedMessage());
        }
    }

    public synchronized CoordinateSystem getCoordinateSystem() throws MetadataException {
        String type;
        String name;
        ImageReferencing referencing = this.metadata.getReferencing();
        Identification cs = referencing.getCoordinateSystem();
        if (cs == null) {
            cs = new Identification("Unknown", null);
        }
        if ((name = cs.name) == null) {
            name = "Unknown";
        }
        if ((type = cs.type) == null) {
            type = referencing.getProjectionName() == null ? "ellipsoidal" : "cartesian";
        }
        CSFactory factory = this.factories.getCSFactory();
        Map<String, String> map = Collections.singletonMap("name", name);
        int dimension = this.metadata.getGeometry().getDimension();
        if (dimension < 2) {
            throw new MetadataException("Number of dimension error : " + dimension);
        }
        try {
            if (type.equalsIgnoreCase("cartesian")) {
                return dimension < 3 ? factory.createCartesianCS(map, this.getAxis(0), this.getAxis(1)) : factory.createCartesianCS(map, this.getAxis(0), this.getAxis(1), this.getAxis(2));
            }
            if (type.equalsIgnoreCase("ellipsoidal")) {
                return dimension < 3 ? factory.createEllipsoidalCS(map, this.getAxis(0), this.getAxis(1)) : factory.createEllipsoidalCS(map, this.getAxis(0), this.getAxis(1), this.getAxis(2));
            }
            throw new MetadataException("Coordinate system type not known : " + type);
        }
        catch (FactoryException e) {
            throw new MetadataException(e.getLocalizedMessage());
        }
    }

    public synchronized Envelope getEnvelope() throws MetadataException {
        ImageGeometry geometry = this.metadata.getGeometry();
        int dimension = geometry.getDimension();
        GeneralEnvelope envelope = new GeneralEnvelope(dimension);
        int i = 0;
        while (i < dimension) {
            NumberRange<Double> range = geometry.getOrdinateRange(i);
            double min = range.getMinimum();
            double max = range.getMaximum();
            try {
                envelope.setRange(i, min, max);
            }
            catch (IndexOutOfBoundsException e) {
                throw new MetadataException(e.getLocalizedMessage());
            }
            ++i;
        }
        return envelope.clone();
    }

    public synchronized GeographicBoundingBox getGeographicBoundingBox() throws MetadataException {
        GeographicBoundingBoxImpl box;
        try {
            box = new GeographicBoundingBoxImpl(this.getEnvelope());
        }
        catch (TransformException exception) {
            throw new MetadataException(exception.getLocalizedMessage());
        }
        box.freeze();
        return box;
    }

    public GeographicMetadata getGeographicMetadata() {
        return this.metadata;
    }

    public void setGeographicMetadata(GeographicMetadata metadata) {
        this.metadata = metadata;
    }

    public synchronized GridEnvelope getGridRange() throws MetadataException {
        ImageGeometry geometry = this.metadata.getGeometry();
        int dimension = geometry.getDimension();
        int[] lowers = new int[dimension];
        int[] uppers = new int[dimension];
        int i = 0;
        while (i < dimension) {
            NumberRange<Integer> range = geometry.getGridRange(i);
            lowers[i] = (Integer)range.getMinValue();
            uppers[i] = (Integer)range.getMaxValue();
            if (!range.isMinIncluded()) {
                int n = i;
                lowers[n] = lowers[n] + 1;
            }
            if (!range.isMaxIncluded()) {
                int n = i;
                uppers[n] = uppers[n] - 1;
            }
            ++i;
        }
        return new GeneralGridEnvelope(lowers, uppers, true);
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringWriter buffer = new StringWriter();
        buffer.write(lineSeparator);
        try {
            GeographicBoundingBox box = this.getGeographicBoundingBox();
            buffer.write(GeographicBoundingBoxImpl.toString((GeographicBoundingBox)box, (String)"DD\u00c2\u00b0MM'SS\"", null));
            buffer.write(lineSeparator);
        }
        catch (MetadataException box) {
            // empty catch block
        }
        buffer.write(123);
        buffer.write(lineSeparator);
        try {
            TableWriter table = new TableWriter((Writer)buffer, 2);
            table.setMultiLinesCells(true);
            table.nextColumn();
            table.write(OptionalDependencies.toString((TreeNode)OptionalDependencies.xmlToSwing((Node)this.metadata.getAsTree("geotools_coverage_1.0"))));
            table.flush();
        }
        catch (IOException exception) {
            buffer.write(exception.getLocalizedMessage());
        }
        buffer.write(125);
        buffer.write(lineSeparator);
        return buffer.toString();
    }

    static String trim(String str, String separator) {
        if (str != null) {
            str = str.trim();
            StringBuilder buffer = null;
            int i = str.length();
            block0: while (--i >= 0) {
                if (!Character.isSpaceChar(str.charAt(i))) continue;
                int upper = i;
                while (--i >= 0) {
                    if (Character.isSpaceChar(str.charAt(i))) continue;
                    if (buffer == null) {
                        buffer = new StringBuilder(str);
                    }
                    buffer.replace(i + 1, upper + 1, separator);
                    continue block0;
                }
                break block0;
            }
            if (buffer != null) {
                return buffer.toString();
            }
        }
        return str;
    }
}

