/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.color.ColorSpace;
import java.io.IOException;
import javax.imageio.ImageTypeSpecifier;
import org.geotools.image.io.Palette;
import org.geotools.image.io.PaletteFactory;
import org.geotools.image.io.ScaledColorSpace;

final class ContinuousPalette
extends Palette {
    static final boolean USE_JAI_MODEL = false;
    protected final float minimum;
    protected final float maximum;
    private final int dataType;

    protected ContinuousPalette(PaletteFactory factory, String name, float minimum, float maximum, int dataType, int numBands, int visibleBand) {
        super(factory, name, numBands, visibleBand);
        this.minimum = minimum;
        this.maximum = maximum;
        this.dataType = dataType;
    }

    double getScale() {
        return this.maximum - this.minimum;
    }

    double getOffset() {
        return this.minimum;
    }

    public synchronized ImageTypeSpecifier getImageTypeSpecifier() throws IOException {
        ImageTypeSpecifier its = this.queryCache();
        if (its != null) {
            return its;
        }
        ColorSpace colorSpace = this.minimum < this.maximum && !Float.isInfinite(this.minimum) && !Float.isInfinite(this.maximum) ? new ScaledColorSpace(this.numBands, this.visibleBand, this.minimum, this.maximum) : ColorSpace.getInstance(1003);
        int[] bankIndices = new int[this.numBands];
        int[] bandOffsets = new int[this.numBands];
        int i = this.numBands;
        while (--i >= 0) {
            bankIndices[i] = i;
        }
        its = ImageTypeSpecifier.createBanded(colorSpace, bankIndices, bandOffsets, this.dataType, false, false);
        this.cache(its);
        return its;
    }

    public int hashCode() {
        return 37 * (37 * (37 * super.hashCode() + Float.floatToIntBits(this.minimum)) + Float.floatToIntBits(this.maximum)) + this.dataType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ContinuousPalette that = (ContinuousPalette)object;
            return Float.floatToIntBits(this.minimum) == Float.floatToIntBits(that.minimum) && Float.floatToIntBits(this.maximum) == Float.floatToIntBits(that.maximum) && this.dataType == that.dataType;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.name) + " [" + this.minimum + " ... " + this.maximum + ']';
    }
}

