/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geotools.image.ImageDimension;
import org.geotools.image.io.SubsampledRectIter;
import org.geotools.resources.IndexedResourceBundle;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Locales;
import org.geotools.util.logging.Logging;

public abstract class GeographicImageWriter
extends ImageWriter {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.image.io");
    private int imageIndex = 0;
    private int thumbnailIndex = 0;

    protected GeographicImageWriter(ImageWriterSpi provider) {
        super(provider);
        this.availableLocales = Locales.getAvailableLocales();
    }

    public void setOutput(Object output) {
        this.imageIndex = 0;
        this.thumbnailIndex = 0;
        super.setOutput(output);
    }

    final IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getLocale());
    }

    private void ensureNonNull(String parameter, Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(this.getErrorResources().getString(143, (Object)parameter));
        }
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        this.ensureNonNull("inData", inData);
        IIOMetadata outData = this.getDefaultStreamMetadata(param);
        String format = GeographicImageWriter.commonMetadataFormatName(inData, outData);
        if (format != null) {
            try {
                outData.mergeTree(format, inData.getAsTree(format));
                return outData;
            }
            catch (IIOInvalidTreeException ex) {
                this.warningOccurred("convertStreamMetadata", ex);
            }
        }
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        this.ensureNonNull("inData", inData);
        IIOMetadata outData = this.getDefaultImageMetadata(imageType, param);
        String format = GeographicImageWriter.commonMetadataFormatName(inData, outData);
        if (format != null) {
            try {
                outData.mergeTree(format, inData.getAsTree(format));
                return outData;
            }
            catch (IIOInvalidTreeException ex) {
                this.warningOccurred("convertImageMetadata", ex);
            }
        }
        return null;
    }

    private static String commonMetadataFormatName(IIOMetadata inData, IIOMetadata outData) {
        String format = outData.getNativeMetadataFormatName();
        if (GeographicImageWriter.isSupportedFormat(inData, format)) {
            return format;
        }
        String[] formats = outData.getExtraMetadataFormatNames();
        if (formats != null) {
            int i = 0;
            while (i < formats.length) {
                format = formats[i];
                if (GeographicImageWriter.isSupportedFormat(inData, format)) {
                    return format;
                }
                ++i;
            }
        }
        if (outData.isStandardMetadataFormatSupported() && inData.isStandardMetadataFormatSupported()) {
            return "javax_imageio_1.0";
        }
        return null;
    }

    private static boolean isSupportedFormat(IIOMetadata metadata, String format) {
        if (format != null) {
            if (format.equalsIgnoreCase(metadata.getNativeMetadataFormatName())) {
                return true;
            }
            String[] formats = metadata.getExtraMetadataFormatNames();
            if (formats != null) {
                int i = 0;
                while (i < formats.length) {
                    if (format.equalsIgnoreCase(formats[i])) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public boolean canWriteRasters() {
        return true;
    }

    protected static RectIter createRectIter(IIOImage image, ImageWriteParam parameters) {
        RectIter iterator;
        int numBands;
        Object raster;
        int[] sourceBands;
        int sourceYSubsampling;
        int sourceXSubsampling;
        Rectangle bounds;
        if (parameters != null) {
            bounds = parameters.getSourceRegion();
            sourceXSubsampling = parameters.getSourceXSubsampling();
            sourceYSubsampling = parameters.getSourceYSubsampling();
            if (sourceXSubsampling != 1 || sourceYSubsampling != 1) {
                if (bounds == null) {
                    if (image.hasRaster()) {
                        bounds = image.getRaster().getBounds();
                    } else {
                        RenderedImage i = image.getRenderedImage();
                        bounds = new Rectangle(i.getMinX(), i.getMinY(), i.getWidth(), i.getHeight());
                    }
                }
                int xOffset = parameters.getSubsamplingXOffset();
                int yOffset = parameters.getSubsamplingYOffset();
                bounds.x += xOffset;
                bounds.y += yOffset;
                bounds.width -= xOffset;
                bounds.height -= yOffset;
                bounds.width -= (bounds.width - 1) % sourceXSubsampling;
                bounds.height -= (bounds.height - 1) % sourceYSubsampling;
            }
            sourceBands = parameters.getSourceBands();
        } else {
            sourceBands = null;
            bounds = null;
            sourceXSubsampling = 1;
            sourceYSubsampling = 1;
        }
        if (image.hasRaster()) {
            raster = image.getRaster();
            numBands = ((Raster)raster).getNumBands();
            iterator = RectIterFactory.create((Raster)raster, (Rectangle)bounds);
        } else {
            raster = image.getRenderedImage();
            numBands = raster.getSampleModel().getNumBands();
            iterator = RectIterFactory.create((RenderedImage)raster, (Rectangle)bounds);
        }
        if (sourceXSubsampling == 1 && sourceYSubsampling == 1) {
            if (sourceBands == null) {
                return iterator;
            }
            if (sourceBands.length == numBands) {
                boolean identity = true;
                int i = 0;
                while (i < numBands) {
                    if (sourceBands[i] != i) {
                        identity = false;
                        break;
                    }
                    ++i;
                }
                if (identity) {
                    return iterator;
                }
            }
        }
        if (sourceBands == null) {
            sourceBands = new int[numBands];
            int i = 0;
            while (i < numBands) {
                sourceBands[i] = i;
                ++i;
            }
        }
        return new SubsampledRectIter(iterator, sourceXSubsampling, sourceYSubsampling, sourceBands);
    }

    protected static ImageDimension computeSize(IIOImage image, ImageWriteParam parameters) {
        ImageDimension dimension = image.hasRaster() ? new ImageDimension(image.getRaster()) : new ImageDimension(image.getRenderedImage());
        if (parameters != null) {
            Rectangle bounds = parameters.getSourceRegion();
            if (bounds != null) {
                if (bounds.width < dimension.width) {
                    dimension.width = bounds.width;
                }
                if (bounds.height < dimension.height) {
                    dimension.height = bounds.height;
                }
            }
            dimension.width -= parameters.getSubsamplingXOffset();
            dimension.height -= parameters.getSubsamplingYOffset();
        }
        return dimension;
    }

    protected void processImageStarted() {
        this.processImageStarted(this.imageIndex);
    }

    protected void processImageComplete() {
        super.processImageComplete();
        this.thumbnailIndex = 0;
        ++this.imageIndex;
    }

    protected void processThumbnailStarted() {
        this.processThumbnailStarted(this.imageIndex, this.thumbnailIndex);
    }

    protected void processThumbnailComplete() {
        super.processThumbnailComplete();
        ++this.thumbnailIndex;
    }

    protected void processWarningOccurred(String warning) {
        this.processWarningOccurred(this.imageIndex, warning);
    }

    protected void processWarningOccurred(String baseName, String keyword) {
        this.processWarningOccurred(this.imageIndex, baseName, keyword);
    }

    public void warningOccurred(LogRecord record) {
        if (this.warningListeners == null) {
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        } else {
            this.processWarningOccurred(IndexedResourceBundle.format((LogRecord)record));
        }
    }

    private void warningOccurred(String method, Exception ex) {
        LogRecord record = new LogRecord(Level.WARNING, ex.toString());
        record.setSourceClassName(GeographicImageWriter.class.getName());
        record.setSourceMethodName(method);
        record.setThrown(ex);
        this.warningOccurred(record);
    }

    void close() throws IOException {
        this.imageIndex = 0;
        this.thumbnailIndex = 0;
    }
}

