/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import org.geotools.resources.Classes;
import org.geotools.resources.XMath;

public abstract class SampleConverter {
    public static final SampleConverter IDENTITY = new Identity();

    protected SampleConverter() {
    }

    public static SampleConverter createPadValueMask(double padValue) {
        return Double.isNaN(padValue) ? IDENTITY : new PadValueMask(padValue);
    }

    public static SampleConverter createPadValuesMask(double[] padValues) {
        if (padValues != null) {
            switch (padValues.length) {
                default: {
                    return new PadValuesMask(padValues);
                }
                case 1: {
                    return SampleConverter.createPadValueMask(padValues[0]);
                }
                case 0: 
            }
        }
        return IDENTITY;
    }

    public static SampleConverter createOffset(double offset, double padValue) {
        return offset == 0.0 ? SampleConverter.createPadValueMask(padValue) : new Offset(offset, padValue);
    }

    public static SampleConverter createOffset(double offset, double[] padValues) {
        if (offset == 0.0) {
            return SampleConverter.createPadValuesMask(padValues);
        }
        if (padValues != null) {
            switch (padValues.length) {
                default: {
                    return new MaskAndOffset(offset, padValues);
                }
                case 1: {
                    return SampleConverter.createOffset(offset, padValues[0]);
                }
                case 0: 
            }
        }
        return SampleConverter.createOffset(offset, Double.NaN);
    }

    public abstract double convert(double var1);

    public abstract float convert(float var1);

    public abstract int convert(int var1);

    public double getOffset() {
        return 0.0;
    }

    public String toString() {
        return String.valueOf(Classes.getShortClassName((Object)this)) + "[offset=" + this.getOffset() + ']';
    }

    private static final class Identity
    extends SampleConverter {
        private Identity() {
        }

        public double convert(double value) {
            return value;
        }

        public float convert(float value) {
            return value;
        }

        public int convert(int value) {
            return value;
        }
    }

    private static final class MaskAndOffset
    extends PadValuesMask {
        private final double doubleOffset;
        private final float floatOffset;

        MaskAndOffset(double offset, double[] padValues) {
            super(padValues);
            this.doubleOffset = offset;
            this.floatOffset = (float)offset;
        }

        public double convert(double value) {
            return super.convert(value) + this.doubleOffset;
        }

        public float convert(float value) {
            return super.convert(value) + this.floatOffset;
        }

        public double getOffset() {
            return this.doubleOffset;
        }
    }

    private static final class Offset
    extends PadValueMask {
        private final double doubleOffset;
        private final float floatOffset;
        private final int integerOffset;

        Offset(double offset, double padValue) {
            super(padValue);
            this.doubleOffset = offset;
            this.floatOffset = (float)offset;
            this.integerOffset = (int)Math.round(offset);
        }

        public double convert(double value) {
            return value == this.doubleValue ? Double.NaN : value + this.doubleOffset;
        }

        public float convert(float value) {
            return value == this.floatValue ? Float.NaN : value + this.floatOffset;
        }

        public int convert(int value) {
            return value == this.integerValue ? 0 : value + this.integerOffset;
        }

        public double getOffset() {
            return this.doubleOffset;
        }
    }

    private static class PadValueMask
    extends SampleConverter {
        final double doubleValue;
        final float floatValue;
        final int integerValue;

        PadValueMask(double padValue) {
            this.doubleValue = padValue;
            this.floatValue = (float)padValue;
            int p = (int)padValue;
            this.integerValue = (double)p == padValue ? p : 0;
        }

        public double convert(double value) {
            return value == this.doubleValue ? Double.NaN : value;
        }

        public float convert(float value) {
            return value == this.floatValue ? Float.NaN : value;
        }

        public int convert(int value) {
            return value == this.integerValue ? 0 : value;
        }
    }

    private static class PadValuesMask
    extends SampleConverter {
        private final double[] doubleValues;
        private final float[] floatValues;
        private final float[] NaNs;

        PadValuesMask(double[] padValues) {
            this.doubleValues = new double[padValues.length];
            this.floatValues = new float[padValues.length];
            this.NaNs = new float[padValues.length];
            int i = 0;
            while (i < padValues.length) {
                this.doubleValues[i] = padValues[i];
                this.floatValues[i] = (float)this.doubleValues[i];
                this.NaNs[i] = XMath.toNaN((int)i);
                ++i;
            }
        }

        public double convert(double value) {
            int i = 0;
            while (i < this.doubleValues.length) {
                if (value == this.doubleValues[i]) {
                    return this.NaNs[i];
                }
                ++i;
            }
            return value;
        }

        public float convert(float value) {
            int i = 0;
            while (i < this.floatValues.length) {
                if (value == this.floatValues[i]) {
                    return this.NaNs[i];
                }
                ++i;
            }
            return value;
        }

        public final int convert(int value) {
            return (int)this.convert((double)value);
        }
    }
}

