/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.color.ColorSpace;
import org.geotools.resources.Classes;

final class ScaledColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 438226855772441165L;
    private static final float MIN_VALUE = 0.0f;
    private static final float MAX_VALUE = 1.0f;
    private final float scale;
    private final float offset;
    private final int visibleBand;

    public ScaledColorSpace(int numComponents, int visibleBand, float minimum, float maximum) {
        super(6, numComponents);
        this.visibleBand = visibleBand;
        this.scale = (maximum - minimum) / 1.0f;
        this.offset = minimum - 0.0f * this.scale;
    }

    public float[] toRGB(float[] values) {
        float value = (values[this.visibleBand] - this.offset) / this.scale;
        if (Float.isNaN(value)) {
            value = 0.0f;
        }
        return new float[]{value, value, value};
    }

    public float[] fromRGB(float[] RGB) {
        float[] values = new float[this.getNumComponents()];
        values[this.visibleBand] = (RGB[0] + RGB[1] + RGB[2]) / 3.0f * this.scale + this.offset;
        return values;
    }

    public float[] toCIEXYZ(float[] values) {
        float value = (values[this.visibleBand] - this.offset) / this.scale;
        if (Float.isNaN(value)) {
            value = 0.0f;
        }
        return new float[]{value * 0.9642f, value * 1.0f, value * 0.8249f};
    }

    public float[] fromCIEXYZ(float[] RGB) {
        float[] values = new float[this.getNumComponents()];
        values[this.visibleBand] = (RGB[0] / 0.9642f + RGB[1] + RGB[2] / 0.8249f) / 3.0f * this.scale + this.offset;
        return values;
    }

    public float getMinValue(int component) {
        return 0.0f * this.scale + this.offset;
    }

    public float getMaxValue(int component) {
        return 1.0f * this.scale + this.offset;
    }

    public String toString() {
        return String.valueOf(Classes.getShortClassName((Object)this)) + '[' + this.getMinValue(this.visibleBand) + ", " + this.getMaxValue(this.visibleBand) + ']';
    }
}

