/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import javax.media.jai.iterator.RectIter;

final class SubsampledRectIter
implements RectIter {
    private final RectIter iterator;
    private int bandIndex;
    private final int[] sourceBands;
    private final int dx;
    private final int dy;

    public SubsampledRectIter(RectIter iterator, int sourceXSubsampling, int sourceYSubsampling, int[] sourceBands) {
        this.iterator = iterator;
        this.dx = sourceXSubsampling - 1;
        this.dy = sourceYSubsampling - 1;
        this.sourceBands = sourceBands;
    }

    public void startLines() {
        this.iterator.startLines();
    }

    public void nextLine() {
        this.nextLineDone();
    }

    public boolean nextLineDone() {
        if (this.iterator.nextLineDone()) {
            return true;
        }
        this.iterator.jumpLines(this.dy);
        return false;
    }

    public void jumpLines(int num) {
        this.iterator.jumpLines(num * (this.dy + 1));
    }

    public boolean finishedLines() {
        return this.iterator.finishedLines();
    }

    public void startPixels() {
        this.iterator.startPixels();
    }

    public void nextPixel() {
        this.nextPixelDone();
    }

    public boolean nextPixelDone() {
        if (this.iterator.nextPixelDone()) {
            return true;
        }
        this.iterator.jumpPixels(this.dx);
        return false;
    }

    public void jumpPixels(int num) {
        this.iterator.jumpPixels(num * (this.dx + 1));
    }

    public boolean finishedPixels() {
        return this.iterator.finishedPixels();
    }

    public void startBands() {
        this.bandIndex = 0;
        this.iterator.startBands();
        int skip = this.sourceBands[0];
        while (--skip >= 0) {
            this.iterator.nextBand();
        }
    }

    public void nextBand() {
        this.nextBandDone();
    }

    public boolean nextBandDone() {
        int skip = this.sourceBands[this.bandIndex];
        if (++this.bandIndex >= this.sourceBands.length) {
            return true;
        }
        if ((skip = this.sourceBands[this.bandIndex] - skip) < 0) {
            this.iterator.startBands();
            skip = this.sourceBands[this.bandIndex];
        }
        while (--skip >= 0) {
            if (!this.iterator.nextBandDone()) continue;
            return true;
        }
        return false;
    }

    public boolean finishedBands() {
        return this.iterator.finishedBands();
    }

    public int getSample() {
        return this.iterator.getSample();
    }

    public int getSample(int b) {
        return this.iterator.getSample(this.sourceBands[b]);
    }

    public float getSampleFloat() {
        return this.iterator.getSampleFloat();
    }

    public float getSampleFloat(int b) {
        return this.iterator.getSampleFloat(this.sourceBands[b]);
    }

    public double getSampleDouble() {
        return this.iterator.getSampleDouble();
    }

    public double getSampleDouble(int b) {
        return this.iterator.getSampleDouble(this.sourceBands[b]);
    }

    public int[] getPixel(int[] a) {
        int length = this.sourceBands.length;
        if (a == null) {
            a = new int[length];
        }
        int i = 0;
        while (i < length) {
            a[i] = this.getSample(i);
            ++i;
        }
        return a;
    }

    public float[] getPixel(float[] a) {
        int length = this.sourceBands.length;
        if (a == null) {
            a = new float[length];
        }
        int i = 0;
        while (i < length) {
            a[i] = this.getSampleFloat(i);
            ++i;
        }
        return a;
    }

    public double[] getPixel(double[] a) {
        int length = this.sourceBands.length;
        if (a == null) {
            a = new double[length];
        }
        int i = 0;
        while (i < length) {
            a[i] = this.getSampleDouble(i);
            ++i;
        }
        return a;
    }
}

