/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import java.awt.image.DataBuffer;
import org.geotools.image.io.metadata.ChildList;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.MetadataAccessor;
import org.geotools.util.NumberRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Band
extends MetadataAccessor {
    protected Band(GeographicMetadata metadata, int bandIndex) {
        this(metadata.getBands(), bandIndex);
    }

    Band(ChildList<Band> parent, int bandIndex) {
        super(parent);
        this.selectChild(bandIndex);
    }

    public String getName() {
        return this.getAttributeAsString("name");
    }

    public void setName(String name) {
        this.setAttributeAsString("name", name);
    }

    public NumberRange getValidRange() {
        Class type;
        Number maximum;
        Number minimum;
        boolean enabled = this.setWarningsEnabled(false);
        try {
            minimum = this.getAttributeAsInteger("minValue");
            maximum = this.getAttributeAsInteger("maxValue");
        }
        finally {
            this.setWarningsEnabled(enabled);
        }
        if (minimum == null || maximum == null) {
            minimum = this.getAttributeAsDouble("minValue");
            maximum = this.getAttributeAsDouble("maxValue");
            type = Double.class;
        } else {
            type = Integer.class;
        }
        return new NumberRange(type, minimum, true, maximum, true);
    }

    public void setValidRange(double minValue, double maxValue) {
        int minIndex = (int)minValue;
        int maxIndex = (int)maxValue;
        if ((double)minIndex == minValue && (double)maxIndex == maxValue) {
            this.setAttributeAsInteger("minValue", minIndex);
            this.setAttributeAsInteger("maxValue", maxIndex);
        } else {
            this.setAttributeAsDouble("minValue", minValue);
            this.setAttributeAsDouble("maxValue", maxValue);
        }
    }

    public double[] getNoDataValues() {
        return this.getAttributeAsDoubles("fillValues", true);
    }

    public void setNoDataValues(double[] fillValues) {
        if (fillValues != null) {
            int[] asIntegers = new int[fillValues.length];
            int i = 0;
            while (i < fillValues.length) {
                double value = fillValues[i];
                asIntegers[i] = (int)value;
                if ((double)asIntegers[i] != value) {
                    asIntegers = null;
                    break;
                }
                ++i;
            }
            if (asIntegers != null) {
                this.setAttributeAsIntegers("fillValues", asIntegers);
                return;
            }
        }
        this.setAttributeAsDoubles("fillValues", fillValues);
    }

    public void setPackedValues(double minValue, double maxValue, double[] fillValues, int dataType) {
        minValue = Band.replaceInfinity(minValue, fillValues, dataType);
        maxValue = Band.replaceInfinity(maxValue, fillValues, dataType);
        this.setValidRange(minValue, maxValue);
        this.setNoDataValues(fillValues);
    }

    private static double replaceInfinity(double value, double[] fillValues, int dataType) {
        double midValue;
        boolean negative;
        if (value == Double.NEGATIVE_INFINITY) {
            negative = true;
        } else if (value == Double.POSITIVE_INFINITY) {
            negative = false;
        } else {
            return value;
        }
        switch (dataType) {
            default: {
                long range = 1L << DataBuffer.getDataTypeSize(dataType);
                value = negative ? 0L : range - 1L;
                midValue = range >>> 1;
                break;
            }
            case 2: {
                value = negative ? Short.MIN_VALUE : Short.MAX_VALUE;
                midValue = 0.0;
                break;
            }
            case 3: {
                value = negative ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                midValue = 0.0;
                break;
            }
            case 4: 
            case 5: 
            case 32: {
                return value;
            }
        }
        if (fillValues != null) {
            double valueDistance = Math.abs(value - midValue);
            int i = 0;
            while (i < fillValues.length) {
                double fillDistance;
                double fillValue = fillValues[i];
                if (fillValue < midValue == negative && (fillDistance = Math.abs(fillValue - midValue)) <= valueDistance) {
                    valueDistance = fillDistance;
                    value = fillValue - 1.0;
                }
                ++i;
            }
        }
        return value;
    }

    public double getScale() {
        Double scale = this.getAttributeAsDouble("scale");
        return scale != null ? scale : 1.0;
    }

    public void setScale(double scale) {
        this.setAttributeAsDouble("scale", scale);
    }

    public double getOffset() {
        Double offset = this.getAttributeAsDouble("offset");
        return offset != null ? offset : 0.0;
    }

    public void setOffset(double offset) {
        this.setAttributeAsDouble("offset", offset);
    }
}

