/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import org.geotools.resources.XArray;

public class MetadataMerge {
    private MetadataMerge() {
    }

    public static IIOMetadata merge(IIOMetadata source, IIOMetadata target) throws IllegalStateException, IIOInvalidTreeException {
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        String format = MetadataMerge.commonFormatName(source, target);
        if (format != null) {
            target.mergeTree(format, source.getAsTree(format));
        }
        return null;
    }

    private static String commonFormatName(IIOMetadata source, IIOMetadata target) {
        Object[] sourceFormats = source.getMetadataFormatNames();
        Object format = target.getNativeMetadataFormatName();
        if (format != null && XArray.contains((Object[])sourceFormats, (Object)format)) {
            return format;
        }
        Object[] targetFormats = target.getExtraMetadataFormatNames();
        if (targetFormats != null) {
            format = source.getNativeMetadataFormatName();
            if (format != null && XArray.contains((Object[])targetFormats, (Object)format)) {
                return format;
            }
            int i = 0;
            while (i < targetFormats.length) {
                format = targetFormats[i];
                if (XArray.contains((Object[])sourceFormats, (Object)format)) {
                    return format;
                }
                ++i;
            }
        }
        if (source.isStandardMetadataFormatSupported() && target.isStandardMetadataFormatSupported()) {
            return "javax_imageio_1.0";
        }
        return null;
    }
}

