/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.ImageGeometry;
import org.geotools.image.io.mosaic.GridTileManager;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TileManager;
import org.geotools.image.io.mosaic.TreeTileManager;
import org.geotools.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComparedTileManager
extends TileManager {
    private static final long serialVersionUID = -6028433158360279586L;
    private final TileManager first;
    private final TileManager second;

    ComparedTileManager(Tile[] tiles) throws IOException {
        this.second = new GridTileManager(tiles);
        this.first = new TreeTileManager(tiles);
    }

    ComparedTileManager(TileManager first, TileManager second) {
        this.first = first;
        this.second = second;
    }

    private <T> T assertEqual(T o1, T o2) throws AssertionError {
        if (!Utilities.equals(o1, o2)) {
            throw new AssertionError((Object)(String.valueOf(this.first.getClass().getSimpleName()) + '=' + o1 + ", " + this.second.getClass().getSimpleName() + '=' + o2));
        }
        return o1;
    }

    private boolean equal(Collection<Tile> c1, Collection<Tile> c2) {
        return ComparedTileManager.equals(this.first, c1, c2) & ComparedTileManager.equals(this.second, c2, c1);
    }

    private static boolean equals(TileManager manager, Collection<Tile> c1, Collection<Tile> c2) {
        LinkedHashSet<Tile> remainding = new LinkedHashSet<Tile>(c1);
        for (Tile tile : c2) {
            remainding.remove(tile);
        }
        if (remainding.isEmpty()) {
            return true;
        }
        PrintStream err = System.err;
        err.print("Additional tiles from ");
        err.print(manager.getClass().getSimpleName());
        err.println(':');
        err.println(Tile.toString(remainding, 100));
        return false;
    }

    @Override
    public void setGridToCRS(AffineTransform gridToCRS) throws IllegalStateException, IOException {
        this.first.setGridToCRS(gridToCRS);
        this.second.setGridToCRS(gridToCRS);
    }

    @Override
    public ImageGeometry getGridGeometry() throws IOException {
        return this.assertEqual(this.first.getGridGeometry(), this.second.getGridGeometry());
    }

    @Override
    Rectangle getRegion() throws IOException {
        return this.assertEqual(this.first.getRegion(), this.second.getRegion());
    }

    @Override
    Dimension getTileSize() throws IOException {
        return this.assertEqual(this.first.getTileSize(), this.second.getTileSize());
    }

    @Override
    boolean isImageTiled() throws IOException {
        return this.assertEqual(this.first.isImageTiled(), this.second.isImageTiled());
    }

    @Override
    public Set<ImageReaderSpi> getImageReaderSpis() throws IOException {
        return this.assertEqual(this.first.getImageReaderSpis(), this.second.getImageReaderSpis());
    }

    @Override
    public Tile createGlobalTile(ImageReaderSpi provider, Object input, int imageIndex) throws NoSuchElementException, IOException {
        return this.assertEqual(this.first.createGlobalTile(provider, input, imageIndex), this.second.createGlobalTile(provider, input, imageIndex));
    }

    @Override
    public Collection<Tile> getTiles() throws IOException {
        Collection<Tile> tiles = this.first.getTiles();
        if (!this.equal(tiles, this.second.getTiles())) {
            throw new AssertionError();
        }
        return tiles;
    }

    @Override
    public Collection<Tile> getTiles(Rectangle region, Dimension subsampling, boolean subsamplingChangeAllowed) throws IOException {
        Dimension copy = new Dimension(subsampling);
        Collection<Tile> tiles = this.first.getTiles(region, subsampling, subsamplingChangeAllowed);
        if (this.equal(tiles, this.second.getTiles(region, copy, subsamplingChangeAllowed))) {
            this.assertEqual(subsampling, copy);
        }
        return tiles;
    }

    @Override
    public boolean intersects(Rectangle region, Dimension subsampling) throws IOException {
        return this.assertEqual(this.first.intersects(region, subsampling), this.second.intersects(region, subsampling));
    }

    public int hashCode() {
        return 0x83BFD5DE ^ this.first.hashCode() + 37 * this.second.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ComparedTileManager) {
            ComparedTileManager that = (ComparedTileManager)object;
            return Utilities.equals((Object)this.first, (Object)that.first) && Utilities.equals((Object)this.second, (Object)that.second);
        }
        return false;
    }
}

