/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Rectangle;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.resources.i18n.Errors;

final class FilenameFormatter
implements Serializable {
    private static final long serialVersionUID = 67144666748146079L;
    private static final String DEFAULT_PREFIX = "L";
    private int levelFieldSize;
    private int rowFieldSize;
    private int columnFieldSize;
    private String prefix;
    private String levelSeparator = "_";
    private String locationSeparator = "";
    private String suffix;

    public void initialize(ImageReaderSpi tileReaderSpi) {
        if (this.prefix == null) {
            this.prefix = DEFAULT_PREFIX;
        }
        this.suffix = "";
        String[] suffixes = tileReaderSpi.getFileSuffixes();
        if (suffixes != null) {
            int i = 0;
            while (i < suffixes.length) {
                String s = suffixes[i];
                if (s.length() > this.suffix.length()) {
                    this.suffix = s;
                }
                ++i;
            }
            if (!this.suffix.startsWith(".")) {
                this.suffix = "." + this.suffix;
            }
        }
        this.levelFieldSize = 0;
        this.rowFieldSize = 0;
        this.columnFieldSize = 0;
    }

    public void computeLevelFieldSize(int n) {
        this.levelFieldSize = (int)Math.log10(n) + 1;
    }

    public void computeFieldSizes(Rectangle imageBounds, Rectangle tileBounds) {
        StringBuilder buffer = new StringBuilder();
        FilenameFormatter.format26(buffer, imageBounds.width / tileBounds.width, 0);
        this.columnFieldSize = buffer.length();
        buffer.setLength(0);
        FilenameFormatter.format10(buffer, imageBounds.height / tileBounds.height, 0);
        this.rowFieldSize = buffer.length();
    }

    private static void format10(StringBuilder buffer, int n, int size) {
        String s = Integer.toString(n + 1);
        int i = size - s.length();
        while (--i >= 0) {
            buffer.append('0');
        }
        buffer.append(s);
    }

    private static void format26(StringBuilder buffer, int n, int size) {
        if (size > 1 || n >= 26) {
            FilenameFormatter.format26(buffer, n / 26, size - 1);
            n %= 26;
        }
        buffer.append((char)(65 + n));
    }

    public void ensurePrefixSet(Object input) {
        if (this.prefix == null) {
            String filename;
            if (input instanceof File) {
                filename = ((File)input).getName();
            } else if (input instanceof URI || input instanceof URL || input instanceof CharSequence) {
                filename = input.toString();
                filename = filename.substring(filename.lastIndexOf(47) + 1);
            } else {
                filename = DEFAULT_PREFIX;
            }
            int length = filename.lastIndexOf(46);
            if (length < 0) {
                length = filename.length();
            }
            int i = 0;
            while (i < length) {
                if (!Character.isLetter(filename.charAt(i))) break;
                ++i;
            }
            this.prefix = filename.substring(0, i);
        }
    }

    public String generateFilename(int level, int column, int row) {
        StringBuilder buffer = new StringBuilder(this.prefix);
        FilenameFormatter.format10(buffer, level, this.levelFieldSize);
        buffer.append(this.levelSeparator);
        FilenameFormatter.format26(buffer, column, this.columnFieldSize);
        buffer.append(this.locationSeparator);
        FilenameFormatter.format10(buffer, row, this.rowFieldSize);
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
        return buffer.toString();
    }

    public String guessPattern(int level, int column, int row, String filename) {
        int last = filename.length();
        StringBuilder buffer = new StringBuilder();
        int fieldNumber = 0;
        block10: while (true) {
            boolean useLetters;
            int fieldValue;
            switch (fieldNumber) {
                case 0: {
                    fieldValue = row;
                    useLetters = false;
                    break;
                }
                case 1: {
                    fieldValue = column;
                    useLetters = true;
                    break;
                }
                case 2: {
                    fieldValue = level;
                    useLetters = false;
                    break;
                }
                default: {
                    break block10;
                }
            }
            buffer.setLength(0);
            if (useLetters) {
                FilenameFormatter.format26(buffer, fieldValue, 0);
            } else {
                FilenameFormatter.format10(buffer, fieldValue, 0);
            }
            String fieldText = buffer.toString();
            int length = fieldText.length();
            int start = filename.lastIndexOf(fieldText, last - length);
            if (start < 0) {
                return null;
            }
            int end = start + length;
            if (end < last) {
                char c = filename.charAt(end);
                if (useLetters ? Character.isLetter(c) : Character.isDigit(c)) {
                    return null;
                }
            }
            char fill = useLetters ? (char)'A' : '0';
            while (start != 0) {
                char c = filename.charAt(start - 1);
                if (c != fill) {
                    if (!(useLetters ? Character.isLetter(c) : Character.isDigit(c))) break;
                    return null;
                }
                --start;
            }
            String separator = filename.substring(end, last);
            length = end - start;
            switch (fieldNumber) {
                case 0: {
                    this.suffix = separator;
                    this.rowFieldSize = length;
                    break;
                }
                case 1: {
                    this.locationSeparator = separator;
                    this.columnFieldSize = length;
                    break;
                }
                case 2: {
                    this.levelSeparator = separator;
                    this.levelFieldSize = length;
                }
            }
            last = start;
            ++fieldNumber;
        }
        this.prefix = filename.substring(0, last);
        assert (filename.equals(this.generateFilename(level, column, row))) : filename;
        return this.toString();
    }

    public void applyPattern(String pattern) throws IllegalArgumentException {
        int last = 0;
        NumberFormatException cause = null;
        int fieldNumber = 0;
        while (true) {
            int n;
            String field;
            switch (fieldNumber) {
                case 0: {
                    field = "{level:";
                    break;
                }
                case 1: {
                    field = "{column:";
                    break;
                }
                case 2: {
                    field = "{row:";
                    break;
                }
                default: {
                    this.suffix = pattern.substring(last);
                    return;
                }
            }
            int i = pattern.indexOf(field, last);
            if (i < 0) break;
            String separator = pattern.substring(last, i);
            last = pattern.indexOf(125, i += field.length());
            if (last < 0) break;
            try {
                n = Integer.parseInt(pattern.substring(i, last));
            }
            catch (NumberFormatException e) {
                cause = e;
                break;
            }
            ++last;
            switch (fieldNumber) {
                case 0: {
                    this.prefix = separator;
                    this.levelFieldSize = n;
                    break;
                }
                case 1: {
                    this.levelSeparator = separator;
                    this.columnFieldSize = n;
                    break;
                }
                case 2: {
                    this.locationSeparator = separator;
                    this.rowFieldSize = n;
                }
            }
            ++fieldNumber;
        }
        throw new IllegalArgumentException(Errors.format((int)58, (Object)"pattern", (Object)pattern), cause);
    }

    public String toString() {
        return String.valueOf(this.prefix != null ? this.prefix : DEFAULT_PREFIX) + "{level:" + this.levelFieldSize + '}' + this.levelSeparator + "{column:" + this.columnFieldSize + '}' + this.locationSeparator + "{row:" + this.rowFieldSize + '}' + this.suffix;
    }
}

