/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Rectangle;
import java.util.Map;
import org.geotools.image.io.mosaic.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SelectedNode
extends TreeNode {
    protected long cost;

    SelectedNode(Rectangle readRegion) {
        super(readRegion);
        assert (!this.isEmpty());
    }

    @Override
    public void addChild(TreeNode child) throws ClassCastException {
        long added;
        super.addChild(child);
        if (child != null && (added = ((SelectedNode)child).cost) != 0L) {
            SelectedNode parent = this;
            do {
                parent.cost += added;
            } while ((parent = (SelectedNode)parent.getParent()) != null);
        }
    }

    @Override
    public void removeChildren() {
        long removed = this.childrenCost();
        if (removed != 0L) {
            SelectedNode parent = this;
            do {
                parent.cost -= removed;
            } while ((parent = (SelectedNode)parent.getParent()) != null);
        }
        super.removeChildren();
    }

    @Override
    public void remove() {
        if (this.cost != 0L) {
            TreeNode parent = this;
            while ((parent = parent.getParent()) != null) {
                parent.cost -= this.cost;
            }
        }
        super.remove();
    }

    private long childrenCost() {
        long c = 0L;
        SelectedNode child = (SelectedNode)this.firstChildren();
        while (child != null) {
            c += child.cost;
            child = (SelectedNode)child.nextSibling();
        }
        assert (this.cost >= c);
        return c;
    }

    public final boolean isCheaperThan(SelectedNode other) {
        if (this.cost < other.cost) {
            return true;
        }
        if (this.cost == other.cost) {
            return this.getTileCount() < other.getTileCount();
        }
        return false;
    }

    final void removeTrivialOverlaps(Map<Rectangle, SelectedNode> overlaps) {
        SelectedNode existing;
        SelectedNode child = (SelectedNode)this.firstChildren();
        while (child != null) {
            SelectedNode next = (SelectedNode)child.nextSibling();
            child.removeTrivialOverlaps(overlaps);
            child = next;
        }
        if (this.tile == null && (child = (SelectedNode)this.firstChildren()) != null) {
            int xmin = this.x;
            int ymin = this.y;
            int w = this.width;
            int h = this.height;
            this.height = -1;
            this.width = -1;
            do {
                assert (!child.isEmpty()) : child;
                this.add(child);
            } while ((child = (SelectedNode)child.nextSibling()) != null);
            if (this.x < xmin) {
                w -= xmin - this.x;
                this.x = xmin;
            }
            if (this.y < ymin) {
                h -= ymin - this.y;
                this.y = ymin;
            }
            if (this.width > w) {
                this.width = w;
            }
            if (this.height > h) {
                this.height = h;
            }
        }
        if ((existing = overlaps.put(this, this)) != null && existing != this) {
            if (!this.isCheaperThan(existing)) {
                if (existing.getParent() == this) {
                    if (this.tile != null) {
                        this.tile = null;
                        this.cost = this.childrenCost();
                    }
                    return;
                }
                overlaps.put(existing, existing);
                existing = this;
            }
            existing.remove();
            existing.removeFrom(overlaps);
            assert (overlaps.get(existing) != existing);
        }
    }

    private void removeFrom(Map<Rectangle, SelectedNode> overlaps) {
        SelectedNode child = (SelectedNode)this.firstChildren();
        while (child != null) {
            child.removeFrom(overlaps);
            SelectedNode existing = overlaps.remove(child);
            if (existing != null && existing != child) {
                overlaps.put(existing, existing);
            }
            child = (SelectedNode)child.nextSibling();
        }
    }

    @Override
    boolean checkValidity() {
        if (this.childrenCost() > this.cost) {
            throw new AssertionError(this);
        }
        return super.checkValidity();
    }
}

