/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.geotools.image.io.mosaic.MosaicImageReader;
import org.geotools.io.TableWriter;
import org.geotools.resources.Classes;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile
implements Comparable<Tile>,
Serializable {
    private static final long serialVersionUID = -5417183834232374962L;
    static final int MASK = 65535;
    private transient ImageReaderSpi provider;
    private final Object input;
    private final short imageIndex;
    private short xSubsampling;
    private short ySubsampling;
    private int x;
    private int y;
    private short width;
    private short height;
    private AffineTransform gridToCRS;

    Tile(Tile tile, Object input, Rectangle region) throws IllegalArgumentException {
        Tile.ensureNonNull("tile", tile);
        if (region != null) {
            if (region.isEmpty()) {
                throw new IllegalArgumentException(Errors.format((int)2, (Object)region));
            }
            this.x = region.x;
            this.y = region.y;
            this.setSize(region.width, region.height);
        } else {
            this.x = tile.x;
            this.y = tile.y;
            this.width = tile.width;
            this.height = tile.height;
        }
        this.input = input != null ? input : tile.input;
        this.provider = tile.provider;
        this.imageIndex = tile.imageIndex;
        this.xSubsampling = tile.xSubsampling;
        this.ySubsampling = tile.ySubsampling;
        this.gridToCRS = tile.gridToCRS;
    }

    public Tile(ImageReaderSpi provider, Object input, int imageIndex, Point location, Dimension subsampling) throws IllegalArgumentException {
        if (provider == null) {
            provider = Tile.getImageReaderSpi(input);
        }
        Tile.ensureNonNull("provider", provider);
        Tile.ensureNonNull("input", input);
        Tile.ensureNonNull("location", location);
        this.provider = provider;
        this.input = input;
        this.imageIndex = Tile.ensurePositive(imageIndex);
        this.x = location.x;
        this.y = location.y;
        if (subsampling != null) {
            this.xSubsampling = Tile.ensureStrictlyPositive(subsampling.width);
            this.ySubsampling = Tile.ensureStrictlyPositive(subsampling.height);
        } else {
            this.ySubsampling = 1;
            this.xSubsampling = 1;
        }
    }

    public Tile(ImageReaderSpi provider, Object input, int imageIndex, Rectangle region, Dimension subsampling) throws IllegalArgumentException {
        if (provider == null) {
            provider = Tile.getImageReaderSpi(input);
        }
        Tile.ensureNonNull("provider", provider);
        Tile.ensureNonNull("input", input);
        Tile.ensureNonNull("region", region);
        if (region.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((int)2, (Object)region));
        }
        this.provider = provider;
        this.input = input;
        this.imageIndex = Tile.ensurePositive(imageIndex);
        this.x = region.x;
        this.y = region.y;
        this.setSize(region.width, region.height);
        if (subsampling != null) {
            this.xSubsampling = Tile.ensureStrictlyPositive(subsampling.width);
            this.ySubsampling = Tile.ensureStrictlyPositive(subsampling.height);
        } else {
            this.ySubsampling = 1;
            this.xSubsampling = 1;
        }
    }

    public Tile(ImageReaderSpi provider, Object input, int imageIndex, Rectangle region, AffineTransform gridToCRS) throws IllegalArgumentException {
        if (provider == null) {
            provider = Tile.getImageReaderSpi(input);
        }
        Tile.ensureNonNull("provider", provider);
        Tile.ensureNonNull("input", input);
        Tile.ensureNonNull("gridToCRS", gridToCRS);
        this.provider = provider;
        this.input = input;
        this.imageIndex = Tile.ensurePositive(imageIndex);
        if (region != null) {
            this.x = region.x;
            this.y = region.y;
            if (!region.isEmpty()) {
                this.setSize(region.width, region.height);
            }
        }
        this.gridToCRS = new AffineTransform(gridToCRS);
    }

    public Tile(ImageReaderSpi provider, Object input, int imageIndex, Rectangle region) throws IllegalArgumentException {
        this(provider, input, imageIndex, region, (Dimension)null);
    }

    static void ensureNonNull(String argument, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)argument));
        }
    }

    private static short ensurePositive(int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(Errors.format((int)201, (Object)n, (Object)0, (Object)65535));
        }
        return (short)n;
    }

    static short ensureStrictlyPositive(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException(Errors.format((int)125, (Object)n));
        }
        return Tile.ensurePositive(n);
    }

    final void checkGeometryValidity() throws IllegalStateException {
        if (this.xSubsampling == 0 || this.ySubsampling == 0) {
            throw new IllegalStateException("Tile must be processed by TileManagerFactory.");
        }
    }

    static void close(Object input) throws IOException {
        if (input instanceof ImageInputStream) {
            ((ImageInputStream)input).close();
        } else if (input instanceof Closeable) {
            ((Closeable)input).close();
        }
    }

    static void dispose(ImageReader reader) throws IOException {
        Object input = reader.getInput();
        reader.dispose();
        Tile.close(input);
    }

    private static boolean isValidInput(Class<?>[] types, Object input) {
        if (types != null) {
            Class<?>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                if (type != null && type.isInstance(input)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected ImageReader getImageReader(MosaicImageReader mosaic, boolean seekForwardOnly, boolean ignoreMetadata) throws IOException {
        Object currentInput;
        ImageReader reader;
        ImageReaderSpi provider = this.getImageReaderSpi();
        if (mosaic != null) {
            reader = mosaic.getTileReader(provider);
            currentInput = mosaic.getRawInput(reader);
        } else {
            reader = provider.createReaderInstance();
            currentInput = null;
        }
        Object input = this.getInput();
        boolean sameInput = Utilities.equals((Object)input, (Object)currentInput);
        if (!sameInput || this.getImageIndex() < reader.getMinIndex() || !seekForwardOnly && reader.isSeekForwardOnly() || !ignoreMetadata && reader.isIgnoringMetadata()) {
            ImageReaderSpi spi;
            Object actualInput = reader.getInput();
            reader.setInput(null);
            if (mosaic != null) {
                mosaic.setRawInput(reader, null);
            }
            ImageInputStream stream = null;
            if (actualInput instanceof ImageInputStream) {
                stream = (ImageInputStream)actualInput;
            }
            if ((spi = reader.getOriginatingProvider()) == null || Tile.isValidInput(spi.getInputTypes(), input)) {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
                actualInput = input;
            } else {
                if (stream != null) {
                    if (sameInput) {
                        try {
                            stream.seek(0L);
                        }
                        catch (IndexOutOfBoundsException e) {
                            Logging.recoverableException(Tile.class, (String)"getImageReader", (Throwable)e);
                            stream.close();
                            stream = null;
                        }
                    } else {
                        stream.close();
                        stream = null;
                    }
                }
                if (stream == null) {
                    stream = this.getInputStream();
                }
                actualInput = stream;
            }
            reader.setInput(actualInput, seekForwardOnly, ignoreMetadata);
            if (mosaic != null) {
                mosaic.setRawInput(reader, input);
            }
        }
        return reader;
    }

    public ImageReader getImageReader() throws IOException {
        return this.getImageReader(null, true, true);
    }

    public ImageReaderSpi getImageReaderSpi() {
        return this.provider;
    }

    static ImageReaderSpi getImageReaderSpi(Object input) {
        int split;
        ImageReaderSpi provider = null;
        String path = Tile.getInputName(input);
        if (path != null && (split = path.indexOf(46, path.lastIndexOf(47) + 1)) >= 0) {
            String suffix = path.substring(split + 1).trim();
            Object[] suffixes = null;
            Iterator<ImageReaderSpi> it = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
            while (it.hasNext()) {
                ImageReaderSpi candidate = it.next();
                Object[] candidateSuffixes = candidate.getFileSuffixes();
                if (!XArray.containsIgnoreCase((String[])candidateSuffixes, (String)suffix)) continue;
                if (provider != null) {
                    if (Arrays.equals(candidateSuffixes, suffixes)) continue;
                    return null;
                }
                provider = candidate;
                suffixes = candidateSuffixes;
            }
        }
        return provider;
    }

    private ImageInputStream getInputStream() throws IOException {
        String path;
        Serializable url;
        Object input = this.getInput();
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        if (stream != null) {
            return stream;
        }
        if (input instanceof CharSequence && (stream = ImageIO.createImageInputStream(url = (path = input.toString()).indexOf("://") > 0 ? new URL(path) : new File(path))) != null) {
            return stream;
        }
        if (input instanceof File) {
            stream = new FileImageInputStream((File)input);
            return stream;
        }
        throw new FileNotFoundException(Errors.format((int)50, (Object)input));
    }

    public Object getInput() {
        return this.input;
    }

    public String getInputName() {
        String name = Tile.getInputName(this.getInput());
        if (name == null) {
            name = "class " + Classes.getShortClassName((Object)this.input);
        }
        return name;
    }

    private static String getInputName(Object input) {
        if (input instanceof File) {
            return ((File)input).getName();
        }
        if (input instanceof URI) {
            return ((URI)input).getPath();
        }
        if (input instanceof URL) {
            return ((URL)input).getPath();
        }
        if (input instanceof CharSequence) {
            return input.toString();
        }
        return null;
    }

    public String getFormatName() {
        return Tile.toString(this.getImageReaderSpi());
    }

    public int getImageIndex() {
        return this.imageIndex & 0xFFFF;
    }

    final AffineTransform getPendingGridToCRS(boolean clear) {
        assert (!clear || Thread.holdsLock(this));
        if (this.xSubsampling != 0 || this.ySubsampling != 0) {
            return null;
        }
        AffineTransform gridToCRS = this.gridToCRS;
        if (clear) {
            this.gridToCRS = null;
        }
        return gridToCRS;
    }

    public synchronized AffineTransform getGridToCRS() throws IllegalStateException {
        this.checkGeometryValidity();
        return this.gridToCRS;
    }

    final synchronized void setGridToCRS(AffineTransform at) throws IllegalStateException {
        if (this.gridToCRS != null) {
            if (!this.gridToCRS.equals(at)) {
                throw new IllegalStateException();
            }
        } else {
            this.gridToCRS = at;
        }
    }

    public synchronized Dimension getSubsampling() throws IllegalStateException {
        this.checkGeometryValidity();
        return new Dimension(this.xSubsampling & 0xFFFF, this.ySubsampling & 0xFFFF);
    }

    final void setSubsampling(Dimension subsampling) throws IllegalStateException {
        assert (Thread.holdsLock(this));
        if (this.xSubsampling != 0 || this.ySubsampling != 0) {
            throw new IllegalStateException();
        }
        this.xSubsampling = Tile.ensureStrictlyPositive(subsampling.width);
        this.ySubsampling = Tile.ensureStrictlyPositive(subsampling.height);
    }

    public Dimension getSubsamplingFloor(Dimension subsampling) throws IllegalStateException {
        if (subsampling != null) {
            int dy;
            int dx;
            try {
                dx = subsampling.width % (this.xSubsampling & 0xFFFF);
                dy = subsampling.height % (this.ySubsampling & 0xFFFF);
            }
            catch (ArithmeticException e) {
                throw new IllegalStateException("Tile must be processed by TileManagerFactory.", e);
            }
            if (dx != 0 || dy != 0) {
                int sourceXSubsampling = subsampling.width - dx;
                int sourceYSubsampling = subsampling.height - dy;
                if (sourceXSubsampling != 0 && sourceYSubsampling != 0) {
                    return new Dimension(sourceXSubsampling, sourceYSubsampling);
                }
                return null;
            }
        }
        return subsampling;
    }

    final boolean isFinerThan(Dimension subsampling) {
        return (this.xSubsampling & 0xFFFF) < subsampling.width || (this.ySubsampling & 0xFFFF) < subsampling.height;
    }

    final boolean isLargerThan(Tile other) {
        return this.xSubsampling == other.xSubsampling && this.ySubsampling == other.ySubsampling && (this.width & 0xFFFF) * (this.height & 0xFFFF) > (other.width & 0xFFFF) * (other.height & 0xFFFF);
    }

    public synchronized Point getLocation() throws IllegalStateException {
        this.checkGeometryValidity();
        return new Point(this.x, this.y);
    }

    final boolean isSizeEquals(int dx, int dy) {
        assert (this.getClass().equals(Tile.class) && this.width != 0 && this.height != 0) : this;
        return (this.width & 0xFFFF) == dx && (this.height & 0xFFFF) == dy;
    }

    public synchronized Rectangle getRegion() throws IllegalStateException, IOException {
        this.checkGeometryValidity();
        if (this.width == 0 && this.height == 0) {
            int imageIndex = this.getImageIndex();
            ImageReader reader = this.getImageReader();
            this.setSize(reader.getWidth(imageIndex), reader.getHeight(imageIndex));
            Tile.dispose(reader);
        }
        return new Rectangle(this.x, this.y, this.width & 0xFFFF, this.height & 0xFFFF);
    }

    final Rectangle getAbsoluteRegion() throws IOException {
        Rectangle region = this.getRegion();
        int sx = this.xSubsampling & 0xFFFF;
        int sy = this.ySubsampling & 0xFFFF;
        region.x *= sx;
        region.y *= sy;
        region.width *= sx;
        region.height *= sy;
        return region;
    }

    final void setAbsoluteRegion(Rectangle region) throws ArithmeticException {
        assert (Thread.holdsLock(this));
        int sx = this.xSubsampling & 0xFFFF;
        int sy = this.ySubsampling & 0xFFFF;
        assert (region.width % sx == 0 && region.height % sy == 0) : region;
        this.x = region.x / sx;
        this.y = region.y / sy;
        this.setSize(region.width / sx, region.height / sy);
    }

    void setSize(int dx, int dy) throws IllegalArgumentException {
        int value;
        String name;
        this.width = (short)dx;
        this.height = (short)dy;
        if ((this.width & 0xFFFF) != dx) {
            name = "width";
            value = dx;
        } else if ((this.height & 0xFFFF) != dy) {
            name = "height";
            value = dy;
        } else {
            return;
        }
        this.width = 0;
        this.height = 0;
        throw new IllegalArgumentException(Errors.format((int)201, (Object)(String.valueOf(name) + '=' + value), (Object)0, (Object)65535));
    }

    final void absoluteToRelative(Rectangle region) throws ArithmeticException {
        int sx = this.xSubsampling & 0xFFFF;
        int sy = this.ySubsampling & 0xFFFF;
        int xmin = region.x;
        int xmax = region.width + xmin;
        int ymin = region.y;
        int ymax = region.height + ymin;
        if (xmin < 0) {
            xmin -= sx - 1;
        }
        if (xmax > 0) {
            xmax += sx - 1;
        }
        if (ymin < 0) {
            ymin -= sy - 1;
        }
        if (ymax > 0) {
            ymax += sy - 1;
        }
        region.x = xmin /= sx;
        region.y = ymin /= sy;
        region.width = (xmax /= sx) - xmin;
        region.height = (ymax /= sy) - ymin;
    }

    final synchronized void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        this.gridToCRS = null;
    }

    final int countUnwantedPixelsFromAbsolute(Rectangle toRead, Dimension subsampling) throws IOException {
        int sx = this.xSubsampling & 0xFFFF;
        int sy = this.ySubsampling & 0xFFFF;
        assert (subsampling.width >= sx && subsampling.height >= sy) : subsampling;
        Rectangle region = this.getRegion();
        long xmin = Math.max((long)toRead.x, (long)sx * (long)region.x);
        long ymin = Math.max((long)toRead.y, (long)sy * (long)region.y);
        long xmax = Math.min((long)toRead.x + (long)toRead.width, (long)sx * ((long)region.x + (long)region.width));
        long ymax = Math.min((long)toRead.y + (long)toRead.height, (long)sy * ((long)region.y + (long)region.height));
        long count = Math.max(xmax - xmin, 0L) * Math.max(ymax - ymin, 0L);
        count /= (long)(subsampling.width * subsampling.height);
        count = (long)(region.width * region.height) - count;
        assert (count >= 0L && count <= Integer.MAX_VALUE) : count;
        return (int)count;
    }

    private static Object toComparable(Object input) {
        if (input instanceof URL) {
            try {
                input = ((URL)input).toURI();
            }
            catch (URISyntaxException exception) {
                Logging.recoverableException(Tile.class, (String)"compare", (Throwable)exception);
            }
        } else if (input instanceof CharSequence) {
            input = input.toString();
        }
        return input;
    }

    private static Object toCompatible(Object input, Object target) {
        if (target instanceof URI) {
            if (input instanceof File) {
                input = ((File)input).toURI();
            }
        } else if (target instanceof String && (input instanceof File || input instanceof URI)) {
            input = input.toString();
        }
        return input;
    }

    private static int compareInputs(Object input1, Object input2) {
        if (Utilities.equals((Object)input1, (Object)input2)) {
            return 0;
        }
        input1 = Tile.toComparable(input1);
        input2 = Tile.toComparable(input2);
        input1 = Tile.toCompatible(input1, input2);
        input2 = Tile.toCompatible(input2, input1);
        if (input1 instanceof Comparable && input1.getClass().isInstance(input2)) {
            return ((Comparable)input1).compareTo(input2);
        }
        if (input2 instanceof Comparable && input2.getClass().isInstance(input1)) {
            return -((Comparable)input2).compareTo(input1);
        }
        int c = input1.getClass().getName().compareTo(input2.getClass().getName());
        if (c != 0) {
            return c;
        }
        return System.identityHashCode(input2) - System.identityHashCode(input1);
    }

    @Override
    public final int compareTo(Tile other) {
        int ox;
        int sx;
        int oy;
        int sy;
        int c = Tile.compareInputs(this.input, other.input);
        if (c == 0 && (c = (this.imageIndex & 0xFFFF) - (other.imageIndex & 0xFFFF)) == 0 && (c = (sy = this.ySubsampling & 0xFFFF) - (oy = other.ySubsampling & 0xFFFF)) == 0 && (c = (sx = this.xSubsampling & 0xFFFF) - (ox = other.xSubsampling & 0xFFFF)) == 0 && (c = this.y * sy - other.y * oy) == 0) {
            c = this.x * sx - other.x * ox;
        }
        return c;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            Tile that = (Tile)object;
            if (this.x == that.x && this.y == that.y && this.xSubsampling == that.xSubsampling && this.ySubsampling == that.ySubsampling && this.imageIndex == that.imageIndex && Utilities.equals((Object)this.provider, (Object)that.provider) && Utilities.deepEquals((Object)this.input, (Object)that.input)) {
                return !(this.width != 0 && that.width != 0 && this.width != that.width || this.height != 0 && that.height != 0 && this.height != that.height);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.provider.hashCode() + Utilities.deepHashCode((Object)this.input) + 37 * this.imageIndex;
    }

    static String toString(ImageReaderSpi provider) {
        String[] formats;
        String name = null;
        if (provider != null && (formats = provider.getFormatNames()) != null) {
            int length = 0;
            int i = 0;
            while (i < formats.length) {
                int lg;
                String candidate = formats[i];
                if (candidate != null && (lg = candidate.length()) > length) {
                    length = lg;
                    name = candidate;
                }
                ++i;
            }
        }
        return name;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)this)).append('[');
        buffer.append("format=\"").append(this.getFormatName()).append("\", input=\"").append(this.getInputName()).append("\", index=").append(this.getImageIndex());
        if (this.xSubsampling != 0 || this.ySubsampling != 0) {
            buffer.append(", location=(");
            if (this.width == 0 && this.height == 0) {
                Point location = this.getLocation();
                buffer.append(location.x).append(',').append(location.y);
            } else {
                try {
                    Rectangle region = this.getRegion();
                    buffer.append(region.x).append(',').append(region.y).append("), size=(").append(region.width).append(',').append(region.height);
                }
                catch (IOException e) {
                    buffer.append(e);
                }
            }
            Dimension subsampling = this.getSubsampling();
            buffer.append("), subsampling=(").append(subsampling.width).append(',').append(subsampling.height).append(')');
        } else if ((this.width != 0 || this.height != 0) && this.getClass().equals(Tile.class)) {
            buffer.append(", size=(").append(this.width & 0xFFFF).append(',').append(this.height & 0xFFFF).append(')');
        }
        return buffer.append(']').toString();
    }

    static String toString(Collection<Tile> tiles, int maximum) {
        StringWriter writer = new StringWriter();
        try {
            Tile.writeTable(tiles, writer, maximum);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return writer.toString();
    }

    public static void writeTable(Collection<Tile> tiles, Writer out, int maximum) throws IOException {
        int remaining = maximum;
        TableWriter table = new TableWriter(out);
        table.nextLine('\u2550');
        table.write("Format\tInput\tindex\tx\ty\twidth\theight\tdx\tdy\n");
        table.nextLine('\u2500');
        table.setMultiLinesCells(true);
        for (Tile tile : tiles) {
            if (--remaining < 0) break;
            table.setAlignment(0);
            String format = tile.getFormatName();
            if (format != null) {
                table.write(format);
            }
            table.nextColumn();
            table.write(tile.getInputName());
            table.nextColumn();
            table.setAlignment(2);
            table.write(String.valueOf(tile.getImageIndex()));
            table.nextColumn();
            int x = tile.x;
            int y = tile.y;
            int width = tile.width & 0xFFFF;
            int height = tile.height & 0xFFFF;
            int xSubsampling = tile.xSubsampling & 0xFFFF;
            int ySubsampling = tile.ySubsampling & 0xFFFF;
            if (!tile.getClass().equals(Tile.class)) {
                Dimension subsampling = tile.getSubsampling();
                xSubsampling = subsampling.width;
                ySubsampling = subsampling.height;
                try {
                    Rectangle region = tile.getRegion();
                    x = region.x;
                    y = region.y;
                    width = region.width;
                    height = region.height;
                }
                catch (IOException e) {
                    width = 0;
                    height = 0;
                }
            }
            table.write(String.valueOf(x));
            table.nextColumn();
            table.write(String.valueOf(y));
            if (width != 0 || height != 0) {
                table.nextColumn();
                table.write(String.valueOf(width));
                table.nextColumn();
                table.write(String.valueOf(height));
            } else {
                table.nextColumn();
                table.nextColumn();
            }
            if (xSubsampling != 0 || ySubsampling != 0) {
                table.nextColumn();
                table.write(String.valueOf(xSubsampling));
                table.nextColumn();
                table.write(String.valueOf(ySubsampling));
            }
            table.nextLine();
        }
        table.nextLine('\u2550');
        table.flush();
        if (remaining < 0) {
            out.write(Vocabulary.format((int)144, (Object)(tiles.size() - maximum)));
            out.write(System.getProperty("line.separator", "\n"));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(Classes.getClass((Object)this.provider));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object candidate = in.readObject();
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Class type = candidate.getClass();
        try {
            type = (Class)candidate;
            this.provider = (ImageReaderSpi)registry.getServiceProviderByClass(type);
        }
        catch (ClassCastException cause) {
            InvalidClassException e = new InvalidClassException(type.getName(), Errors.format((int)61, (Object)type, ImageReaderSpi.class));
            e.initCause(cause);
            throw e;
        }
        if (this.provider == null) {
            throw new ClassNotFoundException(type.getName());
        }
    }
}

