/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.imageio.spi.ImageReaderSpi;
import javax.swing.tree.TreeNode;
import org.geotools.image.io.mosaic.GridNode;
import org.geotools.image.io.mosaic.RTree;
import org.geotools.image.io.mosaic.ReaderInputPair;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TileManager;
import org.geotools.resources.OptionalDependencies;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.util.Comparators;
import org.geotools.util.FrequencySortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TreeTileManager
extends TileManager {
    private static final long serialVersionUID = -6070623930537957163L;
    private static final int CONCURRENT_THREADS = 4;
    private final Tile[] tiles;
    private transient Collection<Tile> allTiles;
    private transient RTree[] trees;
    private transient Rectangle region;
    private transient Dimension tileSize;

    protected TreeTileManager(Tile[] tiles) {
        Tile.ensureNonNull("tiles", tiles);
        LinkedHashMap<ReaderInputPair, ArrayList<Tile>> tilesByInput = new LinkedHashMap<ReaderInputPair, ArrayList<Tile>>(tiles.length + tiles.length / 4 + 1);
        this.providers = new FrequencySortedSet(4, true);
        Tile[] tileArray = tiles;
        int n = tiles.length;
        int n2 = 0;
        while (n2 < n) {
            Tile tile = tileArray[n2];
            tile.checkGeometryValidity();
            ImageReaderSpi spi = tile.getImageReaderSpi();
            ReaderInputPair key = new ReaderInputPair(spi, tile.getInput());
            ArrayList<Tile> sameInputs = (ArrayList<Tile>)tilesByInput.get(key);
            if (sameInputs == null) {
                sameInputs = new ArrayList<Tile>(1);
                tilesByInput.put(key, sameInputs);
                this.providers.add(spi);
            }
            sameInputs.add(tile);
            ++n2;
        }
        this.providers = Collections.unmodifiableSet(this.providers);
        List[] asArray = tilesByInput.values().toArray(new List[tilesByInput.size()]);
        Comparator comparator = Comparators.forLists();
        Arrays.sort(asArray, comparator);
        int numTiles = 0;
        List[] listArray = asArray;
        int n3 = asArray.length;
        int n4 = 0;
        while (n4 < n3) {
            List sameInputs = listArray[n4];
            switch (sameInputs.size()) {
                case 0: {
                    throw new AssertionError();
                }
                case 1: {
                    break;
                }
                default: {
                    Collections.sort(sameInputs);
                }
            }
            for (Tile tile : sameInputs) {
                tiles[numTiles++] = tile;
            }
            ++n4;
        }
        this.tiles = tiles;
        this.allTiles = UnmodifiableArrayList.wrap((Object[])tiles);
    }

    @Override
    final synchronized Rectangle getRegion() throws IOException {
        if (this.region == null) {
            RTree tree = this.getTree();
            try {
                this.region = tree.getBounds();
            }
            finally {
                this.release(tree);
            }
        }
        return this.region;
    }

    @Override
    final synchronized Dimension getTileSize() throws IOException {
        if (this.tileSize == null) {
            RTree tree = this.getTree();
            try {
                this.tileSize = tree.getTileSize();
            }
            finally {
                this.release(tree);
            }
        }
        return this.tileSize;
    }

    @Override
    final boolean isImageTiled() throws IOException {
        return this.tiles.length >= 2;
    }

    private synchronized RTree getTree() throws IOException {
        RTree tree;
        if (this.trees == null) {
            GridNode root = new GridNode(this.tiles);
            tree = new RTree(root);
            RTree[] trees = new RTree[4];
            trees[0] = tree;
            assert (root.containsAll(this.allTiles));
            this.trees = trees;
        }
        int i = 0;
        while (i < this.trees.length) {
            block8: {
                block7: {
                    block6: {
                        tree = this.trees[i];
                        if (tree != null) break block6;
                        this.trees[i] = tree = this.trees[0].clone();
                        break block7;
                    }
                    if (tree.inUse) break block8;
                }
                tree.inUse = true;
                return tree;
            }
            ++i;
        }
        return this.trees[0].clone();
    }

    private synchronized void release(RTree tree) {
        if (tree != null) {
            tree.inUse = false;
        }
    }

    @Override
    public Set<ImageReaderSpi> getImageReaderSpis() throws IOException {
        return this.providers;
    }

    @Override
    public Collection<Tile> getTiles() {
        return this.allTiles;
    }

    @Override
    public Collection<Tile> getTiles(Rectangle region, Dimension subsampling, boolean subsamplingChangeAllowed) throws IOException {
        List<Tile> values;
        RTree tree = this.getTree();
        try {
            tree.regionOfInterest = region;
            tree.subsampling = subsampling;
            tree.subsamplingChangeAllowed = subsamplingChangeAllowed;
            values = tree.searchTiles();
        }
        finally {
            tree.regionOfInterest = null;
            tree.subsampling = null;
            this.release(tree);
        }
        return values;
    }

    @Override
    public boolean intersects(Rectangle region, Dimension subsampling) throws IOException {
        boolean intersects;
        RTree tree = this.getTree();
        try {
            tree.regionOfInterest = region;
            tree.subsampling = subsampling;
            intersects = tree.intersects();
        }
        finally {
            tree.regionOfInterest = null;
            tree.subsampling = null;
            this.release(tree);
        }
        return intersects;
    }

    public int hashCode() {
        return 0xDF4CA8D5 ^ Arrays.hashCode(this.tiles);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            TreeTileManager that = (TreeTileManager)object;
            return Arrays.equals(this.tiles, that.tiles);
        }
        return false;
    }

    @Override
    public String toString() {
        String string;
        RTree tree;
        try {
            tree = this.getTree();
        }
        catch (IOException e) {
            return super.toString();
        }
        try {
            string = OptionalDependencies.toString((TreeNode)tree.root);
        }
        finally {
            this.release(tree);
        }
        return string;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.allTiles = UnmodifiableArrayList.wrap((Object[])this.tiles);
        this.providers = new FrequencySortedSet(4, true);
        Tile[] tileArray = this.tiles;
        int n = this.tiles.length;
        int n2 = 0;
        while (n2 < n) {
            Tile tile = tileArray[n2];
            this.providers.add(tile.getImageReaderSpi());
            ++n2;
        }
        this.providers = Collections.unmodifiableSet(this.providers);
    }
}

