/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.geotools.image.io.stream.FinalizationStopper;
import org.geotools.util.logging.Logging;

public class UrlInputSpi
extends ImageInputStreamSpi {
    private static final int RETRY = 3;
    private final Proxy proxy;

    public UrlInputSpi() {
        this(Proxy.NO_PROXY);
    }

    public UrlInputSpi(Proxy proxy) {
        super("Geotools", "2.5", URL.class);
        this.proxy = proxy;
    }

    public String getDescription(Locale locale) {
        return "Stream from a URL.";
    }

    public boolean needsCacheFile() {
        return true;
    }

    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) throws IOException {
        InputStream stream;
        URL url = (URL)input;
        URLConnection connection = url.openConnection();
        int retry = 3;
        while (true) {
            try {
                stream = connection.getInputStream();
            }
            catch (SocketException exception2) {
                if (--retry < 0) {
                    throw exception2;
                }
                Logging.getLogger(UrlInputSpi.class).warning(exception2.toString());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exception2) {
                    // empty catch block
                }
                System.gc();
                Thread.interrupted();
                FinalizationStopper stopper = new FinalizationStopper(4000L);
                System.runFinalization();
                stopper.cancel();
                if (!Thread.interrupted() && !stopper.interrupted) continue;
                Logging.getLogger(UrlInputSpi.class).warning("System.runFinalization() was blocked.");
                continue;
            }
            break;
        }
        return new FileCacheImageInputStream(stream, cacheDir);
    }
}

