/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.data.DataUtilities;
import org.geotools.image.io.StreamImageReader;
import org.geotools.image.io.text.LineReader;
import org.geotools.image.io.text.TestReader;
import org.geotools.io.LineFormat;
import org.geotools.resources.i18n.Vocabulary;

public abstract class TextImageReader
extends StreamImageReader {
    private BufferedReader reader;

    protected TextImageReader(ImageReaderSpi provider) {
        super(provider);
    }

    protected Charset getCharset(InputStream input) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).charset : null;
    }

    protected LineFormat getLineFormat(int imageIndex) throws IOException {
        Locale locale;
        if (this.originatingProvider instanceof Spi && (locale = ((Spi)this.originatingProvider).locale) != null) {
            return new LineFormat(locale);
        }
        return new LineFormat();
    }

    protected double getPadValue(int imageIndex) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).padValue : Double.NaN;
    }

    protected BufferedReader getReader() throws IllegalStateException, IOException {
        if (this.reader == null) {
            Object input = this.getInput();
            if (input instanceof BufferedReader) {
                this.reader = (BufferedReader)input;
                this.closeOnReset = null;
            } else if (input instanceof Reader) {
                this.reader = new LineReader((Reader)input);
                this.closeOnReset = null;
            } else {
                InputStream stream = this.getInputStream();
                this.reader = new LineReader(this.getInputStreamReader(stream));
                if (this.closeOnReset == stream) {
                    this.closeOnReset = this.reader;
                }
            }
        }
        return this.reader;
    }

    final Reader getInputStreamReader(InputStream stream) throws IOException {
        Charset charset = this.getCharset(stream);
        return charset != null ? new InputStreamReader(stream, charset) : new InputStreamReader(stream);
    }

    protected boolean isComment(String line) {
        int length = line.length();
        int i = 0;
        while (i < length) {
            char c = line.charAt(i);
            if (!Character.isSpaceChar(c)) {
                return c == '#';
            }
            ++i;
        }
        return true;
    }

    final long getStreamLength(int fromImage, int toImage) throws IOException {
        int numImages;
        long length = this.getStreamLength();
        if (length > 0L && (numImages = this.getNumImages(false)) > 0) {
            if (toImage == -1) {
                toImage = numImages;
            }
            if (fromImage < 0 || fromImage > numImages) {
                throw new IndexOutOfBoundsException(String.valueOf(fromImage));
            }
            if (toImage < 0 || toImage > numImages) {
                throw new IndexOutOfBoundsException(String.valueOf(toImage));
            }
            if (fromImage > toImage) {
                throw new IllegalArgumentException();
            }
            return length * (long)(toImage - fromImage) / (long)numImages;
        }
        return length;
    }

    static long getStreamPosition(Reader reader) throws IOException {
        return reader instanceof LineReader ? ((LineReader)reader).getPosition() : -1L;
    }

    protected String getPositionString(String message) {
        Object input = this.getInput();
        String file = input instanceof File ? ((File)input).getName() : (input instanceof URL ? DataUtilities.urlToFile((URL)((URL)input)).getPath() : null);
        Integer line = this.reader instanceof LineNumberReader ? Integer.valueOf(((LineNumberReader)this.reader).getLineNumber()) : null;
        Vocabulary resources = Vocabulary.getResources(null);
        String position = file != null ? (line != null ? resources.getString(72, (Object)file, (Object)line) : resources.getString(71, (Object)file)) : (line != null ? resources.getString(125, (Object)line) : null);
        if (position != null) {
            if (message != null) {
                return String.valueOf(position) + ": " + message;
            }
            return position;
        }
        return message;
    }

    protected void close() throws IOException {
        this.reader = null;
        super.close();
    }

    public static abstract class Spi
    extends StreamImageReader.Spi {
        private static final Class[] INPUT_TYPES = new Class[]{File.class, URL.class, URLConnection.class, Reader.class, InputStream.class, ImageInputStream.class, String.class};
        private static final String[] EXTENSIONS = new String[]{"txt", "TXT", "asc", "ASC", "dat", "DAT"};
        protected Charset charset;
        protected Locale locale;
        protected double padValue;

        public Spi() {
            this.inputTypes = INPUT_TYPES;
            this.suffixes = EXTENSIONS;
            this.padValue = Double.NaN;
        }

        public boolean canDecodeInput(Object source) throws IOException {
            return this.canDecodeInput(source, 1024);
        }

        protected boolean canDecodeInput(Object source, int readAheadLimit) throws IOException {
            TestReader test = new TestReader(this);
            test.setInput(source);
            boolean result = test.canDecode(readAheadLimit);
            test.close();
            return result;
        }

        protected boolean isValidContent(double[][] rows) {
            if (rows.length == 0) {
                return false;
            }
            int length = rows[0].length;
            int i = 1;
            while (i < rows.length) {
                if (rows[i].length != length) {
                    return false;
                }
                ++i;
            }
            return this.isValidColumnCount(length);
        }

        boolean isValidColumnCount(int count) {
            return true;
        }
    }
}

