/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.text;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.factory.GeoTools;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.text.TextImageReader;
import org.geotools.io.LineFormat;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Descriptions;

public class TextMatrixImageReader
extends TextImageReader {
    private float[] data;
    private int width;
    private int height;
    private int expectedHeight;
    private boolean completed;

    protected TextMatrixImageReader(ImageReaderSpi provider) {
        super(provider);
    }

    private boolean load(int imageIndex, boolean all) throws IOException {
        String line;
        this.clearAbortRequest();
        if (all) {
            this.processImageStarted(imageIndex);
        }
        float[] values = this.data != null ? new float[this.width] : null;
        int offset = this.width * this.height;
        BufferedReader input = this.getReader();
        LineFormat format = this.getLineFormat(imageIndex);
        float padValue = (float)this.getPadValue(imageIndex);
        while ((line = input.readLine()) != null) {
            int newOffset;
            if (this.isComment(line)) continue;
            try {
                format.setLine(line);
                values = format.getValues(values);
                int i = values.length;
                while (--i >= 0) {
                    if (values[i] != padValue) continue;
                    values[i] = Float.NaN;
                }
            }
            catch (ParseException exception) {
                throw new IIOException(this.getPositionString(exception.getLocalizedMessage()), exception);
            }
            if (this.data == null) {
                this.data = new float[1024];
            }
            if ((newOffset = offset + (this.width = values.length)) > this.data.length) {
                this.data = XArray.resize((float[])this.data, (int)(newOffset + Math.min(newOffset, 65536)));
            }
            System.arraycopy(values, 0, this.data, offset, this.width);
            offset = newOffset;
            ++this.height;
            if (!all) {
                long streamLength = this.getStreamLength(imageIndex, imageIndex + 1);
                if (streamLength < 0L) break;
                this.expectedHeight = (int)(streamLength / (long)(line.length() + 1));
                break;
            }
            if (this.height > this.expectedHeight) continue;
            this.processImageProgress((float)this.height * 100.0f / (float)this.expectedHeight);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            return true;
        }
        if (this.completed = all) {
            this.data = XArray.resize((float[])this.data, (int)offset);
            this.expectedHeight = this.height;
        }
        if (all) {
            this.processImageComplete();
        }
        return false;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.data == null) {
            this.load(imageIndex, false);
        }
        return this.width;
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.data == null || !this.completed) {
            this.load(imageIndex, true);
        }
        return this.height;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (!this.ignoreMetadata) {
            if (this.data == null || !this.completed) {
                this.load(imageIndex, true);
            }
            float minimum = Float.POSITIVE_INFINITY;
            float maximum = Float.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.data.length) {
                float value = this.data[i];
                if (value < minimum) {
                    minimum = value;
                }
                if (value > maximum) {
                    maximum = value;
                }
                ++i;
            }
            if (minimum < maximum) {
                GeographicMetadata metadata = new GeographicMetadata(this);
                metadata.getBand(0).setValidRange(minimum, maximum);
                return metadata;
            }
        }
        return null;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        boolean isDirect;
        int destinationYOffset;
        int destinationXOffset;
        int subsamplingYOffset;
        int subsamplingXOffset;
        int sourceYSubsampling;
        int sourceXSubsampling;
        int[] destinationBands;
        int[] sourceBands;
        boolean numSrcBands = true;
        boolean numDstBands = true;
        this.checkImageIndex(imageIndex);
        TextMatrixImageReader.checkReadParamBandSettings(param, 1, 1);
        if (param != null) {
            sourceBands = param.getSourceBands();
            destinationBands = param.getDestinationBands();
            Point offset = param.getDestinationOffset();
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            subsamplingXOffset = param.getSubsamplingXOffset();
            subsamplingYOffset = param.getSubsamplingYOffset();
            destinationXOffset = offset.x;
            destinationYOffset = offset.y;
        } else {
            sourceBands = null;
            destinationBands = null;
            sourceXSubsampling = 1;
            sourceYSubsampling = 1;
            subsamplingXOffset = 0;
            subsamplingYOffset = 0;
            destinationXOffset = 0;
            destinationYOffset = 0;
        }
        Rectangle srcRegion = TextMatrixImageReader.getSourceRegion(param, this.width, this.height);
        boolean bl = isDirect = sourceXSubsampling == 1 && sourceYSubsampling == 1 && subsamplingXOffset == 0 && subsamplingYOffset == 0 && destinationXOffset == 0 && destinationYOffset == 0 && srcRegion.x == 0 && srcRegion.width == this.width && srcRegion.y == 0 && srcRegion.height == this.height;
        if ((this.data == null || !this.completed) && this.load(imageIndex, true)) {
            return null;
        }
        if (isDirect && (param == null || param.getDestination() == null)) {
            ImageTypeSpecifier type = this.getRawImageType(imageIndex, param, null);
            SampleModel model = type.getSampleModel().createCompatibleSampleModel(this.width, this.height);
            DataBufferFloat buffer = new DataBufferFloat(this.data, this.data.length);
            WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
            return new BufferedImage(type.getColorModel(), raster, false, null);
        }
        boolean dstBand = false;
        BufferedImage image = this.getDestination(imageIndex, param, this.width, this.height, null);
        WritableRaster dstRaster = image.getRaster();
        Rectangle dstRegion = new Rectangle();
        TextMatrixImageReader.computeRegions(param, this.width, this.height, image, srcRegion, dstRegion);
        int dstXMin = dstRegion.x;
        int dstYMin = dstRegion.y;
        int dstXMax = dstRegion.width + dstXMin;
        int dstYMax = dstRegion.height + dstYMin;
        int srcY = srcRegion.y;
        int y = dstYMin;
        while (y < dstYMax) {
            assert (srcY < srcRegion.y + srcRegion.height);
            int srcX = srcRegion.x;
            int x = dstXMin;
            while (x < dstXMax) {
                assert (srcX < srcRegion.x + srcRegion.width);
                float value = this.data[srcY * this.width + srcX];
                dstRaster.setSample(x, y, 0, value);
                srcX += sourceXSubsampling;
                ++x;
            }
            srcY += sourceYSubsampling;
            ++y;
        }
        return image;
    }

    public void close() throws IOException {
        this.completed = false;
        this.data = null;
        this.width = 0;
        this.height = 0;
        this.expectedHeight = 0;
        super.close();
    }

    public static class Spi
    extends TextImageReader.Spi {
        static final String[] NAMES = new String[]{"matrix"};
        static final String[] MIME_TYPES = new String[]{"application/matrix", "text/plain"};

        public Spi() {
            this.names = NAMES;
            this.MIMETypes = MIME_TYPES;
            this.pluginClassName = "org.geotools.image.io.text.TextMatrixImageReader";
            this.vendorName = "GeoTools";
            this.version = GeoTools.getVersion().toString();
        }

        public String getDescription(Locale locale) {
            return Descriptions.getResources((Locale)locale).getString(1);
        }

        public ImageReader createReaderInstance(Object extension) throws IOException {
            return new TextMatrixImageReader(this);
        }

        boolean isValidColumnCount(int count) {
            return count > 10;
        }
    }
}

