/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.text;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.factory.GeoTools;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.ImageGeometry;
import org.geotools.image.io.text.RecordList;
import org.geotools.image.io.text.TextImageReader;
import org.geotools.io.LineFormat;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Descriptions;
import org.geotools.resources.i18n.Errors;

public class TextRecordImageReader
extends TextImageReader {
    private static final float EPS = 1.0E-5f;
    private static final int PROGRESS_INTERVAL = 4096;
    private static final boolean CLEAR = true;
    private RecordList[] data;
    private int nextImageIndex;
    private float expectedDatumLength = 10.4f;

    public TextRecordImageReader(ImageReaderSpi provider) {
        super(provider);
    }

    private float getGridTolerance() {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).gridTolerance : 1.0E-5f;
    }

    protected int getColumnX(int imageIndex) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).xColumn : 0;
    }

    private int getCheckedColumnX(int imageIndex) throws IOException {
        int xColumn = this.getColumnX(imageIndex);
        if (xColumn < 0) {
            throw new IllegalStateException(Errors.format((int)103, (Object)"x", (Object)xColumn));
        }
        return xColumn;
    }

    protected int getColumnY(int imageIndex) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).yColumn : 1;
    }

    private int getCheckedColumnY(int imageIndex) throws IOException {
        int yColumn = this.getColumnY(imageIndex);
        if (yColumn < 0) {
            throw new IllegalStateException(Errors.format((int)103, (Object)"y", (Object)yColumn));
        }
        return yColumn;
    }

    private int getColumn(int imageIndex, int band) throws IOException {
        int yColumn;
        int xColumn = this.getCheckedColumnX(imageIndex);
        if (band >= Math.min(xColumn, yColumn = this.getCheckedColumnY(imageIndex))) {
            ++band;
        }
        if (band >= Math.max(xColumn, yColumn)) {
            ++band;
        }
        return band;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.clear();
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    public int getNumBands(int imageIndex) throws IOException {
        return this.getRecords(imageIndex).getColumnCount() - (this.getCheckedColumnX(imageIndex) == this.getCheckedColumnY(imageIndex) ? 1 : 2);
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.getRecords(imageIndex).getPointCount(this.getCheckedColumnX(imageIndex), this.getGridTolerance());
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.getRecords(imageIndex).getPointCount(this.getCheckedColumnY(imageIndex), this.getGridTolerance());
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.ignoreMetadata) {
            return null;
        }
        GeographicMetadata metadata = new GeographicMetadata(this);
        ImageGeometry geometry = metadata.getGeometry();
        float tolerance = this.getGridTolerance();
        RecordList records = this.getRecords(imageIndex);
        int xColumn = this.getCheckedColumnX(imageIndex);
        int yColumn = this.getCheckedColumnY(imageIndex);
        int width = records.getPointCount(xColumn, tolerance);
        int height = records.getPointCount(yColumn, tolerance);
        double xmin = records.getMinimum(xColumn);
        double ymin = records.getMinimum(yColumn);
        double xmax = records.getMaximum(xColumn);
        double ymax = records.getMaximum(yColumn);
        geometry.setOrdinateRange(0, xmin, xmax);
        geometry.setGridRange(0, 0, width - 1);
        geometry.setOrdinateRange(1, ymin, ymax);
        geometry.setGridRange(1, 0, height - 1);
        geometry.setPixelOrientation("center");
        int numBands = records.getColumnCount() - (xColumn == yColumn ? 1 : 2);
        int band = 0;
        while (band < numBands) {
            int column = this.getColumn(imageIndex, band);
            metadata.getBand(band).setValidRange(records.getMinimum(column), records.getMaximum(column));
            ++band;
        }
        return metadata;
    }

    protected void round(double[] values) {
    }

    private RecordList getRecords(int imageIndex) throws IOException {
        RecordList records;
        this.clearAbortRequest();
        this.checkImageIndex(imageIndex);
        if (imageIndex >= this.nextImageIndex) {
            this.processImageStarted(imageIndex);
            BufferedReader reader = this.getReader();
            long origine = TextRecordImageReader.getStreamPosition(reader);
            long length = this.getStreamLength(this.nextImageIndex, imageIndex + 1);
            long nextProgressPosition = origine >= 0L && length > 0L ? 0L : Long.MAX_VALUE;
            while (this.nextImageIndex <= imageIndex) {
                RecordList records2;
                if (this.seekForwardOnly) {
                    this.minIndex = this.nextImageIndex;
                }
                if (this.nextImageIndex != 0 && this.data != null && (records2 = this.data[this.nextImageIndex - 1]) != null) {
                    if (this.seekForwardOnly) {
                        this.data[this.nextImageIndex - 1] = null;
                    } else {
                        records2.trimToSize();
                    }
                }
                double[] values = null;
                RecordList records3 = null;
                boolean keep = this.nextImageIndex == imageIndex || !this.seekForwardOnly;
                int xColumn = this.getCheckedColumnX(this.nextImageIndex);
                int yColumn = this.getCheckedColumnY(this.nextImageIndex);
                double padValue = this.getPadValue(this.nextImageIndex);
                LineFormat lineFormat = this.getLineFormat(this.nextImageIndex);
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        long position;
                        if (this.isComment(line) || lineFormat.setLine(line) == 0) continue;
                        values = lineFormat.getValues(values);
                        int i = 0;
                        while (i < values.length) {
                            if (i != xColumn && i != yColumn && values[i] == padValue) {
                                values[i] = Double.NaN;
                            }
                            ++i;
                        }
                        this.round(values);
                        if (keep) {
                            if (records3 == null) {
                                int expectedLineCount = Math.max(8, Math.min(65536, Math.round((float)length / (this.expectedDatumLength * (float)values.length))));
                                records3 = new RecordList(values.length, expectedLineCount);
                            }
                            records3.add(values);
                        }
                        if ((position = TextRecordImageReader.getStreamPosition(reader) - origine) < nextProgressPosition) continue;
                        this.processImageProgress((float)position * (100.0f / (float)length));
                        nextProgressPosition = position + 4096L;
                        if (!this.abortRequested()) continue;
                        this.processReadAborted();
                        return records3;
                    }
                }
                catch (ParseException exception) {
                    throw new IIOException(this.getPositionString(exception.getLocalizedMessage()), exception);
                }
                if (records3 != null) {
                    int lineCount = records3.getLineCount();
                    if (lineCount < 2) {
                        throw new IIOException(this.getPositionString(Errors.format((int)51)));
                    }
                    if (this.data == null) {
                        this.data = new RecordList[imageIndex + 1];
                    } else if (this.data.length <= imageIndex) {
                        this.data = (RecordList[])XArray.resize((Object[])this.data, (int)(imageIndex + 1));
                    }
                    this.data[this.nextImageIndex] = records3;
                    float meanDatumLength = (float)(TextRecordImageReader.getStreamPosition(reader) - origine) / (float)records3.getDataCount();
                    if (meanDatumLength > 0.0f) {
                        this.expectedDatumLength = meanDatumLength;
                    }
                }
                ++this.nextImageIndex;
            }
            this.processImageComplete();
        }
        if (this.data != null && imageIndex < this.data.length && (records = this.data[imageIndex]) != null) {
            return records;
        }
        throw new IndexOutOfBoundsException(String.valueOf(imageIndex));
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int destinationYOffset;
        int destinationXOffset;
        int subsamplingYOffset;
        int subsamplingXOffset;
        int sourceYSubsampling;
        int sourceXSubsampling;
        int[] dstBands;
        int[] srcBands;
        float tolerance = this.getGridTolerance();
        int xColumn = this.getCheckedColumnX(imageIndex);
        int yColumn = this.getCheckedColumnY(imageIndex);
        RecordList records = this.getRecords(imageIndex);
        int width = records.getPointCount(xColumn, tolerance);
        int height = records.getPointCount(yColumn, tolerance);
        int numSrcBands = records.getColumnCount() - (xColumn == yColumn ? 1 : 2);
        if (param != null) {
            srcBands = param.getSourceBands();
            dstBands = param.getDestinationBands();
            Point offset = param.getDestinationOffset();
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            subsamplingXOffset = param.getSubsamplingXOffset();
            subsamplingYOffset = param.getSubsamplingYOffset();
            destinationXOffset = offset.x;
            destinationYOffset = offset.y;
        } else {
            srcBands = null;
            dstBands = null;
            sourceXSubsampling = 1;
            sourceYSubsampling = 1;
            subsamplingXOffset = 0;
            subsamplingYOffset = 0;
            destinationXOffset = 0;
            destinationYOffset = 0;
        }
        int numDstBands = dstBands != null ? dstBands.length : (srcBands != null ? srcBands.length : numSrcBands);
        BufferedImage image = this.getDestination(imageIndex, param, width, height, null);
        TextRecordImageReader.checkReadParamBandSettings(param, numSrcBands, image.getSampleModel().getNumBands());
        Rectangle srcRegion = new Rectangle();
        Rectangle dstRegion = new Rectangle();
        TextRecordImageReader.computeRegions(param, width, height, image, srcRegion, dstRegion);
        int sourceXMin = srcRegion.x;
        int sourceYMin = srcRegion.y;
        int sourceXMax = srcRegion.width + sourceXMin;
        int sourceYMax = srcRegion.height + sourceYMin;
        WritableRaster raster = image.getRaster();
        int rasterWidth = raster.getWidth();
        int rasterHeigth = raster.getHeight();
        int columnCount = records.getColumnCount();
        int dataCount = records.getDataCount();
        float[] data = records.getData();
        double xmin = records.getMinimum(xColumn);
        double ymin = records.getMinimum(yColumn);
        double xmax = records.getMaximum(xColumn);
        double ymax = records.getMaximum(yColumn);
        double scaleX = (double)(width - 1) / (xmax - xmin);
        double scaleY = (double)(height - 1) / (ymax - ymin);
        int minX = dstRegion.x;
        int minY = dstRegion.y;
        int maxX = dstRegion.width + minX;
        int maxY = dstRegion.height + minY;
        int b = dstBands != null ? dstBands.length : numDstBands;
        while (--b >= 0) {
            int band = dstBands != null ? dstBands[b] : b;
            int y = minY;
            while (y < maxY) {
                int x = minX;
                while (x < maxX) {
                    raster.setSample(x, y, band, Float.NaN);
                    ++x;
                }
                ++y;
            }
        }
        int[] columns = new int[srcBands != null ? srcBands.length : numDstBands];
        int i = 0;
        while (i < columns.length) {
            columns[i] = this.getColumn(imageIndex, srcBands != null ? srcBands[i] : i);
            ++i;
        }
        i = 0;
        while (i < dataCount) {
            double fx = ((double)data[i + xColumn] - xmin) * scaleX;
            double fy = (ymax - (double)data[i + yColumn]) * scaleY;
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (!(Math.abs((double)x - fx) <= (double)tolerance)) {
                this.fireBadCoordinate(data[i + xColumn]);
            } else if (!(Math.abs((double)y - fy) <= (double)tolerance)) {
                this.fireBadCoordinate(data[i + yColumn]);
            } else if (x >= sourceXMin && x < sourceXMax && y >= sourceYMin && y < sourceYMax && (x -= subsamplingXOffset) % sourceXSubsampling == 0 && (y -= subsamplingYOffset) % sourceYSubsampling == 0) {
                x = x / sourceXSubsampling + (destinationXOffset - sourceXMin);
                y = y / sourceYSubsampling + (destinationYOffset - sourceYMin);
                if (x < rasterWidth && y < rasterHeigth) {
                    int j = 0;
                    while (j < columns.length) {
                        raster.setSample(x, y, dstBands != null ? dstBands[j] : j, data[i + columns[j]]);
                        ++j;
                    }
                }
            }
            i += columnCount;
        }
        return image;
    }

    private void fireBadCoordinate(float coordinate) {
        this.processWarningOccurred(this.getPositionString(Errors.format((int)0, (Object)Float.valueOf(coordinate))));
    }

    private void clear() {
        this.data = null;
        this.nextImageIndex = 0;
        this.expectedDatumLength = 10.4f;
    }

    public void reset() {
        this.clear();
        super.reset();
    }

    public static class Spi
    extends TextImageReader.Spi {
        private static final String[] NAMES = new String[]{"records"};
        private static final String[] MIME_TYPES = new String[]{"text/x-records"};
        protected int xColumn;
        protected int yColumn;
        protected float gridTolerance = 1.0E-5f;

        public Spi() {
            this.names = NAMES;
            this.MIMETypes = MIME_TYPES;
            this.pluginClassName = "org.geotools.image.io.text.TextRecordImageReader";
            this.vendorName = "GeoTools";
            this.version = GeoTools.getVersion().toString();
            this.xColumn = 0;
            this.yColumn = 1;
            this.gridTolerance = 1.0E-5f;
        }

        public String getDescription(Locale locale) {
            return Descriptions.getResources((Locale)locale).getString(0);
        }

        public ImageReader createReaderInstance(Object extension) throws IOException {
            return new TextRecordImageReader(this);
        }

        boolean isValidColumnCount(int count) {
            return count >= (this.xColumn == this.yColumn ? 2 : 3) && count <= 10;
        }
    }
}

