/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imageoverviews;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.apache.commons.io.filefilter.WildcardFilter;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.geotools.utils.CoverageToolsConstants;
import org.geotools.utils.WriteProgressListenerAdapter;
import org.geotools.utils.progress.BaseArgumentsManager;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;

public class OverviewsEmbedder
extends BaseArgumentsManager
implements Runnable,
ProcessingEventListener {
    private final OverviewsEmbedderWriteProgressListener writeProgressListener = new OverviewsEmbedderWriteProgressListener();
    private static Set<String> scalingAlgorithms = new HashSet<String>();
    private static final String NAME = "OverviewsEmbedder";
    private static final String VERSION = "0.3";
    private Option locationOpt;
    private Option tileDimOpt;
    private Option scaleAlgorithmOpt;
    private Option wildcardOpt;
    private Option numStepsOpt;
    private Option scaleFactorOpt;
    private Option compressionRatioOpt;
    private Option compressionTypeOpt;
    private int tileW = -1;
    private int tileH = -1;
    private String scaleAlgorithm;
    private static final Logger LOGGER;
    private BorderExtender borderExtender = CoverageToolsConstants.DEFAULT_BORDER_EXTENDER;
    private int downsampleStep;
    private float[] lowPassFilter = CoverageToolsConstants.DEFAULT_KERNEL_GAUSSIAN;
    private String sourcePath;
    private Interpolation interp = CoverageToolsConstants.DEFAULT_INTERPOLATION;
    private String compressionScheme = "LZW";
    private double compressionRatio = 0.75;
    private int numSteps;
    private String wildcardString = "*.*";
    private int fileBeingProcessed;
    private int overviewInProcess;

    public OverviewsEmbedder() {
        super(NAME, VERSION);
        this.locationOpt = this.optionBuilder.withShortName("s").withLongName("source").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Source can be a single file or  directory ");
                }
                File source = new File((String)args.get(0));
                if (!source.exists()) {
                    throw new InvalidArgumentException(new StringBuffer("The provided source is invalid! ").toString());
                }
            }
        }).create()).withDescription("path where files are located").withRequired(true).create();
        this.tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.argumentBuilder.withName("t").withMinimum(0).withMaximum(1).create()).withDescription("tile dimensions as a couple width,height in pixels").withRequired(false).create();
        this.scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.argumentBuilder.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scale factor at a time can be chosen");
                }
                int factor = Integer.parseInt((String)args.get(0));
                if (factor <= 0) {
                    throw new InvalidArgumentException(new StringBuffer("The provided scale factor is negative! ").toString());
                }
                if (factor == 1) {
                    LOGGER.warning("The scale factor is 1, program will exit!");
                    System.exit(0);
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.argumentBuilder.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
        this.numStepsOpt = this.optionBuilder.withShortName("n").withLongName("num_steps").withArgument(this.argumentBuilder.withName("n").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one  number of step at a time can be chosen");
                }
                int steps = Integer.parseInt((String)args.get(0));
                if (steps <= 0) {
                    throw new InvalidArgumentException(new StringBuffer("The provided number of step is negative! ").toString());
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.argumentBuilder.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                if (!scalingAlgorithms.contains(args.get(0))) {
                    throw new InvalidArgumentException(new StringBuffer("The scaling algorithm ").append(args.get(0)).append(" is not permitted").toString());
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered\t (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.compressionTypeOpt = this.optionBuilder.withShortName("z").withLongName("compressionType").withDescription("compression type.").withArgument(this.argumentBuilder.withName("compressionType").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
            }
        }).create()).withRequired(false).create();
        this.compressionRatioOpt = this.optionBuilder.withShortName("r").withLongName("compressionRatio").withDescription("compression ratio.").withArgument(this.argumentBuilder.withName("compressionRatio").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                String val = (String)args.get(0);
                double value = Double.parseDouble(val);
                if (value <= 0.0 || value > 1.0) {
                    throw new InvalidArgumentException("Invalid compressio ratio");
                }
            }
        }).create()).withRequired(false).create();
        this.addOption(this.locationOpt);
        this.addOption(this.tileDimOpt);
        this.addOption(this.scaleFactorOpt);
        this.addOption(this.scaleAlgorithmOpt);
        this.addOption(this.numStepsOpt);
        this.addOption(this.wildcardOpt);
        this.addOption(this.compressionTypeOpt);
        this.addOption(this.compressionRatioOpt);
        this.finishInitialization();
    }

    private ImageLayout tile(int tileWidth, int tileHeight, int tileGrdiOffseX, int tileGrdiOffseY, Interpolation interp) {
        ImageLayout layout = new ImageLayout();
        layout.setTileGridXOffset(tileGrdiOffseX);
        layout.setTileGridYOffset(tileGrdiOffseY);
        layout.setValid(16);
        layout.setValid(32);
        layout.setTileWidth(tileWidth);
        layout.setTileHeight(tileHeight);
        layout.setValid(128);
        layout.setValid(64);
        return layout;
    }

    private RenderedOp subsample(RenderedOp src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)new float[]{1.0f});
        pb.setParameter("Interpolation", (Object)this.interp);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, this.borderExtender);
        hints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public int getDownsampleStep() {
        return this.downsampleStep;
    }

    public void setDownsampleStep(int downsampleWH) {
        this.downsampleStep = downsampleWH;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public int getTileHeight() {
        return this.tileH;
    }

    public void setTileHeight(int tileHeight) {
        this.tileH = tileHeight;
    }

    public int getTileWidth() {
        return this.tileW;
    }

    public void setTileWidth(int tileWidth) {
        this.tileW = tileWidth;
    }

    private RenderedOp filteredSubsample(RenderedImage src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)this.lowPassFilter);
        pb.setParameter("Interpolation", (Object)this.interp);
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb);
    }

    private RenderedOp scaleAverage(RenderedImage src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("SubsampleAverage");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Double(1.0 / (double)this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Double(1.0 / (double)this.downsampleStep));
        return JAI.create((String)"SubsampleAverage", (ParameterBlock)pb, (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, this.borderExtender));
    }

    public void setBorderExtender(BorderExtender borderExtender) {
        this.borderExtender = borderExtender;
    }

    public void setInterp(Interpolation interp) {
        this.interp = interp;
    }

    public float[] getLowPassFilter() {
        return this.lowPassFilter;
    }

    public void setLowPassFilter(float[] lowPassFilter) {
        this.lowPassFilter = lowPassFilter;
    }

    public void run() {
        try {
            StringBuffer message;
            File[] files;
            File dir = new File(this.sourcePath);
            int numFiles = 1;
            if (dir.isDirectory()) {
                WildcardFilter fileFilter = new WildcardFilter(this.wildcardString);
                files = dir.listFiles((FileFilter)fileFilter);
                numFiles = files.length;
                if (numFiles <= 0) {
                    message = new StringBuffer("No files to process!");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), 100.0);
                }
            } else {
                files = new File[]{dir};
            }
            this.fileBeingProcessed = 0;
            while (this.fileBeingProcessed < numFiles) {
                message = new StringBuffer("Managing file  ").append(this.fileBeingProcessed).append(" of ").append(files[this.fileBeingProcessed]).append(" files");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                if (this.getStopThread()) {
                    message = new StringBuffer("Stopping requested at file  ").append(this.fileBeingProcessed).append(" of ").append(numFiles).append(" files");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                ImageInputStream stream = ImageIO.createImageInputStream(files[this.fileBeingProcessed]);
                stream.mark();
                Iterator<ImageReader> it = ImageIO.getImageReaders(stream);
                if (!it.hasNext()) {
                    return;
                }
                ImageReader reader = it.next();
                stream.reset();
                stream.mark();
                reader.setInput(stream);
                ImageLayout layout = null;
                int actualTileW = reader.getTileWidth(0);
                int actualTileH = reader.getTileHeight(0);
                int numImages = reader.getNumImages(true);
                if (reader.isImageTiled(0) && actualTileH != this.tileH && actualTileW != this.tileW && this.tileH != -1 && this.tileW != -1) {
                    message = new StringBuffer("Retiling image  ").append(this.fileBeingProcessed);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    layout = this.tile(this.tileW, this.tileH, 0, 0, this.interp);
                }
                stream.reset();
                reader.dispose();
                ImageOutputStream streamOut = ImageIO.createImageOutputStream(files[this.fileBeingProcessed]);
                if (streamOut == null) {
                    message = new StringBuffer("Unable to acquire an ImageOutputStream for the file ").append(files[this.fileBeingProcessed].toString());
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                ImageWriter writer = ImageIO.getImageWriter(reader);
                writer.setOutput(streamOut);
                writer.addIIOWriteProgressListener(this.writeProgressListener);
                writer.addIIOWriteWarningListener(this.writeProgressListener);
                ImageWriteParam param = writer.getDefaultWriteParam();
                if (!param.canWriteTiles()) {
                    message = new StringBuffer("This format do not support tiling!");
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                if (!writer.canInsertImage(numImages)) {
                    message = new StringBuffer("This format do not support overviews!");
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                if (this.tileH != -1 & this.tileW != -1) {
                    param.setTilingMode(2);
                    param.setTiling(this.tileW, this.tileH, 0, 0);
                } else {
                    param.setTilingMode(2);
                    param.setTiling(actualTileW, actualTileH, 0, 0);
                }
                if (this.compressionScheme != null && !Double.isNaN(this.compressionRatio)) {
                    param.setCompressionMode(2);
                    param.setCompressionType(this.compressionScheme);
                    param.setCompressionQuality((float)this.compressionRatio);
                }
                RenderingHints newHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                ParameterBlock pbjRead = new ParameterBlock();
                pbjRead.add(ImageIO.createImageInputStream(files[this.fileBeingProcessed]));
                pbjRead.add(new Integer(0));
                pbjRead.add(Boolean.FALSE);
                pbjRead.add(Boolean.FALSE);
                pbjRead.add(Boolean.FALSE);
                pbjRead.add(null);
                pbjRead.add(null);
                pbjRead.add(null);
                pbjRead.add(null);
                RenderedOp currentImage = JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints);
                message = new StringBuffer("Reaad original image  ").append(this.fileBeingProcessed);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                this.overviewInProcess = 0;
                while (this.overviewInProcess < this.numSteps) {
                    RenderedOp newImage;
                    message = new StringBuffer("Subsampling step ").append(this.overviewInProcess).append(" of image  ").append(this.fileBeingProcessed);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    if (currentImage.getWidth() / this.downsampleStep <= 0 || currentImage.getHeight() / this.downsampleStep <= 0) break;
                    if (this.scaleAlgorithm.equalsIgnoreCase("avg")) {
                        newImage = this.scaleAverage((RenderedImage)currentImage);
                    } else if (this.scaleAlgorithm.equalsIgnoreCase("filt")) {
                        newImage = this.filteredSubsample((RenderedImage)currentImage);
                    } else if (this.scaleAlgorithm.equalsIgnoreCase("bil")) {
                        newImage = this.bilinear(currentImage);
                    } else if (this.scaleAlgorithm.equalsIgnoreCase("nn")) {
                        newImage = this.subsample(currentImage);
                    } else if (this.scaleAlgorithm.equalsIgnoreCase("bic")) {
                        newImage = this.bicubic(currentImage);
                    } else {
                        throw new IllegalStateException();
                    }
                    writer.writeInsert(-1, new IIOImage((RenderedImage)newImage, null, null), param);
                    message = new StringBuffer("Step ").append(this.overviewInProcess).append(" of image  ").append(this.fileBeingProcessed).append(" done!");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    JAI.getDefaultInstance().getTileCache().removeTiles((RenderedImage)currentImage);
                    currentImage = newImage;
                    ++this.overviewInProcess;
                }
                message = new StringBuffer("Done with  image  ").append(this.fileBeingProcessed);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(this.fileBeingProcessed + 1) * 100.0 / (double)numFiles);
                ++this.fileBeingProcessed;
            }
        }
        catch (IOException e) {
            this.fireException(e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Done!!!");
        }
    }

    private RenderedOp bilinear(RenderedOp src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)new float[]{1.0f});
        pb.setParameter("Interpolation", (Object)new InterpolationBilinear());
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
    }

    private RenderedOp bicubic(RenderedOp src) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)new float[]{1.0f});
        pb.setParameter("Interpolation", (Object)new InterpolationBicubic(2));
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
    }

    public void getNotification(ProcessingEvent event) {
        LOGGER.info(new StringBuffer("Progress is at ").append(event.getPercentage()).append("\n").append("attached message is: ").append(event.getMessage()).toString());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public boolean parseArgs(String[] args) {
        if (!super.parseArgs(args)) {
            return false;
        }
        this.sourcePath = (String)this.getOptionValue(this.locationOpt);
        if (this.hasOption(this.tileDimOpt)) {
            String tileDim = (String)this.getOptionValue(this.tileDimOpt);
            String[] pairs = tileDim.split(",");
            this.tileW = Integer.parseInt(pairs[0]);
            this.tileH = Integer.parseInt(pairs[1]);
        }
        String scaleF = (String)this.getOptionValue(this.scaleFactorOpt);
        this.downsampleStep = Integer.parseInt(scaleF);
        if (this.hasOption(this.wildcardOpt)) {
            this.wildcardString = (String)this.getOptionValue(this.wildcardOpt);
        }
        this.scaleAlgorithm = (String)this.getOptionValue(this.scaleAlgorithmOpt);
        if (this.scaleAlgorithm == null) {
            this.scaleAlgorithm = "nn";
        }
        this.numSteps = Integer.parseInt((String)this.getOptionValue(this.numStepsOpt));
        if (this.hasOption(this.compressionTypeOpt)) {
            this.compressionScheme = (String)this.getOptionValue(this.compressionTypeOpt);
            if (this.compressionScheme == "") {
                this.compressionScheme = null;
            }
        }
        if (this.hasOption(this.compressionRatioOpt)) {
            try {
                this.compressionRatio = Double.parseDouble((String)this.getOptionValue(this.compressionRatioOpt));
            }
            catch (Exception e) {
                this.compressionRatio = Double.NaN;
            }
        }
        return true;
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException, InterruptedException {
        OverviewsEmbedder overviewsEmbedder = new OverviewsEmbedder();
        overviewsEmbedder.addProcessingEventListener(overviewsEmbedder);
        if (overviewsEmbedder.parseArgs(args)) {
            Thread t = new Thread((Runnable)overviewsEmbedder, NAME);
            t.setPriority(overviewsEmbedder.getPriority());
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unable to parse command line argumentBuilder, exiting...");
        }
    }

    public final void setWildcardString(String wildcardString) {
        this.wildcardString = wildcardString;
    }

    public final double getCompressionRatio() {
        return this.compressionRatio;
    }

    public final String getCompressionScheme() {
        return this.compressionScheme;
    }

    public final void setCompressionRatio(double compressionRatio) {
        this.compressionRatio = compressionRatio;
    }

    public final void setCompressionScheme(String compressionScheme) {
        this.compressionScheme = compressionScheme;
    }

    static {
        scalingAlgorithms.add("nn");
        scalingAlgorithms.add("bil");
        scalingAlgorithms.add("bic");
        scalingAlgorithms.add("avg");
        scalingAlgorithms.add("filt");
        LOGGER = Logging.getLogger((String)OverviewsEmbedder.class.toString());
    }

    private class OverviewsEmbedderWriteProgressListener
    extends WriteProgressListenerAdapter {
        private OverviewsEmbedderWriteProgressListener() {
        }

        public void imageComplete(ImageWriter source) {
            OverviewsEmbedder.this.fireEvent(new StringBuffer("Started with writing out overview number ").append((double)OverviewsEmbedder.this.overviewInProcess + 1.0).toString(), (double)(OverviewsEmbedder.this.overviewInProcess + 1 / OverviewsEmbedder.this.numSteps) * 100.0);
        }

        public void imageProgress(ImageWriter source, float percentageDone) {
            OverviewsEmbedder.this.fireEvent(new StringBuffer("Writing out overview ").append(OverviewsEmbedder.this.overviewInProcess + 1).toString(), (double)((float)(OverviewsEmbedder.this.overviewInProcess / OverviewsEmbedder.this.numSteps) + percentageDone / (float)(100 * OverviewsEmbedder.this.numSteps)) * 100.0);
        }

        public void imageStarted(ImageWriter source, int imageIndex) {
            OverviewsEmbedder.this.fireEvent(new StringBuffer("Completed writing out overview number ").append(OverviewsEmbedder.this.overviewInProcess + 1).toString(), (double)(OverviewsEmbedder.this.overviewInProcess / OverviewsEmbedder.this.numSteps) * 100.0);
        }

        public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
            OverviewsEmbedder.this.fireEvent(new StringBuffer("Warning at overview ").append(OverviewsEmbedder.this.overviewInProcess + 1).toString(), 0.0);
        }

        public void writeAborted(ImageWriter source) {
            OverviewsEmbedder.this.fireEvent(new StringBuffer("Aborted writing process.").toString(), 100.0);
        }
    }
}

