/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

class FilterToCQL
implements FilterVisitor,
ExpressionVisitor {
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    FilterToCQL() {
    }

    protected StringBuffer asStringBuffer(Object extraData) {
        if (extraData instanceof StringBuffer) {
            return (StringBuffer)extraData;
        }
        return new StringBuffer();
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("1 = 1");
        return output;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("1 = 1");
        return output;
    }

    public Object visit(And filter, Object extraData) {
        LOGGER.finer("exporting And filter");
        StringBuffer output = this.asStringBuffer(extraData);
        List children = filter.getChildren();
        if (children != null) {
            output.append("(");
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Filter child = (Filter)i.next();
                child.accept((FilterVisitor)this, (Object)output);
                if (!i.hasNext()) continue;
                output.append(" AND ");
            }
            output.append(")");
        }
        return output;
    }

    public Object visit(Id filter, Object extraData) {
        throw new IllegalStateException("Cannot encode an Id as legal CQL");
    }

    public Object visit(Not filter, Object extraData) {
        LOGGER.finer("exporting Not filter");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("NOT (");
        filter.getFilter().accept((FilterVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Or filter, Object extraData) {
        LOGGER.finer("exporting Or filter");
        StringBuffer output = this.asStringBuffer(extraData);
        List children = filter.getChildren();
        if (children != null) {
            output.append("(");
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Filter child = (Filter)i.next();
                child.accept((FilterVisitor)this, (Object)output);
                if (!i.hasNext()) continue;
                output.append(" OR ");
            }
            output.append(")");
        }
        return output;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        LOGGER.finer("exporting PropertyIsBetween");
        StringBuffer output = this.asStringBuffer(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" BETWEEN ");
        filter.getLowerBoundary().accept((ExpressionVisitor)this, (Object)output);
        output.append(" AND ");
        filter.getUpperBoundary().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        LOGGER.finer("exporting PropertyIsEqualTo");
        StringBuffer output = this.asStringBuffer(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" = ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        LOGGER.finer("exporting PropertyIsNotEqualTo");
        StringBuffer output = this.asStringBuffer(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" != ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        StringBuffer output = this.asStringBuffer(extraData);
        if (this.isDate((BinaryComparisonOperator)filter)) {
            return this.after(filter, output);
        }
        LOGGER.finer("exporting PropertyIsGreaterThan");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" > ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    protected boolean isDate(BinaryComparisonOperator compare) {
        if (compare.getExpression2() instanceof Literal) {
            Literal literal = (Literal)compare.getExpression2();
            return literal.getValue() instanceof Date;
        }
        return false;
    }

    public StringBuffer after(PropertyIsGreaterThan filter, StringBuffer output) {
        LOGGER.finer("exporting AFTER");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" AFTER ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        LOGGER.finer("exporting PropertyIsGreaterThanOrEqualTo");
        StringBuffer output = this.asStringBuffer(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" >= ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        LOGGER.finer("exporting PropertyIsLessThan");
        StringBuffer output = this.asStringBuffer(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" < ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        LOGGER.finer("exporting PropertyIsLessThanOrEqualTo");
        StringBuffer output = this.asStringBuffer(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" <= ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        StringBuffer output = this.asStringBuffer(extraData);
        char esc = filter.getEscape().charAt(0);
        char multi = filter.getWildCard().charAt(0);
        char single = filter.getSingleChar().charAt(0);
        boolean matchCase = filter.isMatchingCase();
        String pattern = LikeFilterImpl.convertToSQL92((char)esc, (char)multi, (char)single, (boolean)matchCase, (String)filter.getLiteral());
        if (!matchCase) {
            output.append(" UPPER(");
        }
        PropertyName propertyName = (PropertyName)filter.getExpression();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        if (!matchCase) {
            output.append(") LIKE '");
        } else {
            output.append(" LIKE '");
        }
        output.append(pattern);
        output.append("' ");
        return output;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        StringBuffer output = this.asStringBuffer(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(" IS NULL");
        return output;
    }

    public Object visit(BBOX filter, Object extraData) {
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("BBOX(");
        output.append(filter.getPropertyName());
        output.append(", ");
        output.append(filter.getMinX());
        output.append(",");
        output.append(filter.getMaxX());
        output.append(",");
        output.append(filter.getMinY());
        output.append(",");
        output.append(filter.getMaxY());
        output.append(")");
        return output;
    }

    public Object visit(Beyond filter, Object extraData) {
        LOGGER.finer("exporting Beyond");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("BEYOND(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Contains filter, Object extraData) {
        LOGGER.finer("exporting Contains");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("CONTAINS(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Crosses filter, Object extraData) {
        LOGGER.finer("exporting Crosses");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("CROSS(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Disjoint filter, Object extraData) {
        LOGGER.finer("exporting Crosses");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("DISJOINT(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(DWithin filter, Object extraData) {
        LOGGER.finer("exporting Crosses");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("DWITHIN(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        output.append(filter.getDistance());
        output.append(", ");
        output.append(filter.getDistanceUnits());
        output.append(")");
        return output;
    }

    public Object visit(Equals filter, Object extraData) {
        LOGGER.finer("exporting Equals");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("EQUALS(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Intersects filter, Object extraData) {
        LOGGER.finer("exporting Intersects");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("INTERSECT(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Overlaps filter, Object extraData) {
        LOGGER.finer("exporting Overlaps");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("OVERLAP(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Touches filter, Object extraData) {
        LOGGER.finer("exporting Touches");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("TOUCH(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Within filter, Object extraData) {
        LOGGER.finer("exporting Within");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("WITHIN(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        propertyName.accept((ExpressionVisitor)this, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visitNullFilter(Object extraData) {
        throw new NullPointerException("Cannot encode null as a Filter");
    }

    public Object visit(NilExpression expression, Object extraData) {
        LOGGER.finer("exporting Expression Nil");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append("\"\"");
        return output;
    }

    public Object visit(Add expression, Object extraData) {
        LOGGER.finer("exporting Expression Add");
        StringBuffer output = this.asStringBuffer(extraData);
        expression.getExpression1().accept((ExpressionVisitor)this, (Object)output);
        output.append(" + ");
        expression.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(Divide expression, Object extraData) {
        LOGGER.finer("exporting Expression Divide");
        StringBuffer output = this.asStringBuffer(extraData);
        expression.getExpression1().accept((ExpressionVisitor)this, (Object)output);
        output.append(" - ");
        expression.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(Function function, Object extraData) {
        LOGGER.finer("exporting Function");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append(function.getName());
        output.append("(");
        List parameters = function.getParameters();
        if (parameters != null) {
            Iterator i = parameters.iterator();
            while (i.hasNext()) {
                Expression argument = (Expression)i.next();
                argument.accept((ExpressionVisitor)this, (Object)output);
                if (!i.hasNext()) continue;
                output.append(",");
            }
        }
        output.append(")");
        return output;
    }

    public Object visit(Literal expression, Object extraData) {
        LOGGER.finer("exporting LiteralExpression");
        StringBuffer output = this.asStringBuffer(extraData);
        Object literal = expression.getValue();
        if (literal instanceof Geometry) {
            Geometry geometry = (Geometry)literal;
            WKTWriter writer = new WKTWriter();
            String wkt = writer.write(geometry);
            output.append(wkt);
        } else if (literal instanceof Number) {
            output.append(literal);
        } else {
            if (literal instanceof Date) {
                return this.date((Date)literal, output);
            }
            String escaped = literal.toString().replaceAll("'", "''");
            output.append("'" + escaped + "'");
        }
        return output;
    }

    public StringBuffer date(Date date, StringBuffer output) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT);
        String text = dateFormatter.format(date);
        output.append(text);
        return output;
    }

    public Object visit(Multiply expression, Object extraData) {
        LOGGER.finer("exporting Expression Multiply");
        StringBuffer output = this.asStringBuffer(extraData);
        expression.getExpression1().accept((ExpressionVisitor)this, (Object)output);
        output.append(" * ");
        expression.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyName expression, Object extraData) {
        LOGGER.finer("exporting PropertyName");
        StringBuffer output = this.asStringBuffer(extraData);
        output.append(expression.getPropertyName());
        return output;
    }

    public Object visit(Subtract expression, Object extraData) {
        LOGGER.finer("exporting Expression Subtract");
        StringBuffer output = this.asStringBuffer(extraData);
        expression.getExpression1().accept((ExpressionVisitor)this, (Object)output);
        output.append(" - ");
        expression.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }
}

