/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentState;
import org.geotools.factory.Hints;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentFeatureSource
implements SimpleFeatureSource {
    protected ContentEntry entry;
    protected Transaction transaction;
    protected Set<Hints.Key> hints;
    protected Query query;
    protected SimpleFeatureType schema;
    protected QueryCapabilities queryCapabilities;

    public ContentFeatureSource(ContentEntry entry, Query query) {
        this.entry = entry;
        this.query = query;
        this.hints = new HashSet<Hints.Key>();
        this.hints.add((Hints.Key)Hints.JTS_GEOMETRY_FACTORY);
        this.hints.add((Hints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        this.addHints(this.hints);
        this.hints = Collections.unmodifiableSet(this.hints);
    }

    public ContentEntry getEntry() {
        return this.entry;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public ContentState getState() {
        return this.entry.getState(this.transaction);
    }

    public ContentDataStore getDataStore() {
        return this.entry.getDataStore();
    }

    public final boolean isView() {
        return this.query != null && this.query != Query.ALL;
    }

    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(ContentFeatureSource.this.getSchema().getTypeName());
            }

            public ReferencedEnvelope getBounds() {
                try {
                    return ContentFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            public CoordinateReferenceSystem getCRS() {
                return ContentFeatureSource.this.getSchema().getCoordinateReferenceSystem();
            }

            public String getDescription() {
                return null;
            }

            public Set<String> getKeywords() {
                return this.words;
            }

            public String getName() {
                return ContentFeatureSource.this.getSchema().getTypeName();
            }

            public URI getSchema() {
                Name name = ContentFeatureSource.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public String getTitle() {
                Name name = ContentFeatureSource.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SimpleFeatureType getSchema() {
        if (this.schema != null) {
            return this.schema;
        }
        SimpleFeatureType featureType = this.getAbsoluteSchema();
        if (this.query != null && this.query.getPropertyNames() != Query.ALL_NAMES) {
            ContentFeatureSource contentFeatureSource = this;
            synchronized (contentFeatureSource) {
                if (this.schema == null) {
                    this.schema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)featureType, (String[])this.query.getPropertyNames());
                }
            }
            return this.schema;
        }
        return featureType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SimpleFeatureType getAbsoluteSchema() {
        ContentState state = this.entry.getState(this.transaction);
        SimpleFeatureType featureType = state.getFeatureType();
        if (featureType == null) {
            ContentState contentState = state;
            synchronized (contentState) {
                if (featureType == null) {
                    try {
                        featureType = this.buildFeatureType();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    state.setFeatureType(featureType);
                }
            }
        }
        return featureType;
    }

    public final ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public final ReferencedEnvelope getBounds(Query query) throws IOException {
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        ReferencedEnvelope bounds = this.getBoundsInternal(query);
        return bounds;
    }

    protected abstract ReferencedEnvelope getBoundsInternal(Query var1) throws IOException;

    public final int getCount(Query query) throws IOException {
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        int count = this.getCountInternal(query);
        return count;
    }

    protected abstract int getCountInternal(Query var1) throws IOException;

    public final ContentFeatureCollection getFeatures() throws IOException {
        Query query = this.joinQuery(Query.ALL);
        return new ContentFeatureCollection(this, query);
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader() throws IOException {
        return this.getReader(Query.ALL);
    }

    public final ContentFeatureCollection getFeatures(Query query) throws IOException {
        query = this.joinQuery(query);
        return new ContentFeatureCollection(this, query);
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader(Query query) throws IOException {
        SimpleFeatureType target;
        int offset;
        query = this.joinQuery(query);
        if ((query = this.resolvePropertyNames(query)).getStartIndex() != null && (query.getSortBy() == null || query.getSortBy().length == 0)) {
            if (!this.getQueryCapabilities().supportsSorting(query.getSortBy())) {
                throw new IOException("Feature source does not support this sorting so there is no way a stable paging (offset/limit) can be performed");
            }
            Query dq = new Query(query);
            dq.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
            query = dq;
        }
        FilteringFeatureReader reader = this.getReaderInternal(query);
        if (!this.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
            reader = new FilteringFeatureReader(reader, query.getFilter());
        }
        if (!this.canReproject() && query.getCoordinateSystemReproject() != null) {
            try {
                reader = new ReprojectFeatureReader(reader, query.getCoordinateSystemReproject());
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (IOException)new IOException("Error occurred trying to reproject data").initCause(e);
            }
        }
        int n = offset = query.getStartIndex() != null ? query.getStartIndex() : 0;
        if (!this.canOffset() && offset > 0) {
            for (int i = 0; i < offset && reader.hasNext(); ++i) {
                reader.next();
            }
        }
        if (!this.canLimit() && query.getMaxFeatures() != -1 && query.getMaxFeatures() < Integer.MAX_VALUE) {
            reader = new MaxFeatureReader((FeatureReader)reader, query.getMaxFeatures());
        }
        if (!this.canSort() && query.getSortBy() != null && query.getSortBy().length != 0) {
            throw new UnsupportedOperationException("sorting unsupported");
        }
        if (!this.canRetype() && query.getPropertyNames() != Query.ALL_NAMES && !(target = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])query.getPropertyNames())).equals(reader.getFeatureType())) {
            reader = new ReTypeFeatureReader((FeatureReader)reader, target, false);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(Query query, FeatureVisitor visitor, ProgressListener progress) throws IOException {
        if (progress == null) {
            progress = new NullProgressListener();
        }
        if (this.handleVisitor(query, visitor)) {
            return;
        }
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(query);
        try {
            float size = progress instanceof NullProgressListener ? 0.0f : (float)this.getCount(query);
            float position = 0.0f;
            progress.started();
            while (reader.hasNext()) {
                if (size > 0.0f) {
                    float f = position;
                    position = f + 1.0f;
                    progress.progress(f / size);
                }
                try {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    visitor.visit((Feature)feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
            }
        }
        finally {
            progress.complete();
            reader.close();
        }
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return false;
    }

    protected abstract FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query var1) throws IOException;

    protected boolean canReproject() {
        return false;
    }

    protected boolean canLimit() {
        return false;
    }

    protected boolean canOffset() {
        return false;
    }

    protected boolean canFilter() {
        return false;
    }

    protected boolean canRetype() {
        return false;
    }

    protected boolean canSort() {
        return false;
    }

    public final ContentFeatureSource getView(Query query) throws IOException {
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> c = clazz.getConstructor(ContentEntry.class, Query.class);
            ContentFeatureSource source = (ContentFeatureSource)c.newInstance(this.getEntry(), query);
            source.setTransaction(this.transaction);
            return source;
        }
        catch (Exception e) {
            String msg = "Subclass must implement Constructor(ContentEntry,Query)";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public final ContentFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.getSchema().getTypeName(), filter));
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader(Filter filter) throws IOException {
        return this.getReader(new Query(this.getSchema().getTypeName(), filter));
    }

    public final ContentFeatureSource getView(Filter filter) throws IOException {
        return this.getView(new Query(this.getSchema().getTypeName(), filter));
    }

    public final void addFeatureListener(FeatureListener listener) {
        this.entry.getState(this.transaction).addListener(listener);
    }

    public final void removeFeatureListener(FeatureListener listener) {
        this.entry.getState(this.transaction).removeListener(listener);
    }

    public final Set getSupportedHints() {
        return this.hints;
    }

    protected void addHints(Set<Hints.Key> hints) {
    }

    protected Query joinQuery(Query query) {
        return DataUtilities.mixQueries((Query)this.query, (Query)query, null);
    }

    protected Query resolvePropertyNames(Query query) {
        return DataUtilities.resolvePropertyNames((Query)query, (SimpleFeatureType)this.getSchema());
    }

    protected Filter resolvePropertyNames(Filter filter) {
        return DataUtilities.resolvePropertyNames((Filter)filter, (SimpleFeatureType)this.getSchema());
    }

    protected abstract SimpleFeatureType buildFeatureType() throws IOException;

    protected QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities();
    }

    public QueryCapabilities getQueryCapabilities() {
        if (this.queryCapabilities == null) {
            this.queryCapabilities = this.buildQueryCapabilities();
        }
        return this.queryCapabilities;
    }
}

