/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D;

import org.geotools.geometry.iso.topograph2D.Label;

public class Depth {
    private static final int NULL_VALUE = -1;
    private int[][] depth = new int[2][3];

    public static int depthAtLocation(int location) {
        if (location == 2) {
            return 0;
        }
        if (location == 0) {
            return 1;
        }
        return -1;
    }

    public Depth() {
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 3) {
                this.depth[i][j] = -1;
                ++j;
            }
            ++i;
        }
    }

    public int getDepth(int geomIndex, int posIndex) {
        return this.depth[geomIndex][posIndex];
    }

    public void setDepth(int geomIndex, int posIndex, int depthValue) {
        this.depth[geomIndex][posIndex] = depthValue;
    }

    public int getLocation(int geomIndex, int posIndex) {
        if (this.depth[geomIndex][posIndex] <= 0) {
            return 2;
        }
        return 0;
    }

    public void add(int geomIndex, int posIndex, int location) {
        if (location == 0) {
            int[] nArray = this.depth[geomIndex];
            int n = posIndex;
            nArray[n] = nArray[n] + 1;
        }
    }

    public boolean isNull() {
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 3) {
                if (this.depth[i][j] != -1) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean isNull(int geomIndex) {
        return this.depth[geomIndex][1] == -1;
    }

    public boolean isNull(int geomIndex, int posIndex) {
        return this.depth[geomIndex][posIndex] == -1;
    }

    public void add(Label lbl) {
        int i = 0;
        while (i < 2) {
            int j = 1;
            while (j < 3) {
                int loc = lbl.getLocation(i, j);
                if (loc == 2 || loc == 0) {
                    if (this.isNull(i, j)) {
                        this.depth[i][j] = Depth.depthAtLocation(loc);
                    } else {
                        int[] nArray = this.depth[i];
                        int n = j;
                        nArray[n] = nArray[n] + Depth.depthAtLocation(loc);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public int getDelta(int geomIndex) {
        return this.depth[geomIndex][2] - this.depth[geomIndex][1];
    }

    public void normalize() {
        int i = 0;
        while (i < 2) {
            if (!this.isNull(i)) {
                int minDepth = this.depth[i][1];
                if (this.depth[i][2] < minDepth) {
                    minDepth = this.depth[i][2];
                }
                if (minDepth < 0) {
                    minDepth = 0;
                }
                int j = 1;
                while (j < 3) {
                    int newValue = 0;
                    if (this.depth[i][j] > minDepth) {
                        newValue = 1;
                    }
                    this.depth[i][j] = newValue;
                    ++j;
                }
            }
            ++i;
        }
    }

    public String toString() {
        return "A: " + this.depth[0][1] + "," + this.depth[0][2] + " B: " + this.depth[1][1] + "," + this.depth[1][2];
    }
}

