/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.elem2D;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import org.geotools.geometry.iso.util.elem2D.Node2D;
import org.geotools.geometry.iso.util.elem2D.Simplex2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge2D
extends Line2D {
    public static int LEFTSIDE = 0;
    public static int RIGHTSIDE = 1;
    public int id = -1;
    protected Node2D p1;
    protected Node2D p2;
    protected Simplex2D surfaceRight;
    protected Simplex2D surfaceLeft;
    public Object object;

    protected Edge2D(Node2D p1, Node2D p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.surfaceRight = null;
        this.surfaceLeft = null;
        this.object = null;
    }

    protected Edge2D(Node2D p1, Node2D p2, Simplex2D surfaceRight, Simplex2D surfaceLeft) {
        this.p1 = p1;
        this.p2 = p2;
        this.surfaceRight = surfaceRight;
        this.surfaceLeft = surfaceLeft;
        this.object = null;
    }

    protected void setNodes(Node2D p1, Node2D p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    protected void setSimplex(Simplex2D simplex, int SIDE) {
        if (SIDE == RIGHTSIDE) {
            this.surfaceRight = simplex;
        } else if (SIDE == LEFTSIDE) {
            this.surfaceLeft = simplex;
        }
    }

    public Simplex2D getSurfaceRight() {
        return this.surfaceRight;
    }

    public Simplex2D getSurfaceLeft() {
        return this.surfaceLeft;
    }

    public int getNumberOfSurfaces() {
        return this.surfaceRight == null ? (this.surfaceLeft == null ? 0 : 1) : (this.surfaceLeft == null ? 1 : 2);
    }

    public boolean hasPoint(Point2D p) {
        return this.p1 == p || this.p2 == p;
    }

    public boolean hasSimplex(Simplex2D s) {
        return this.surfaceRight == s || this.surfaceLeft == s;
    }

    public void reverse() {
        Node2D p = this.p1;
        this.p1 = this.p2;
        this.p2 = p;
        Simplex2D s = this.surfaceRight;
        this.surfaceRight = this.surfaceLeft;
        this.surfaceLeft = s;
    }

    public Simplex2D getNeighborSimplex(Simplex2D f) {
        return this.surfaceRight == f ? this.surfaceLeft : this.surfaceRight;
    }

    public Simplex2D getLeftSimplex() {
        return this.surfaceLeft;
    }

    public Simplex2D getRightSimplex() {
        return this.surfaceRight;
    }

    @Override
    public double getX1() {
        return this.p1.getX();
    }

    @Override
    public double getY1() {
        return this.p1.getY();
    }

    @Override
    public Point2D getP1() {
        return this.p1;
    }

    public Node2D getNode1() {
        return this.p1;
    }

    @Override
    public double getX2() {
        return this.p2.getX();
    }

    @Override
    public double getY2() {
        return this.p2.getY();
    }

    @Override
    public Point2D getP2() {
        return this.p2;
    }

    public Node2D getNode2() {
        return this.p2;
    }

    @Override
    public void setLine(double x1, double y1, double x2, double y2) {
        this.p1.setLocation(x1, y1);
        this.p2.setLocation(x2, y2);
    }

    @Override
    public Rectangle2D getBounds2D() {
        double tmp;
        double x1 = this.getX1();
        double y1 = this.getY1();
        double x2 = this.getX2();
        double y2 = this.getY2();
        if (x2 < x1) {
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if (y2 < y1) {
            tmp = y2;
            y2 = y1;
            y1 = tmp;
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public double getLength() {
        return this.p1.distance(this.p2);
    }

    public double getLengthSq() {
        return this.p1.distanceSq(this.p2);
    }

    public Edge2D getNeighbourEdge(Node2D n) {
        if (this.p1 != n && this.p2 != n) {
            return null;
        }
        Edge2D[] edges = n.getEdges();
        if (edges.length != 2) {
            return null;
        }
        return edges[0] == this ? edges[1] : edges[0];
    }

    public static ArrayList<LinkedList<Point2D>> getCoordinateSequencesFromEdges(ArrayList<Edge2D> edges) {
        ArrayList<LinkedList<Point2D>> result = new ArrayList<LinkedList<Point2D>>();
        while (!edges.isEmpty()) {
            Edge2D removeEdge;
            Node2D n;
            LinkedList<Point2D.Double> coordList = new LinkedList<Point2D.Double>();
            Edge2D e = edges.remove(edges.size() - 1);
            Node2D nBeg = e.getNode1();
            Node2D nEnd = e.getNode2();
            coordList.addFirst(new Point2D.Double(nBeg.x, nBeg.y));
            coordList.addLast(new Point2D.Double(nEnd.x, nEnd.y));
            Edge2D en = e.getNeighbourEdge(nBeg);
            while (en != null && en != e) {
                n = en.getNode1() == nBeg ? en.getNode2() : en.getNode1();
                coordList.addFirst(new Point2D.Double(n.x, n.y));
                nBeg = n;
                removeEdge = en;
                en = en.getNeighbourEdge(nBeg);
                edges.remove(removeEdge);
            }
            en = e.getNeighbourEdge(nEnd);
            while (en != null && en != e) {
                n = en.getNode1() == nEnd ? en.getNode2() : en.getNode1();
                coordList.addLast(new Point2D.Double(n.x, n.y));
                nEnd = n;
                removeEdge = en;
                en = en.getNeighbourEdge(nEnd);
                edges.remove(removeEdge);
            }
            result.add(coordList);
        }
        return result;
    }
}

