/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso;

import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DimensionModel {
    public static final int TWO_DIMENSIONIAL = 1;
    public static final int TWOoFIVE_DIMENSIONIAL = 2;
    public static final int THREE_DIMENSIONIAL = 3;
    private int dimensionModelType = 0;

    public static int toD(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return 2;
        }
        int dimension = crs.getCoordinateSystem().getDimension();
        if (dimension == 2) {
            return 1;
        }
        if (dimension == 3) {
            return 3;
        }
        return -1;
    }

    public DimensionModel(int dimensionType) {
        this.dimensionModelType = dimensionType;
    }

    public int getDimensionType() {
        return this.dimensionModelType;
    }

    public int getCoordinateDimension() {
        if (this.dimensionModelType == 1) {
            return 2;
        }
        if (this.dimensionModelType == 2) {
            return 3;
        }
        if (this.dimensionModelType == 3) {
            return 3;
        }
        return 0;
    }

    public boolean is2D() {
        return this.dimensionModelType == 1;
    }

    public boolean is2o5D() {
        return this.dimensionModelType == 2;
    }

    public boolean is3D() {
        return this.dimensionModelType == 3;
    }

    public String toString() {
        String rString = "";
        if (this.dimensionModelType == 1) {
            rString = "2D";
        } else if (this.dimensionModelType == 2) {
            rString = "2.5D";
        } else if (this.dimensionModelType == 3) {
            rString = "3D";
        }
        return rString;
    }
}

