/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso;

import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.factory.Factory;
import org.geotools.factory.Hints;
import org.geotools.geometry.iso.PrecisionModel;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.DoublePointArray;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.Precision;
import org.opengis.geometry.PrecisionType;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PositionFactoryImpl
implements Serializable,
Factory,
PositionFactory {
    private static final long serialVersionUID = 1L;
    private final Precision precision;
    final CoordinateReferenceSystem crs;
    private Map<RenderingHints.Key, Object> hintsWeCareAbout = new HashMap<RenderingHints.Key, Object>();

    public PositionFactoryImpl() {
        this((Hints)null);
    }

    public PositionFactoryImpl(Hints hints) {
        if (hints == null) {
            this.crs = DefaultGeographicCRS.WGS84;
            this.precision = new PrecisionModel();
        } else {
            this.crs = (CoordinateReferenceSystem)hints.get((Object)Hints.CRS);
            this.precision = new PrecisionModel();
        }
        this.hintsWeCareAbout.put((RenderingHints.Key)Hints.CRS, this.crs);
        this.hintsWeCareAbout.put((RenderingHints.Key)Hints.PRECISION, this.precision);
    }

    public PositionFactoryImpl(CoordinateReferenceSystem crs) {
        this(crs, new PrecisionModel(PrecisionType.DOUBLE));
    }

    public PositionFactoryImpl(CoordinateReferenceSystem crs, Precision precision) {
        assert (precision.getType() == PrecisionType.DOUBLE);
        this.crs = crs;
        this.precision = precision;
        this.hintsWeCareAbout.put((RenderingHints.Key)Hints.CRS, crs);
        this.hintsWeCareAbout.put((RenderingHints.Key)Hints.PRECISION, precision);
    }

    public Map getImplementationHints() {
        return Collections.unmodifiableMap(this.hintsWeCareAbout);
    }

    public DirectPosition createDirectPosition(double[] coords) throws MismatchedDimensionException {
        if (coords != null) {
            return new DirectPositionImpl(this.crs, coords);
        }
        return new DirectPositionImpl(this.crs);
    }

    public Position createPosition(Position position) {
        DirectPosition directPosition = position.getPosition();
        return new DirectPositionImpl(directPosition);
    }

    public PointArrayImpl createPointArray() {
        return new PointArrayImpl(this.crs);
    }

    public DoublePointArray createPointArray(double[] array, int start, int end) {
        return new DoublePointArray(this.crs, array, start, end);
    }

    public PointArray createPointArray(float[] array, int start, int end) {
        PointArrayImpl pointArray = this.createPointArray();
        int D = this.crs.getCoordinateSystem().getDimension();
        if (D == 2) {
            for (int i = start; i < end; i += D) {
                double[] ordinates = new double[]{array[i], array[i + 1]};
                pointArray.add(new DirectPositionImpl(this.crs, ordinates));
            }
        } else if (D == 3) {
            for (int i = start; i < end; i += D) {
                double[] ordinates = new double[]{array[i], array[i + 1], array[i + 2]};
                pointArray.add(new DirectPositionImpl(this.crs, ordinates));
            }
        } else {
            for (int i = start; i < end; i += D) {
                double[] ordinates = new double[D];
                int o = 0;
                while (i < D) {
                    ordinates[o] = array[i + o];
                    ++i;
                }
                pointArray.add(new DirectPositionImpl(this.crs, ordinates));
            }
        }
        return pointArray;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Precision getPrecision() {
        return this.precision;
    }
}

