/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation;

import org.geotools.geometry.iso.PrecisionModel;
import org.geotools.geometry.iso.UnsupportedDimensionException;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.geotools.geometry.iso.topograph2D.GeometryGraph;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.geotools.geometry.iso.util.algorithm2D.LineIntersector;
import org.geotools.geometry.iso.util.algorithm2D.RobustLineIntersector;

public abstract class GeometryGraphOperation {
    protected final CGAlgorithms cga = new CGAlgorithms();
    protected final LineIntersector li = new RobustLineIntersector();
    protected PrecisionModel resultPrecisionModel;
    protected GeometryGraph[] arg;

    public GeometryGraphOperation(GeometryImpl g0, GeometryImpl g1) throws UnsupportedDimensionException {
        int g0Dim = g0.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        int g1Dim = g1.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        if (g0Dim != 2 || g1Dim != 2) {
            throw new UnsupportedDimensionException("This operation only works in 2D");
        }
        this.arg = new GeometryGraph[2];
        this.arg[0] = new GeometryGraph(0, g0);
        this.arg[1] = new GeometryGraph(1, g1);
    }

    public GeometryGraphOperation(GeometryImpl g0) {
        this.arg = new GeometryGraph[1];
        this.arg[0] = new GeometryGraph(0, g0);
    }

    public GeometryImpl getArgGeometry(int i) {
        return this.arg[i].getGeometry();
    }

    protected void setComputationPrecision(PrecisionModel pm) {
        this.resultPrecisionModel = pm;
        this.li.setPrecisionModel(this.resultPrecisionModel);
    }
}

