/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation.overlay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.operation.overlay.MaximalEdgeRing;
import org.geotools.geometry.iso.operation.overlay.MinimalEdgeRing;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.DirectedEdge;
import org.geotools.geometry.iso.topograph2D.EdgeRing;
import org.geotools.geometry.iso.topograph2D.Envelope;
import org.geotools.geometry.iso.topograph2D.PlanarGraph;
import org.geotools.geometry.iso.topograph2D.util.CoordinateArrays;
import org.geotools.geometry.iso.util.Assert;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PolygonBuilder {
    static final int X = 0;
    static final int Y = 1;
    static final int Z = 2;
    private CoordinateReferenceSystem crs;
    private CGAlgorithms cga;
    private List shellList = new ArrayList();

    public PolygonBuilder(CoordinateReferenceSystem crs, CGAlgorithms cga) {
        this.crs = crs;
        this.cga = cga;
    }

    public void add(PlanarGraph graph) {
        this.add(graph.getEdgeEnds(), graph.getNodes());
    }

    public void add(Collection dirEdges, Collection nodes) {
        PlanarGraph.linkResultDirectedEdges(nodes);
        List maxEdgeRings = this.buildMaximalEdgeRings(dirEdges);
        ArrayList freeHoleList = new ArrayList();
        List edgeRings = this.buildMinimalEdgeRings(maxEdgeRings, this.shellList, freeHoleList);
        this.sortShellsAndHoles(edgeRings, this.shellList, freeHoleList);
        this.placeFreeHoles(this.shellList, freeHoleList);
    }

    public List getPolygons() {
        List resultPolyList = this.computeSurfaces(this.shellList);
        return resultPolyList;
    }

    private List buildMaximalEdgeRings(Collection dirEdges) {
        ArrayList<MaximalEdgeRing> maxEdgeRings = new ArrayList<MaximalEdgeRing>();
        for (DirectedEdge de : dirEdges) {
            if (!de.isInResult() || !de.getLabel().isArea() || de.getEdgeRing() != null) continue;
            MaximalEdgeRing er = new MaximalEdgeRing(de, this.crs, this.cga);
            maxEdgeRings.add(er);
            er.setInResult();
        }
        return maxEdgeRings;
    }

    private List buildMinimalEdgeRings(List maxEdgeRings, List shellList, List freeHoleList) {
        ArrayList<MaximalEdgeRing> edgeRings = new ArrayList<MaximalEdgeRing>();
        for (MaximalEdgeRing er : maxEdgeRings) {
            if (er.getMaxNodeDegree() > 2) {
                er.linkDirectedEdgesForMinimalEdgeRings();
                List minEdgeRings = er.buildMinimalRings();
                EdgeRing shell = this.findShell(minEdgeRings);
                if (shell != null) {
                    this.placePolygonHoles(shell, minEdgeRings);
                    shellList.add(shell);
                    continue;
                }
                freeHoleList.addAll(minEdgeRings);
                continue;
            }
            edgeRings.add(er);
        }
        return edgeRings;
    }

    private EdgeRing findShell(List minEdgeRings) {
        int shellCount = 0;
        MinimalEdgeRing shell = null;
        for (MinimalEdgeRing er : minEdgeRings) {
            if (er.isHole()) continue;
            shell = er;
            ++shellCount;
        }
        Assert.isTrue(shellCount <= 1, "found two shells in MinimalEdgeRing list");
        return shell;
    }

    private void placePolygonHoles(EdgeRing shell, List minEdgeRings) {
        for (MinimalEdgeRing er : minEdgeRings) {
            if (!er.isHole()) continue;
            er.setShell(shell);
        }
    }

    private void sortShellsAndHoles(List edgeRings, List shellList, List freeHoleList) {
        for (EdgeRing er : edgeRings) {
            if (er.isHole()) {
                freeHoleList.add(er);
                continue;
            }
            shellList.add(er);
        }
    }

    private void placeFreeHoles(List shellList, List freeHoleList) {
        for (EdgeRing hole : freeHoleList) {
            if (hole.getShell() != null) continue;
            EdgeRing shell = this.findEdgeRingContaining(hole, shellList);
            Assert.isTrue(shell != null, "unable to assign hole to a shell");
            hole.setShell(shell);
        }
    }

    private EdgeRing findEdgeRingContaining(EdgeRing testEr, List shellList) {
        Ring testRing = testEr.getRing();
        EnvelopeImpl env = (EnvelopeImpl)testRing.getEnvelope();
        Envelope testEnv = new Envelope(env.getLowerCorner().getOrdinate(0), env.getUpperCorner().getOrdinate(0), env.getLowerCorner().getOrdinate(1), env.getUpperCorner().getOrdinate(1));
        DirectPosition dp = testRing.getRepresentativePoint();
        Coordinate testPt = new Coordinate(dp.getCoordinates());
        EdgeRing minShell = null;
        Envelope minEnv = null;
        for (EdgeRing tryShell : shellList) {
            Ring tryRing = tryShell.getRing();
            env = (EnvelopeImpl)tryRing.getEnvelope();
            Envelope tryEnv = new Envelope(env.getLowerCorner().getOrdinate(0), env.getUpperCorner().getOrdinate(0), env.getLowerCorner().getOrdinate(1), env.getUpperCorner().getOrdinate(1));
            if (minShell != null) {
                env = (EnvelopeImpl)minShell.getRing().getEnvelope();
                minEnv = new Envelope(env.getLowerCorner().getOrdinate(0), env.getUpperCorner().getOrdinate(0), env.getLowerCorner().getOrdinate(1), env.getUpperCorner().getOrdinate(1));
            }
            boolean isContained = false;
            if (tryEnv.contains(testEnv) && CGAlgorithms.isPointInRing(testPt, CoordinateArrays.toCoordinateArray(((RingImplUnsafe)tryRing).asDirectPositions()))) {
                isContained = true;
            }
            if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
            minShell = tryShell;
        }
        return minShell;
    }

    private List computeSurfaces(List shellList) {
        ArrayList<SurfaceImpl> resultPolyList = new ArrayList<SurfaceImpl>();
        for (EdgeRing er : shellList) {
            SurfaceImpl poly = er.toPolygon();
            resultPolyList.add(poly);
        }
        return resultPolyList;
    }

    public boolean containsPoint(Coordinate p) {
        for (EdgeRing er : this.shellList) {
            if (!er.containsPoint(p)) continue;
            return true;
        }
        return false;
    }
}

