/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso;

import java.io.Serializable;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Precision;
import org.opengis.geometry.PrecisionType;

public class PrecisionModel
implements Serializable,
Precision {
    private static final long serialVersionUID = 7777263578777803835L;
    public static final PrecisionType FIXED = PrecisionType.FIXED;
    public static final PrecisionType FLOATING = PrecisionType.DOUBLE;
    public static final PrecisionType FLOATING_SINGLE = PrecisionType.FLOAT;
    public static final double maximumPreciseValue = 9.007199254740992E15;
    private PrecisionType modelType;
    private double scale;

    public PrecisionModel() {
        this.modelType = FLOATING;
    }

    public PrecisionModel(PrecisionType modelType) {
        this.modelType = modelType;
        if (modelType == FIXED) {
            this.setScale(1.0);
        }
    }

    public PrecisionModel(double scale) {
        this.modelType = FIXED;
        this.setScale(scale);
    }

    public PrecisionModel(PrecisionModel pm) {
        this.modelType = pm.modelType;
        this.scale = pm.scale;
    }

    public boolean isFloating() {
        return this.modelType == FLOATING || this.modelType == FLOATING_SINGLE;
    }

    public int getMaximumSignificantDigits() {
        int maxSigDigits = 16;
        if (this.modelType == FLOATING) {
            maxSigDigits = 16;
        } else if (this.modelType == FLOATING_SINGLE) {
            maxSigDigits = 6;
        } else if (this.modelType == FIXED) {
            maxSigDigits = 1 + (int)Math.ceil(Math.log(this.getScale()) / Math.log(10.0));
        }
        return maxSigDigits;
    }

    public double getScale() {
        return this.scale;
    }

    public PrecisionType getType() {
        return this.modelType;
    }

    private void setScale(double scale) {
        this.scale = Math.abs(scale);
    }

    public double makePrecise(double val) {
        if (this.modelType == FLOATING_SINGLE) {
            float floatSingleVal = (float)val;
            return floatSingleVal;
        }
        if (this.modelType == FIXED) {
            return (double)Math.round(val * this.scale) / this.scale;
        }
        return val;
    }

    public void makePrecise(Coordinate coord) {
        if (this.modelType == FLOATING) {
            return;
        }
        coord.x = this.makePrecise(coord.x);
        coord.y = this.makePrecise(coord.y);
    }

    public String toString() {
        String description = "UNKNOWN";
        if (this.modelType == FLOATING) {
            description = "Floating";
        } else if (this.modelType == FLOATING_SINGLE) {
            description = "Floating-Single";
        } else if (this.modelType == FIXED) {
            description = "Fixed (Scale=" + this.getScale() + ")";
        }
        return description;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PrecisionModel)) {
            return false;
        }
        PrecisionModel otherPrecisionModel = (PrecisionModel)other;
        return this.modelType == otherPrecisionModel.modelType && this.scale == otherPrecisionModel.scale;
    }

    public int compareTo(PrecisionModel other) {
        if (other == null) {
            return 0;
        }
        int sigDigits = this.getMaximumSignificantDigits();
        int otherSigDigits = other.getMaximumSignificantDigits();
        return new Integer(sigDigits).compareTo(new Integer(otherSigDigits));
    }

    public int compareTo(Precision precision) {
        if (precision == null) {
            return 0;
        }
        int sigDigits = this.getMaximumSignificantDigits();
        int otherSigDigits = precision.getMaximumSignificantDigits();
        return new Integer(sigDigits).compareTo(new Integer(otherSigDigits));
    }

    public void round(DirectPosition position) {
        if (this.modelType.isFloating()) {
            return;
        }
        double[] coords = position.getCoordinates();
        position.setOrdinate(0, this.makePrecise(coords[0]));
        position.setOrdinate(1, this.makePrecise(coords[1]));
        if (coords.length == 2) {
            return;
        }
        position.setOrdinate(2, this.makePrecise(coords[2]));
        if (coords.length == 3) {
            return;
        }
        for (int axis = 3; axis < position.getDimension(); ++axis) {
            double ordinate = position.getOrdinate(axis);
            ordinate = this.makePrecise(ordinate);
            position.setOrdinate(axis, ordinate);
        }
    }
}

