/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.interpolation;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;
import org.geotools.geometry.iso.util.interpolation.PointNeighboursGradients;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITP_Interpolation {
    public static boolean shepardModified(ArrayList<Point3d> pIn, ArrayList<Point3d> pOut, double q, int nnbr) {
        if (nnbr == 0) {
            nnbr = pIn.size() - 1;
        }
        ArrayList<PointNeighboursGradients> png = ITP_Interpolation.akimaGradient(pIn, nnbr);
        for (int i = 0; i < pOut.size(); ++i) {
            ITP_Interpolation.shepardModified(png, q, pOut.get(i));
        }
        return true;
    }

    private static ArrayList<PointNeighboursGradients> akimaGradient(ArrayList<Point3d> pIn, int nnbr) {
        ArrayList<PointNeighboursGradients> result = new ArrayList<PointNeighboursGradients>(pIn.size());
        for (int i = 0; i < pIn.size(); ++i) {
            Point3d p = pIn.get(i);
            PointNeighboursGradients png = new PointNeighboursGradients(p);
            png.setClosestPoints(pIn, nnbr);
            png.setAkimaGradient();
            result.add(png);
        }
        return result;
    }

    private static void shepardModified(ArrayList<PointNeighboursGradients> pngColl, double q, Point3d p_eval) {
        PointNeighboursGradients png0;
        double[] dist = new double[pngColl.size()];
        double distMax = 0.0;
        for (int i = 0; i < pngColl.size(); ++i) {
            png0 = pngColl.get(i);
            dist[i] = q == 2.0 ? (p_eval.x - png0.mP.x) * (p_eval.x - png0.mP.x) + (p_eval.y - png0.mP.y) * (p_eval.y - png0.mP.y) : Math.pow(p_eval.distance(png0.mP), q);
            distMax = Math.max(dist[i], distMax);
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        for (int i = 0; i < pngColl.size(); ++i) {
            png0 = pngColl.get(i);
            double prod = 1.0;
            for (int j = 0; j < pngColl.size(); ++j) {
                if (i == j || (prod *= dist[j] / distMax) != 0.0) continue;
                PointNeighboursGradients png1 = pngColl.get(j);
                p_eval.z = png1.mP.z;
                return;
            }
            ((Point2D)p0).setLocation(p_eval.x, p_eval.y);
            ((Point2D)p1).setLocation(png0.mP.x, png0.mP.y);
            sum0 += (png0.mP.z + AlgoPoint2D.scalar(AlgoPoint2D.subtract(p0, p1), png0.mGradXY)) * prod;
            sum1 += prod;
        }
        p_eval.z = sum0 / sum1;
    }

    public static class Point3d {
        public double x;
        public double y;
        public double z;

        public Point3d(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double distance(Point3d p) {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        HARDYMQ,
        CARLSONHARDY,
        STEADHARDY,
        SHEPARD;

    }
}

