/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.path;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.path.NodeSequence;
import org.geotools.graph.path.Path;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;

public class Walk
extends ArrayList
implements NodeSequence {
    private List m_edges;

    public Walk() {
    }

    public Walk(Collection nodes) {
        super(nodes);
    }

    public boolean isValid() {
        return this.getEdges() != null;
    }

    public List getEdges() {
        if (this.m_edges == null) {
            this.m_edges = this.buildEdges();
        }
        return this.m_edges;
    }

    public boolean add(Node node) {
        this.m_edges = null;
        return super.add(node);
    }

    public void add(int index, Object element) {
        super.add(index, element);
        this.m_edges = null;
    }

    public boolean add(Object o) {
        return this.add((Node)o);
    }

    public boolean addAll(Collection c) {
        this.m_edges = null;
        return super.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.m_edges = null;
        return super.addAll(index, c);
    }

    public boolean addEdge(Edge e) {
        List edges = this.getEdges();
        if (this.isEmpty()) {
            this.add(e.getNodeA());
            this.add(e.getNodeB());
        } else {
            Node last = this.getLast();
            if (last.equals(e.getNodeA())) {
                this.add(e.getNodeB());
            } else if (last.equals(e.getNodeB())) {
                this.add(e.getNodeA());
            } else {
                return false;
            }
        }
        edges.add(e);
        this.m_edges = edges;
        return true;
    }

    public void addEdges(Collection edges) {
        for (Edge e : edges) {
            this.addEdge(e);
        }
    }

    public void remove(Node node) {
        super.remove(node);
        this.m_edges = null;
    }

    public Object remove(int index) {
        this.m_edges = null;
        return super.remove(index);
    }

    public boolean remove(Object o) {
        this.m_edges = null;
        return super.remove(o);
    }

    public boolean removeAll(Collection c) {
        this.m_edges = null;
        return super.removeAll(c);
    }

    public boolean isClosed() {
        if (this.isEmpty() || !this.isValid()) {
            return false;
        }
        return this.get(0).equals(this.get(this.size() - 1));
    }

    public Node getFirst() {
        return (Node)this.get(0);
    }

    public Node getLast() {
        return (Node)this.get(this.size() - 1);
    }

    protected List buildEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i = 1;
        while (i < this.size()) {
            Node prev = (Node)this.get(i - 1);
            Node curr = (Node)this.get(i);
            Edge e = curr.getEdge(prev);
            if (e == null) {
                return null;
            }
            edges.add(e);
            ++i;
        }
        return edges;
    }

    public void reverse() {
        Collections.reverse(this);
        this.m_edges = null;
    }

    public void truncate(int index) {
        this.removeRange(index, this.size());
        this.m_edges = null;
    }

    public Iterator riterator() {
        return new Iterator(){
            int m_index;
            {
                this.m_index = Walk.this.size() - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Path iterator does not support remove()");
            }

            public boolean hasNext() {
                return this.m_index > -1;
            }

            public Object next() {
                return Walk.this.get(this.m_index--);
            }
        };
    }

    public Path duplicate() {
        return new Path((Collection)this);
    }

    public boolean equals(Object other) {
        if (other instanceof Walk) {
            return this.equals((Walk)other);
        }
        return false;
    }

    public boolean equals(Walk other) {
        if (other.size() == this.size()) {
            Iterator thisnodes = this.iterator();
            Iterator othernodes = other.iterator();
            while (thisnodes.hasNext()) {
                Node othernode;
                Node thisnode = (Node)thisnodes.next();
                if (thisnode.equals(othernode = (Node)othernodes.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.getFirst().hashCode();
        hash = 31 * hash + this.getLast().hashCode();
        return hash;
    }
}

