/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.graph.util.Queue;

public class Stack
implements Collection,
Queue {
    private static final int DEFAULT_SIZE = 10;
    private Object[] m_values;
    private int m_sp;

    public Stack() {
        this(10);
    }

    public Stack(int size) {
        this.m_values = new Object[size];
        this.m_sp = 0;
    }

    public void push(Object element) {
        this.m_values[this.m_sp++] = element;
    }

    public void pushAll(Collection elements) {
        Iterator itr = elements.iterator();
        while (itr.hasNext()) {
            this.m_values[this.m_sp++] = itr.next();
        }
    }

    public Object pop() {
        return this.m_values[--this.m_sp];
    }

    public int size() {
        return this.m_sp;
    }

    public void clear() {
        this.m_sp = 0;
    }

    public boolean isEmpty() {
        return this.m_sp == 0;
    }

    public Object[] toArray() {
        return this.m_values;
    }

    public boolean add(Object o) {
        this.push(o);
        return true;
    }

    public boolean contains(Object o) {
        int i = 0;
        while (i < this.m_sp) {
            if (this.m_values[i].equals(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove(Object)");
    }

    public boolean addAll(Collection c) {
        this.pushAll(c);
        return true;
    }

    public boolean containsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("removeAll(Collection)");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("retainAll(Collection)");
    }

    public Iterator iterator() {
        return new StackIterator();
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.m_sp) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.m_sp);
        }
        int i = 0;
        while (i < this.m_sp) {
            a[i] = this.m_values[i];
            ++i;
        }
        if (a.length > this.m_sp) {
            a[this.m_sp] = null;
        }
        return a;
    }

    public void enq(Object object) {
        this.push(object);
    }

    public Object deq() {
        return this.pop();
    }

    public class StackIterator
    implements Iterator {
        int m_index = 0;

        private StackIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }

        public boolean hasNext() {
            return this.m_index < Stack.this.m_sp;
        }

        public Object next() {
            return Stack.this.m_values[this.m_index++];
        }
    }
}

