/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

public class StringUtil {
    public static String strip(String s) {
        StringBuffer sb = new StringBuffer();
        int spaces = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ' ') {
                if (spaces > 0) {
                    return sb.toString();
                }
                ++spaces;
            } else {
                sb.append(s.charAt(i));
                spaces = 0;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String noSpaces(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ' ') {
                sb.append(s.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String postfixFilename(String filename, String postfix) {
        int index = filename.lastIndexOf(".");
        return String.valueOf(filename.substring(0, index)) + postfix + filename.substring(index);
    }

    public static String prefixFilename(String path, String prefix) {
        int index = path.lastIndexOf("\\");
        return String.valueOf(path.substring(0, index)) + "\\" + prefix + path.substring(index + 1);
    }

    public static String addExtIfNecessary(String filename, String ext) {
        if (StringUtil.hasExtension(filename, ext)) {
            return filename;
        }
        return StringUtil.setExtension(filename, ext);
    }

    public static String setExtension(String filename, String ext) {
        if (StringUtil.hasExtension(filename, ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return String.valueOf(filename) + "." + ext;
        }
        return String.valueOf(filename.substring(0, index + 1)) + ext;
    }

    public static boolean hasExtension(String filename, String ext) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return false;
        }
        return filename.substring(index + 1).compareTo(ext) == 0;
    }

    public static String stripPath(String filename) {
        int index = filename.lastIndexOf("\\");
        if (index == -1) {
            return filename;
        }
        return filename.substring(index + 1);
    }

    public static String stripExtension(String filename) {
        int index = filename.lastIndexOf(".");
        return filename.substring(0, index);
    }
}

