/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Neighbor;
import org.opengis.feature.Feature;

public abstract class AbstractGridBuilder {
    private static final Logger LOGGER = Logger.getLogger(AbstractGridBuilder.class.getName());
    protected final ReferencedEnvelope gridBounds;

    public AbstractGridBuilder(ReferencedEnvelope gridBounds) {
        this.gridBounds = new ReferencedEnvelope(gridBounds);
    }

    public boolean buildGrid(SimpleFeatureCollection fc, GridFeatureBuilder gridFeatureBuilder, double vertexSpacing) {
        GridElement el0;
        boolean result = true;
        boolean densify = this.isValidDenseVertexSpacing(vertexSpacing);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(gridFeatureBuilder.getType());
        String geomPropName = gridFeatureBuilder.getType().getGeometryDescriptor().getLocalName();
        GridElement el = el0 = this.getFirstElement();
        while (el.getBounds().getMinY() <= this.gridBounds.getMaxY()) {
            while (el.getBounds().getMaxX() <= this.gridBounds.getMaxX()) {
                if (this.gridBounds.contains((Envelope)el.getBounds()) && gridFeatureBuilder.getCreateFeature(el)) {
                    HashMap<String, Object> attrMap = new HashMap<String, Object>();
                    gridFeatureBuilder.setAttributes(el, attrMap);
                    if (densify) {
                        fb.set(geomPropName, (Object)el.toDensePolygon(vertexSpacing));
                    } else {
                        fb.set(geomPropName, (Object)el.toPolygon());
                    }
                    for (String propName : attrMap.keySet()) {
                        fb.set(propName, attrMap.get(propName));
                    }
                    fc.add((Feature)fb.buildFeature(gridFeatureBuilder.getFeatureID(el)));
                }
                el = this.getNextXElement(el);
            }
            el = el0 = this.getNextYElement(el0);
        }
        return result;
    }

    public abstract boolean isValidNeighbor(Neighbor var1);

    public abstract GridElement createNeighbor(GridElement var1, Neighbor var2);

    public abstract GridElement getFirstElement();

    public abstract GridElement getNextXElement(GridElement var1);

    public abstract GridElement getNextYElement(GridElement var1);

    public abstract boolean isValidDenseVertexSpacing(double var1);
}

