/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.hexagon;

import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.Orientation;
import org.geotools.grid.hexagon.Hexagon;
import org.geotools.grid.hexagon.Hexagons;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class HexagonImpl
implements Hexagon {
    private static final double ROOT3 = Math.sqrt(3.0);
    private static final GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
    private final double sideLen;
    private final double area;
    private final double minX;
    private final double minY;
    private final Orientation orientation;
    private Coordinate[] vertices;
    private final CoordinateReferenceSystem crs;

    public HexagonImpl(double minX, double minY, double sideLen, Orientation orientation, CoordinateReferenceSystem crs) {
        if (sideLen <= 0.0) {
            throw new IllegalArgumentException("side length must be > 0");
        }
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must be a non-null value");
        }
        this.sideLen = sideLen;
        this.minX = minX;
        this.minY = minY;
        this.orientation = orientation;
        this.crs = crs;
        this.area = Hexagons.sideLengthToArea(sideLen);
        this.calculateVertices();
    }

    public double getSideLength() {
        return this.sideLen;
    }

    public double getArea() {
        return this.area;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Coordinate[] getVertices() {
        Coordinate[] copy = new Coordinate[6];
        for (int i = 0; i < 6; ++i) {
            copy[i] = new Coordinate(this.vertices[i]);
        }
        return copy;
    }

    public ReferencedEnvelope getBounds() {
        if (this.orientation == Orientation.FLAT) {
            return new ReferencedEnvelope(this.minX, this.minX + 2.0 * this.sideLen, this.minY, this.minY + ROOT3 * this.sideLen, this.crs);
        }
        return new ReferencedEnvelope(this.minX, this.minX + ROOT3 * this.sideLen, this.minY, this.minY + 2.0 * this.sideLen, this.crs);
    }

    public Coordinate getCenter() {
        if (this.orientation == Orientation.FLAT) {
            return new Coordinate(this.minX + this.sideLen, this.minY + ROOT3 * 0.5 * this.sideLen);
        }
        return new Coordinate(this.minX + ROOT3 * 0.5 * this.sideLen, this.minY + this.sideLen);
    }

    public Polygon toPolygon() {
        Coordinate[] ring = new Coordinate[7];
        for (int i = 0; i < 6; ++i) {
            ring[i] = this.vertices[i];
        }
        ring[6] = this.vertices[0];
        return geomFactory.createPolygon(geomFactory.createLinearRing(ring), null);
    }

    public Polygon toDensePolygon(double maxSpacing) {
        if (maxSpacing <= 0.0) {
            throw new IllegalArgumentException("maxSpacing must be a positive value");
        }
        return (Polygon)Densifier.densify((Geometry)this.toPolygon(), (double)maxSpacing);
    }

    private void calculateVertices() {
        if (this.orientation == null) {
            throw new IllegalStateException("Orientation must be set before calculating vertices");
        }
        this.vertices = new Coordinate[6];
        double span = ROOT3 * this.sideLen;
        if (this.orientation == Orientation.FLAT) {
            this.vertices[0] = new Coordinate(this.minX + 0.5 * this.sideLen, this.minY + span);
            this.vertices[1] = new Coordinate(this.minX + 1.5 * this.sideLen, this.minY + span);
            this.vertices[2] = new Coordinate(this.minX + 2.0 * this.sideLen, this.minY + span / 2.0);
            this.vertices[3] = new Coordinate(this.minX + 1.5 * this.sideLen, this.minY);
            this.vertices[4] = new Coordinate(this.minX + 0.5 * this.sideLen, this.minY);
            this.vertices[5] = new Coordinate(this.minX, this.minY + span / 2.0);
        } else {
            this.vertices[0] = new Coordinate(this.minX + 0.5 * span, this.minY + 2.0 * this.sideLen);
            this.vertices[1] = new Coordinate(this.minX + span, this.minY + 1.5 * this.sideLen);
            this.vertices[2] = new Coordinate(this.minX + span, this.minY + 0.5 * this.sideLen);
            this.vertices[3] = new Coordinate(this.minX + 0.5 * span, this.minY);
            this.vertices[4] = new Coordinate(this.minX, this.minY + 0.5 * this.sideLen);
            this.vertices[5] = new Coordinate(this.minX, this.minY + 1.5 * this.sideLen);
        }
    }
}

