/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegExPropertiesCollector
extends PropertiesCollector {
    private Pattern pattern;

    public RegExPropertiesCollector(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
        super(spi, propertyNames);
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public RegExPropertiesCollector collect(File file) {
        super.collect(file);
        String name = FilenameUtils.getBaseName((String)file.getAbsolutePath());
        Matcher matcher = this.pattern.matcher(name);
        while (matcher.find()) {
            this.addMatch(matcher.group());
        }
        return this;
    }
}

