/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.numeric;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.GeoTools;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.RegExPropertiesCollector;
import org.geotools.util.Converter;
import org.geotools.util.NumericConverterFactory;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NumericFileNameExtractor<N extends Number>
extends RegExPropertiesCollector {
    static final NumericConverterFactory factory = new NumericConverterFactory();
    private static final Logger LOGGER = Logging.getLogger(NumericFileNameExtractor.class);
    private Class<? extends Number> targetClasse;
    private Converter converter;

    public NumericFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex, Class<N> targetClass) {
        super(spi, propertyNames, regex);
        this.targetClasse = targetClass;
        this.converter = factory.createConverter(String.class, this.targetClasse, GeoTools.getDefaultHints());
    }

    @Override
    public void setProperties(SimpleFeature feature) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String match : this.getMatches()) {
            try {
                values.add(this.converter.convert((Object)match, this.targetClasse));
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
        }
        if (values.size() <= 0 && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No matches found for this property extractor:");
        }
        int index = 0;
        for (String propertyName : this.getPropertyNames()) {
            feature.setAttribute(propertyName, values.get(index++));
            if (index < values.size()) continue;
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongFileNameExtractor
    extends NumericFileNameExtractor<Long> {
        public LongFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
            super(spi, propertyNames, regex, Long.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteFileNameExtractor
    extends NumericFileNameExtractor<Byte> {
        public ByteFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
            super(spi, propertyNames, regex, Byte.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FloatFileNameExtractor
    extends NumericFileNameExtractor<Float> {
        public FloatFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
            super(spi, propertyNames, regex, Float.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleFileNameExtractor
    extends NumericFileNameExtractor<Double> {
        public DoubleFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
            super(spi, propertyNames, regex, Double.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ShortFileNameExtractor
    extends NumericFileNameExtractor<Short> {
        public ShortFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
            super(spi, propertyNames, regex, Short.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntegerFileNameExtractor
    extends NumericFileNameExtractor<Integer> {
        public IntegerFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
            super(spi, propertyNames, regex, Integer.class);
        }
    }
}

