/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.mysql.MySQLDialectPrepared;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class MySQLDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"mysql");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)3306);

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new MySQLDialectPrepared(dataStore);
    }

    public String getDisplayName() {
        return "MySQL";
    }

    protected String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    protected String getDatabaseID() {
        return (String)MySQLDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "MySQL Database";
    }

    protected String getValidationQuery() {
        return "select version()";
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(MySQLDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(MySQLDataStoreFactory.PORT.key, PORT);
        parameters.remove(MySQLDataStoreFactory.SCHEMA.key);
    }
}

