/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCPSFeatureWriter
extends JDBCFeatureWriter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    protected final FIDMapper mapper;
    PreparedStatement insertStatement;
    PreparedStatement deleteStatement;
    PreparedStatement updateStatement;

    public JDBCPSFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
        this.mapper = queryData.getMapper();
    }

    @Override
    protected void doInsert(MutableFIDFeature current) throws IOException, SQLException {
        LOGGER.fine("inserting into database feature " + (Object)((Object)current));
        Connection connection = this.queryData.getConnection();
        if (this.insertStatement == null) {
            SimpleFeatureType featureType = this.queryData.getFeatureType();
            this.insertStatement = this.createInsertStatement(connection, featureType);
        }
        try {
            this.fillInsertParameters(this.insertStatement, current);
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing column values";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, (Throwable)sqle);
        }
        this.executeInsert(this.insertStatement);
        String fid = this.mapper.createID(connection, (SimpleFeature)current, this.insertStatement);
        current.setID(fid);
    }

    protected void executeInsert(PreparedStatement insertStatement) throws IOException {
        try {
            insertStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception executing insert statement";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, (Throwable)sqle);
        }
    }

    private void fillInsertParameters(PreparedStatement statement, MutableFIDFeature feature) throws IOException, SQLException {
        Object[] attributes = feature.getAttributes().toArray();
        List attributeTypes = feature.getFeatureType().getAttributeDescriptors();
        AttributeIO[] aios = this.queryData.getAttributeHandlers();
        assert (attributes.length == attributeTypes.size());
        assert (attributeTypes.size() == aios.length);
        int baseIndex = this.fillPrimaryKeyParameters(statement, (SimpleFeature)feature, 1);
        for (int i = 0; i < attributeTypes.size(); ++i) {
            AttributeIO attributeIO = aios[i];
            Object attributeValue = attributes[i];
            attributeIO.write(statement, baseIndex + i, attributeValue);
        }
    }

    protected PreparedStatement createInsertStatement(Connection conn, SimpleFeatureType featureType) throws SQLException {
        AttributeDescriptor attributeDescriptor;
        int i;
        List attributeTypes = featureType.getAttributeDescriptors();
        String tableName = featureType.getTypeName();
        StringBuffer statementSQL = new StringBuffer("INSERT INTO ");
        statementSQL.append(this.encodeName(tableName)).append("(");
        int pkColumnCount = this.mapper.getColumnCount();
        if (!this.mapper.returnFIDColumnsAsAttributes()) {
            for (i = 0; i < pkColumnCount; ++i) {
                if (this.mapper.isAutoIncrement(i)) continue;
                statementSQL.append(this.mapper.getColumnName(i)).append(",");
            }
        }
        for (i = 0; i < attributeTypes.size(); ++i) {
            attributeDescriptor = (AttributeDescriptor)attributeTypes.get(i);
            String localName = attributeDescriptor.getLocalName();
            statementSQL.append(localName).append(",");
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        statementSQL.append(" VALUES (");
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            for (i = 0; i < pkColumnCount; ++i) {
                statementSQL.append("?,");
            }
        }
        for (i = 0; i < attributeTypes.size(); ++i) {
            attributeDescriptor = (AttributeDescriptor)attributeTypes.get(i);
            if (attributeDescriptor instanceof GeometryDescriptor) {
                String geometryPlaceHolder = this.getGeometryPlaceHolder(attributeDescriptor);
                statementSQL.append(geometryPlaceHolder);
            } else {
                statementSQL.append("?");
            }
            statementSQL.append(",");
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        return this.prepareInsertStatement(conn, statementSQL, featureType);
    }

    protected PreparedStatement prepareInsertStatement(Connection conn, StringBuffer statementSQL, SimpleFeatureType featureType) throws SQLException {
        return conn.prepareStatement(statementSQL.toString());
    }

    protected abstract String getGeometryPlaceHolder(AttributeDescriptor var1);

    protected void remove(MutableFIDFeature current) throws IOException, SQLException {
        LOGGER.fine("inserting into database feature " + (Object)((Object)current));
        if (this.deleteStatement != null) {
            this.deleteStatement = this.createDeleteStatement(this.queryData.getConnection(), this.queryData.getFeatureType());
        }
        try {
            this.fillDeleteParameters(this.deleteStatement, current);
            this.deleteStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, (Throwable)sqle);
        }
    }

    private void fillDeleteParameters(PreparedStatement statement, MutableFIDFeature feature) throws IOException, SQLException {
        this.fillPrimaryKeyParameters(statement, (SimpleFeature)feature, 1);
    }

    private int fillPrimaryKeyParameters(PreparedStatement statement, SimpleFeature feature, int baseIndex) throws IOException, SQLException {
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            Connection connection = this.queryData.getConnection();
            String FID = this.mapper.createID(connection, feature, null);
            Object[] primaryKey = this.mapper.getPKAttributes(FID);
            for (int i = 0; i < primaryKey.length; ++i) {
                statement.setObject(i + 1, primaryKey[i]);
            }
            baseIndex += primaryKey.length;
        }
        return baseIndex;
    }

    protected PreparedStatement createDeleteStatement(Connection conn, SimpleFeatureType featureType) throws SQLException {
        String tableName = featureType.getTypeName();
        StringBuffer statementSQL = new StringBuffer("DELETE " + tableName + "WHERE ");
        if (!this.mapper.returnFIDColumnsAsAttributes()) {
            for (int i = 0; i < this.mapper.getColumnCount(); ++i) {
                if (this.mapper.isAutoIncrement(i)) continue;
                statementSQL.append(this.mapper.getColumnName(i)).append(" = ?");
                if (i >= this.mapper.getColumnCount() - 1) continue;
                statementSQL.append(" AND ");
            }
        }
        String sql = statementSQL.toString();
        return conn.prepareStatement(sql);
    }

    private void fillUpdateParameters(PreparedStatement statement, SimpleFeature current, SimpleFeature live) throws IOException, SQLException {
        List attributes = current.getAttributes();
        List attributeTypes = current.getFeatureType().getAttributeDescriptors();
        AttributeIO[] aios = this.queryData.getAttributeHandlers();
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        for (int i = 0; i < attributeTypes.size(); ++i) {
            aios[i].write(statement, i + 1, attributes.get(i));
        }
        int baseIndex = attributeTypes.size() + 1;
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            baseIndex = this.fillPrimaryKeyParameters(statement, current, baseIndex);
        }
        this.fillPrimaryKeyParameters(statement, live, baseIndex + 1);
    }

    protected PreparedStatement createUpdateStatement(Connection conn, SimpleFeatureType featureType) throws SQLException {
        int i;
        List attributeTypes = featureType.getAttributeDescriptors();
        String tableName = featureType.getTypeName();
        StringBuffer statementSQL = new StringBuffer("UPDATE  " + tableName + " SET ");
        for (i = 0; i < attributeTypes.size(); ++i) {
            statementSQL.append(((AttributeDescriptor)attributeTypes.get(i)).getLocalName()).append(" = ");
            if (attributeTypes.get(i) instanceof GeometryDescriptor) {
                statementSQL.append(this.getGeometryPlaceHolder((AttributeDescriptor)attributeTypes.get(i)));
            } else {
                statementSQL.append("?");
            }
            statementSQL.append(",");
        }
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            for (i = 0; i < this.mapper.getColumnCount(); ++i) {
                statementSQL.append(this.mapper.getColumnName(i)).append(" = ?,");
            }
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ' ');
        statementSQL.append(" WHERE ");
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            for (i = 0; i < this.mapper.getColumnCount(); ++i) {
                statementSQL.append(this.mapper.getColumnName(i)).append(" = ?");
                if (i >= this.mapper.getColumnCount() - 1) continue;
                statementSQL.append(" AND ");
            }
        }
        String sql = statementSQL.toString();
        return conn.prepareStatement(sql);
    }

    @Override
    protected void doUpdate(SimpleFeature live, SimpleFeature current) throws IOException, SQLException {
        LOGGER.fine("updating postgis feature " + current);
        if (this.updateStatement != null) {
            this.updateStatement = this.createUpdateStatement(this.queryData.getConnection(), this.queryData.getFeatureType());
        }
        try {
            this.fillUpdateParameters(this.updateStatement, current, live);
            this.updateStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, (Throwable)sqle);
        }
    }

    @Override
    protected boolean useQueryDataForInsert() {
        return false;
    }

    @Override
    public void close() throws IOException {
        JDBCUtils.close(this.insertStatement);
        JDBCUtils.close(this.updateStatement);
        JDBCUtils.close(this.deleteStatement);
        super.close();
    }
}

