/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry;

import java.io.Serializable;
import org.geotools.geometry.jts.GeometryUtils;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPosition2D;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition1D
implements DirectPosition,
Serializable,
Cloneable {
    private CoordinateReferenceSystem crs;
    public double ordinate;

    public DirectPosition1D() {
    }

    public DirectPosition1D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition1D(double ordinate) {
        this.ordinate = ordinate;
    }

    public DirectPosition1D(DirectPosition point) {
        this.setLocation(point);
    }

    @Deprecated
    public DirectPosition getPosition() {
        return this;
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        GeometryUtils.checkDimension("dimension", crs, 1);
        this.crs = crs;
    }

    public final int getDimension() {
        return 1;
    }

    public double[] getCoordinate() {
        return new double[]{this.ordinate};
    }

    @Deprecated
    public double[] getCoordinates() {
        return this.getCoordinate();
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        if (dimension != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(dimension));
        }
        this.ordinate = value;
    }

    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        try {
            GeometryUtils.ensureDimensionMatch("position", position.getDimension(), 1);
        }
        catch (MismatchedDimensionException mismatchedDimensionException) {
            // empty catch block
        }
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.ordinate = position.getOrdinate(0);
    }

    public String toString() {
        return DirectPosition2D.toString(this, this.getCoordinates());
    }

    public int hashCode() {
        long value = Double.doubleToLongBits(this.ordinate);
        int code = (int)value ^ (int)(value >>> 32);
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    public DirectPosition1D clone() {
        try {
            return (DirectPosition1D)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

